/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.bus;

import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.wsdl.WSDLManager;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringBusFactoryTest
extends Assert {
    @Test
    public void testKnownExtensions() throws BusException {
        Bus bus = new SpringBusFactory().createBus();
        SpringBusFactoryTest.assertNotNull((Object)bus);
        this.checkBindingExtensions(bus);
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        SpringBusFactoryTest.assertNotNull((String)"No destination factory manager", (Object)dfm);
        ConduitInitiatorManager cim = (ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class);
        SpringBusFactoryTest.assertNotNull((String)"No conduit initiator manager", (Object)cim);
        this.checkTransportFactories(bus);
        this.checkOtherCoreExtensions(bus);
        SpringBusFactoryTest.assertNotNull((String)"No instrumentation manager", (Object)bus.getExtension(InstrumentationManager.class));
    }

    @Test
    public void testLoadBusWithServletApplicationContext() throws BusException {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"/org/apache/cxf/systest/bus/servlet.xml"});
        Bus bus = new SpringBusFactory((ApplicationContext)ctx).createBus();
        this.checkBindingExtensions(bus);
        this.checkHTTPTransportFactories(bus);
        this.checkOtherCoreExtensions(bus);
    }

    private void checkBindingExtensions(Bus bus) throws BusException {
        BindingFactoryManager bfm = (BindingFactoryManager)bus.getExtension(BindingFactoryManager.class);
        SpringBusFactoryTest.assertNotNull((String)"No binding factory manager", (Object)bfm);
        SpringBusFactoryTest.assertNotNull((String)"binding factory not available", (Object)bfm.getBindingFactory("http://schemas.xmlsoap.org/wsdl/soap/"));
        try {
            bfm.getBindingFactory("http://cxf.apache.org/unknown");
        }
        catch (BusException busException) {
            // empty catch block
        }
    }

    private void checkOtherCoreExtensions(Bus bus) throws BusException {
        SpringBusFactoryTest.assertNotNull((String)"No wsdl manager", (Object)bus.getExtension(WSDLManager.class));
        SpringBusFactoryTest.assertNotNull((String)"No phase manager", (Object)bus.getExtension(PhaseManager.class));
        SpringBusFactoryTest.assertNotNull((String)"No workqueue manager", (Object)bus.getExtension(WorkQueueManager.class));
        SpringBusFactoryTest.assertNotNull((String)"No lifecycle manager", (Object)bus.getExtension(BusLifeCycleManager.class));
        SpringBusFactoryTest.assertNotNull((String)"No service registry", (Object)bus.getExtension(ServerRegistry.class));
    }

    private void checkHTTPTransportFactories(Bus bus) throws BusException {
        ConduitInitiatorManager cim = (ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class);
        SpringBusFactoryTest.assertNotNull((String)"No conduit initiator manager", (Object)cim);
        SpringBusFactoryTest.assertNotNull((String)"conduit initiator not available", (Object)cim.getConduitInitiator("http://schemas.xmlsoap.org/wsdl/soap/http"));
        SpringBusFactoryTest.assertNotNull((String)"conduit initiator not available", (Object)cim.getConduitInitiator("http://schemas.xmlsoap.org/wsdl/http/"));
        SpringBusFactoryTest.assertNotNull((String)"conduit initiator not available", (Object)cim.getConduitInitiator("http://cxf.apache.org/transports/http/configuration"));
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        SpringBusFactoryTest.assertNotNull((String)"No destination factory manager", (Object)dfm);
        SpringBusFactoryTest.assertNotNull((String)"destination factory not available", (Object)dfm.getDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/"));
        SpringBusFactoryTest.assertNotNull((String)"destination factory not available", (Object)dfm.getDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/http"));
        SpringBusFactoryTest.assertNotNull((String)"destination factory not available", (Object)dfm.getDestinationFactory("http://schemas.xmlsoap.org/wsdl/http/"));
        SpringBusFactoryTest.assertNotNull((String)"destination factory not available", (Object)dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration"));
    }

    private void checkTransportFactories(Bus bus) throws BusException {
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        SpringBusFactoryTest.assertNotNull((String)"No destination factory manager", (Object)dfm);
        ConduitInitiatorManager cim = (ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class);
        SpringBusFactoryTest.assertNotNull((String)"No conduit initiator manager", (Object)cim);
        try {
            cim.getConduitInitiator("http://cxf.apache.org/unknown");
        }
        catch (BusException ex) {
            // empty catch block
        }
        try {
            dfm.getDestinationFactory("http://cxf.apache.org/unknown");
        }
        catch (BusException ex) {
            // empty catch block
        }
        SpringBusFactoryTest.assertNotNull((String)"conduit initiator not available", (Object)cim.getConduitInitiator("http://cxf.apache.org/bindings/xformat"));
        SpringBusFactoryTest.assertNotNull((String)"conduit initiator not available", (Object)cim.getConduitInitiator("http://cxf.apache.org/transports/jms"));
        SpringBusFactoryTest.assertNotNull((String)"conduit initiator not available", (Object)cim.getConduitInitiator("http://cxf.apache.org/transports/jms/configuration"));
        SpringBusFactoryTest.assertNotNull((String)"destination factory not available", (Object)dfm.getDestinationFactory("http://cxf.apache.org/bindings/xformat"));
        SpringBusFactoryTest.assertNotNull((String)"destination factory not available", (Object)dfm.getDestinationFactory("http://cxf.apache.org/transports/jms"));
        SpringBusFactoryTest.assertNotNull((String)"destination factory not available", (Object)dfm.getDestinationFactory("http://cxf.apache.org/transports/jms/configuration"));
    }
}

