/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.coloc;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Service;
import org.apache.commons.logging.Log;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColocTest
extends Assert {
    protected Bus bus;
    protected Endpoint endpoint;

    @Before
    public void setUp() throws Exception {
        URL cxfConfig = null;
        if (this.getCxfConfig() != null) {
            cxfConfig = ClassLoaderUtils.getResource((String)this.getCxfConfig(), AbstractColocTest.class);
            if (cxfConfig == null) {
                throw new Exception("Make sure " + this.getCxfConfig() + " is in the CLASSPATH");
            }
            AbstractColocTest.assertTrue((cxfConfig.toExternalForm() != null ? 1 : 0) != 0);
        }
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus(cxfConfig);
        BusFactory.setDefaultBus((Bus)this.bus);
        this.endpoint = Endpoint.publish((String)this.getTransportURI(), (Object)this.getServiceImpl());
    }

    @After
    public void tearDown() throws Exception {
        this.getLogger().debug((Object)"tearDown ...");
        if (this.endpoint != null) {
            this.endpoint.stop();
        }
        if (this.bus != null) {
            this.bus.shutdown(true);
        }
    }

    protected String getCxfConfig() {
        return "org/apache/cxf/systest/coloc/cxf.xml";
    }

    protected <T> T getPort(QName serviceName, QName portName, String wsdlLocation, Class<T> cls) {
        Service srv = Service.create((URL)AbstractColocTest.class.getResource(wsdlLocation), (QName)serviceName);
        return (T)srv.getPort(portName, cls);
    }

    protected abstract Object getServiceImpl();

    protected abstract Log getLogger();

    protected abstract String getTransportURI();
}

