/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.coloc;

import java.util.ResourceBundle;
import javax.xml.ws.Holder;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.interceptor.Fault;
import org.apache.headers.coloc.types.FaultDetailT;
import org.apache.headers.coloc.types.HeaderInfo;
import org.apache.headers.coloc.types.InHeaderResponseT;
import org.apache.headers.coloc.types.InHeaderT;
import org.apache.headers.coloc.types.InoutHeaderResponseT;
import org.apache.headers.coloc.types.InoutHeaderT;
import org.apache.headers.coloc.types.OutHeaderResponseT;
import org.apache.headers.coloc.types.OutHeaderT;
import org.apache.headers.doc_lit.HeaderTester;
import org.apache.headers.doc_lit.PingMeFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseHeaderTesterDocLitImpl
implements HeaderTester {
    private Log logger;

    public InHeaderResponseT inHeader(InHeaderT me, HeaderInfo headerInfo) {
        this.getLogger().debug((Object)"Server: inHeader called");
        Assert.assertEquals((String)"in request type", (String)me.getRequestType());
        Assert.assertEquals((String)"in message", (String)headerInfo.getMessage());
        Assert.assertEquals((String)"in originator", (String)headerInfo.getOriginator());
        InHeaderResponseT inHeaderResponse = new InHeaderResponseT();
        inHeaderResponse.setResponseType("out Header type");
        return inHeaderResponse;
    }

    public InoutHeaderResponseT inoutHeader(InoutHeaderT me, Holder<HeaderInfo> headerInfo) {
        this.getLogger().debug((Object)"Server: inoutHeader called");
        Assert.assertEquals((String)"inout request type in", (String)me.getRequestType());
        Assert.assertEquals((String)"inout message in", (String)((HeaderInfo)headerInfo.value).getMessage());
        Assert.assertEquals((String)"inout originator in", (String)((HeaderInfo)headerInfo.value).getOriginator());
        HeaderInfo out = new HeaderInfo();
        out.setMessage("inout message out");
        out.setOriginator("inout orginator out");
        headerInfo.value = out;
        InoutHeaderResponseT inoutHeaderResponse = new InoutHeaderResponseT();
        inoutHeaderResponse.setResponseType("inout request type out");
        return inoutHeaderResponse;
    }

    public void outHeader(OutHeaderT me, Holder<OutHeaderResponseT> theResponse, Holder<HeaderInfo> headerInfo) {
        this.getLogger().debug((Object)"Server: outHeader called");
        Assert.assertEquals((String)"out request test", (String)me.getRequestType());
        HeaderInfo out = new HeaderInfo();
        out.setMessage("out message out");
        out.setOriginator("out orginator out");
        headerInfo.value = out;
        OutHeaderResponseT resp = new OutHeaderResponseT();
        resp.setResponseType("out Header type");
        theResponse.value = resp;
    }

    public void pingMe(String msgType) throws PingMeFault {
        this.getLogger().debug((Object)("Server: in pingMe:" + msgType));
        if ("USER".equals(msgType)) {
            FaultDetailT detail = new FaultDetailT();
            detail.setMajor((short)1);
            detail.setMinor((short)2);
            throw new PingMeFault("USER FAULT TEST", detail);
        }
        if ("SYSTEM".equals(msgType)) {
            throw new Fault(new Message("CXF RUNTIME EXCEPTION", (ResourceBundle)null, new Object[]{"FAULT TEST"}));
        }
        if ("RUNTIME".equals(msgType)) {
            throw new IllegalArgumentException("CXF RUNTIME EXCEPTION");
        }
    }

    public void init(Log log) {
        this.logger = log;
    }

    protected Log getLogger() {
        return this.logger;
    }
}

