/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.factory_pattern;

import java.util.HashMap;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Service;
import org.apache.cxf.factory_pattern.Number;
import org.apache.cxf.factory_pattern.NumberFactory;
import org.apache.cxf.factory_pattern.NumberFactoryService;
import org.apache.cxf.factory_pattern.NumberService;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.jaxws.support.ServiceDelegateAccessor;
import org.apache.cxf.systest.factory_pattern.NumberFactoryImpl;
import org.apache.cxf.systest.jms.EmbeddedJMSBrokerLauncher;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.junit.BeforeClass;
import org.junit.Test;

public class MultiplexClientServerTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        MultiplexClientServerTest.createStaticBus((String)"org/apache/cxf/systest/ws/addressing/cxf.xml");
        HashMap<String, String> props = new HashMap<String, String>();
        if (System.getProperty("activemq.store.dir") != null) {
            props.put("activemq.store.dir", System.getProperty("activemq.store.dir"));
        }
        props.put("java.util.logging.config.file", System.getProperty("java.util.logging.config.file"));
        MultiplexClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)MultiplexClientServerTest.launchServer(EmbeddedJMSBrokerLauncher.class, props, null));
        props.put("cxf.config.file", defaultConfigFileName);
        MultiplexClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)MultiplexClientServerTest.launchServer(Server.class, props, null));
    }

    @Test
    public void testWithGetPortExtensionHttp() throws Exception {
        NumberFactoryService service = new NumberFactoryService();
        NumberFactory factory = service.getNumberFactoryPort();
        NumberService numService = new NumberService();
        ServiceImpl serviceImpl = ServiceDelegateAccessor.get((Service)numService);
        EndpointReferenceType numberTwoRef = factory.create("20");
        MultiplexClientServerTest.assertNotNull((String)"reference", (Object)numberTwoRef);
        Number num = (Number)serviceImpl.getPort(numberTwoRef, Number.class);
        MultiplexClientServerTest.assertTrue((String)"20 is even", (boolean)num.isEven().isEven());
        EndpointReferenceType numberTwentyThreeRef = factory.create("23");
        num = (Number)serviceImpl.getPort(numberTwentyThreeRef, Number.class);
        MultiplexClientServerTest.assertTrue((String)"23 is not even", (!num.isEven().isEven() ? 1 : 0) != 0);
    }

    @Test
    public void testWithGetPortExtensionOverJMS() throws Exception {
        NumberFactoryService service = new NumberFactoryService();
        NumberFactory factory = service.getNumberFactoryPort();
        NumberService numService = new NumberService();
        EndpointReferenceType ref = factory.create("999");
        MultiplexClientServerTest.assertNotNull((String)"reference", (Object)ref);
        ServiceImpl serviceImpl = ServiceDelegateAccessor.get((Service)numService);
        Number num = (Number)serviceImpl.getPort(ref, Number.class);
        try {
            num.isEven().isEven();
            MultiplexClientServerTest.fail((String)"there should be a fault on val 999");
        }
        catch (Exception expected) {
            MultiplexClientServerTest.assertTrue((String)"match on exception message", (expected.getMessage().indexOf("999") != -1 ? 1 : 0) != 0);
        }
        ref = factory.create("37");
        MultiplexClientServerTest.assertNotNull((String)"reference", (Object)ref);
        num = (Number)serviceImpl.getPort(ref, Number.class);
        MultiplexClientServerTest.assertTrue((String)"37 is not even", (!num.isEven().isEven() ? 1 : 0) != 0);
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            NumberFactoryImpl implementor = new NumberFactoryImpl();
            Endpoint.publish((String)"http://localhost:9006/NumberFactoryService/NumberFactoryPort", (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

