/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.handlers;

import java.lang.reflect.UndeclaredThrowableException;
import javax.xml.ws.Endpoint;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.GreeterService;
import org.apache.cxf.systest.handlers.TrivialSOAPHandlerAnnotatedGreeterImpl;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class TrivialSOAPHandlerTest
extends AbstractClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        TrivialSOAPHandlerTest.assertTrue((String)"server did not launch correctly", (boolean)TrivialSOAPHandlerTest.launchServer(Server.class));
    }

    @Test
    public void testInvocation() throws Exception {
        GreeterService service = new GreeterService();
        TrivialSOAPHandlerTest.assertNotNull((Object)service);
        try {
            Greeter greeter = service.getGreeterPort();
            String greeting = greeter.greetMe("Bonjour");
            TrivialSOAPHandlerTest.assertNotNull((String)"no response received from service", (Object)greeting);
            TrivialSOAPHandlerTest.assertEquals((Object)"BONJOUR", (Object)greeting);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            TrivialSOAPHandlerAnnotatedGreeterImpl implementor = new TrivialSOAPHandlerAnnotatedGreeterImpl();
            String address = "http://localhost:9020/SoapContext/GreeterPort";
            Endpoint.publish((String)address, (Object)((Object)implementor));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

