/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.message.Message;
import org.apache.cxf.systest.http.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HttpBasicAuthSupplier;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.URLConnectionInfo;
import org.apache.cxf.transport.http.UntrustedURLConnectionIOException;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.hello_world.Greeter;
import org.apache.hello_world.services.SOAPService;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class HTTPConduitTest
extends AbstractBusClientServerTestBase {
    private static final boolean IN_PROCESS = true;
    private static TLSClientParameters tlsClientParameters = new TLSClientParameters();
    private static Map<String, String> addrMap = new TreeMap<String, String>();
    private static List<String> servers = new ArrayList<String>();
    private final QName serviceName = new QName("http://apache.org/hello_world", "SOAPService");
    private final QName bethalQ = new QName("http://apache.org/hello_world", "Bethal");
    private final QName gordyQ = new QName("http://apache.org/hello_world", "Gordy");
    private final QName tarpinQ = new QName("http://apache.org/hello_world", "Tarpin");
    private final QName rethwelQ = new QName("http://apache.org/hello_world", "Rethwel");
    private final QName mortimerQ = new QName("http://apache.org/hello_world", "Mortimer");
    private final QName poltimQ = new QName("http://apache.org/hello_world", "Poltim");
    private final QName hurlonQ = new QName("http://apache.org/hello_world", "Hurlon");

    public static synchronized boolean startServer(String name) {
        if (servers.contains(name)) {
            return true;
        }
        URL serverC = Server.class.getResource("resources/" + name + ".cxf");
        boolean server = HTTPConduitTest.launchServer(Server.class, null, (String[])new String[]{name, addrMap.get(name), serverC.toString()}, (boolean)true);
        if (server) {
            servers.add(name);
        }
        return server;
    }

    @BeforeClass
    public static void setProps() {
        System.setProperty("org.apache.cxf.bus.factory", "org.apache.cxf.bus.CXFBusFactory");
    }

    public static KeyStore getKeyStore(String ksType, String file, String ksPassword) throws GeneralSecurityException, IOException {
        String type = ksType != null ? ksType : KeyStore.getDefaultType();
        char[] password = ksPassword != null ? ksPassword.toCharArray() : null;
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(new FileInputStream(file), password);
        return keyStore;
    }

    public static KeyManager[] getKeyManagers(KeyStore keyStore, String keyPassword) throws GeneralSecurityException, IOException {
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        char[] keyPass = keyPassword != null ? keyPassword.toCharArray() : null;
        KeyManagerFactory fac = KeyManagerFactory.getInstance(alg);
        fac.init(keyStore, keyPass);
        return fac.getKeyManagers();
    }

    public static TrustManager[] getTrustManagers(KeyStore keyStore) throws GeneralSecurityException, IOException {
        String alg = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory fac = TrustManagerFactory.getInstance(alg);
        fac.init(keyStore);
        return fac.getTrustManagers();
    }

    @Test
    public void testBasicConnection() throws Exception {
        HTTPConduitTest.startServer("Mortimer");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("resources/greeting.wsdl");
        HTTPConduitTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        HTTPConduitTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter mortimer = (Greeter)service.getPort(this.mortimerQ, Greeter.class);
        HTTPConduitTest.assertNotNull((String)"Port is null", (Object)mortimer);
        String answer = mortimer.sayHi();
        HTTPConduitTest.assertTrue((String)("Unexpected answer: " + answer), (boolean)"Bonjour from Mortimer".equals(answer));
    }

    @Test
    public void testHttp2HttpRedirectFail() throws Exception {
        HTTPConduitTest.startServer("Mortimer");
        HTTPConduitTest.startServer("Rethwel");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("resources/greeting.wsdl");
        HTTPConduitTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        HTTPConduitTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter rethwel = (Greeter)service.getPort(this.rethwelQ, Greeter.class);
        HTTPConduitTest.assertNotNull((String)"Port is null", (Object)rethwel);
        String answer = null;
        try {
            answer = rethwel.sayHi();
            HTTPConduitTest.fail((String)("Redirect didn't fail. Got answer: " + answer));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testHttp2HttpRedirect() throws Exception {
        HTTPConduitTest.startServer("Mortimer");
        HTTPConduitTest.startServer("Rethwel");
        URL config = ((Object)((Object)this)).getClass().getResource("resources/Http2HttpRedirect.cxf");
        new DefaultBusFactory().createBus(config);
        URL wsdl = ((Object)((Object)this)).getClass().getResource("resources/greeting.wsdl");
        HTTPConduitTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        HTTPConduitTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter rethwel = (Greeter)service.getPort(this.rethwelQ, Greeter.class);
        HTTPConduitTest.assertNotNull((String)"Port is null", (Object)rethwel);
        String answer = rethwel.sayHi();
        HTTPConduitTest.assertTrue((String)("Unexpected answer: " + answer), (boolean)"Bonjour from Mortimer".equals(answer));
    }

    @Test
    public void testHttp2HttpLoopRedirectFail() throws Exception {
        HTTPConduitTest.startServer("Abost");
        HTTPConduitTest.startServer("Hurlon");
        URL config = ((Object)((Object)this)).getClass().getResource("resources/Http2HttpLoopRedirectFail.cxf");
        new DefaultBusFactory().createBus(config);
        URL wsdl = ((Object)((Object)this)).getClass().getResource("resources/greeting.wsdl");
        HTTPConduitTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        HTTPConduitTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter hurlon = (Greeter)service.getPort(this.hurlonQ, Greeter.class);
        HTTPConduitTest.assertNotNull((String)"Port is null", (Object)hurlon);
        String answer = null;
        try {
            answer = hurlon.sayHi();
            HTTPConduitTest.fail((String)("Redirect didn't fail. Got answer: " + answer));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testHttpsBasicConnectionWithConfig() throws Exception {
        HTTPConduitTest.startServer("Bethal");
        URL config = ((Object)((Object)this)).getClass().getResource("resources/BethalClientConfig.cxf");
        new DefaultBusFactory().createBus(config);
        URL wsdl = ((Object)((Object)this)).getClass().getResource("resources/greeting.wsdl");
        HTTPConduitTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        HTTPConduitTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter bethal = (Greeter)service.getPort(this.bethalQ, Greeter.class);
        HTTPConduitTest.assertNotNull((String)"Port is null", (Object)bethal);
        this.verifyBethalClient(bethal);
    }

    @Test
    public void testGetClientFromSpringContext() throws Exception {
        HTTPConduitTest.startServer("Bethal");
        BusFactory.setDefaultBus(null);
        URL beans = ((Object)((Object)this)).getClass().getResource("resources/BethalClientBeans.xml");
        Bus bus = new DefaultBusFactory().createBus(beans);
        ApplicationContext context = (ApplicationContext)bus.getExtension(BusApplicationContext.class);
        Greeter bethal = (Greeter)context.getBean("Bethal");
        this.verifyBethalClient(bethal);
    }

    private void verifyBethalClient(Greeter bethal) {
        Client client = ClientProxy.getClient((Object)bethal);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = http.getClient();
        HTTPConduitTest.assertEquals((String)"the httpClientPolicy's autoRedirect should be true", (Object)true, (Object)httpClientPolicy.isAutoRedirect());
        TLSClientParameters tlsParameters = http.getTlsClientParameters();
        HTTPConduitTest.assertNotNull((String)"the http conduit's tlsParameters should not be null", (Object)tlsParameters);
        AuthorizationPolicy authPolicy = http.getAuthorization();
        HTTPConduitTest.assertEquals((String)"Set the wrong user name from the configuration", (Object)"Betty", (Object)authPolicy.getUserName());
        HTTPConduitTest.assertEquals((String)"Set the wrong pass word form the configuration", (Object)"password", (Object)authPolicy.getPassword());
        String answer = bethal.sayHi();
        HTTPConduitTest.assertTrue((String)("Unexpected answer: " + answer), (boolean)"Bonjour from Bethal".equals(answer));
    }

    @Test
    public void testHttpsBasicConnection() throws Exception {
        HTTPConduitTest.startServer("Bethal");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("resources/greeting.wsdl");
        HTTPConduitTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        HTTPConduitTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter bethal = (Greeter)service.getPort(this.bethalQ, Greeter.class);
        HTTPConduitTest.assertNotNull((String)"Port is null", (Object)bethal);
        Client client = ClientProxy.getClient((Object)bethal);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setAutoRedirect(false);
        AuthorizationPolicy authPolicy = new AuthorizationPolicy();
        authPolicy.setUserName("Betty");
        authPolicy.setPassword("password");
        http.setClient(httpClientPolicy);
        http.setTlsClientParameters(tlsClientParameters);
        http.setAuthorization(authPolicy);
        String answer = bethal.sayHi();
        HTTPConduitTest.assertTrue((String)("Unexpected answer: " + answer), (boolean)"Bonjour from Bethal".equals(answer));
    }

    @Test
    public void testHttpsRedirectToHttpFail() throws Exception {
        HTTPConduitTest.startServer("Mortimer");
        HTTPConduitTest.startServer("Poltim");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("resources/greeting.wsdl");
        HTTPConduitTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        HTTPConduitTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter poltim = (Greeter)service.getPort(this.poltimQ, Greeter.class);
        HTTPConduitTest.assertNotNull((String)"Port is null", (Object)poltim);
        Client client = ClientProxy.getClient((Object)poltim);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setAutoRedirect(true);
        http.setClient(httpClientPolicy);
        http.setTlsClientParameters(tlsClientParameters);
        try {
            String answer = poltim.sayHi();
            HTTPConduitTest.fail((String)("Unexpected answer from Poltim: " + answer));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testHttpsTrust() throws Exception {
        HTTPConduitTest.startServer("Bethal");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("resources/greeting.wsdl");
        HTTPConduitTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        HTTPConduitTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter bethal = (Greeter)service.getPort(this.bethalQ, Greeter.class);
        HTTPConduitTest.assertNotNull((String)"Port is null", (Object)bethal);
        Client client = ClientProxy.getClient((Object)bethal);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setAutoRedirect(false);
        AuthorizationPolicy authPolicy = new AuthorizationPolicy();
        authPolicy.setUserName("Betty");
        authPolicy.setPassword("password");
        http.setClient(httpClientPolicy);
        http.setTlsClientParameters(tlsClientParameters);
        http.setAuthorization(authPolicy);
        http.setTrustDecider((MessageTrustDecider)new MyHttpsTrustDecider("Bethal"));
        String answer = bethal.sayHi();
        HTTPConduitTest.assertTrue((String)("Unexpected answer: " + answer), (boolean)"Bonjour from Bethal".equals(answer));
        MyHttpsTrustDecider trustDecider = new MyHttpsTrustDecider("Nobody");
        http.setTrustDecider((MessageTrustDecider)trustDecider);
        try {
            answer = bethal.sayHi();
            HTTPConduitTest.fail((String)("Unexpected answer from Bethal: " + answer));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testHttpsTrustRedirect() throws Exception {
        HTTPConduitTest.startServer("Tarpin");
        HTTPConduitTest.startServer("Gordy");
        HTTPConduitTest.startServer("Bethal");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("resources/greeting.wsdl");
        HTTPConduitTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        HTTPConduitTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter tarpin = (Greeter)service.getPort(this.tarpinQ, Greeter.class);
        HTTPConduitTest.assertNotNull((String)"Port is null", (Object)tarpin);
        Client client = ClientProxy.getClient((Object)tarpin);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setAutoRedirect(true);
        AuthorizationPolicy authPolicy = new AuthorizationPolicy();
        authPolicy.setUserName("Betty");
        authPolicy.setPassword("password");
        http.setClient(httpClientPolicy);
        http.setTlsClientParameters(tlsClientParameters);
        http.setAuthorization(authPolicy);
        MyHttpsTrustDecider trustDecider = new MyHttpsTrustDecider(new String[]{"Tarpin", "Gordy", "Bethal"});
        http.setTrustDecider((MessageTrustDecider)trustDecider);
        String answer = tarpin.sayHi();
        HTTPConduitTest.assertTrue((String)"Trust Decider wasn't called correctly", (3 == trustDecider.wasCalled() ? 1 : 0) != 0);
        HTTPConduitTest.assertTrue((String)("Unexpected answer: " + answer), (boolean)"Bonjour from Bethal".equals(answer));
        http.getClient().setMaxRetransmits(1);
        try {
            answer = tarpin.sayHi();
            HTTPConduitTest.fail((String)("Unexpected answer from Tarpin: " + answer));
        }
        catch (Exception e) {
            // empty catch block
        }
        http.getClient().setMaxRetransmits(-1);
        trustDecider = new MyHttpsTrustDecider(new String[]{"Tarpin", "Bethal"});
        http.setTrustDecider((MessageTrustDecider)trustDecider);
        try {
            answer = tarpin.sayHi();
            HTTPConduitTest.fail((String)("Unexpected answer from Tarpin: " + answer));
        }
        catch (Exception e) {
            HTTPConduitTest.assertTrue((String)"Trust Decider wasn't called correctly", (2 == trustDecider.wasCalled() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHttpsRedirect401Response() throws Exception {
        HTTPConduitTest.startServer("Gordy");
        HTTPConduitTest.startServer("Bethal");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("resources/greeting.wsdl");
        HTTPConduitTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        HTTPConduitTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter gordy = (Greeter)service.getPort(this.gordyQ, Greeter.class);
        HTTPConduitTest.assertNotNull((String)"Port is null", (Object)gordy);
        Client client = ClientProxy.getClient((Object)gordy);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setAutoRedirect(true);
        http.setClient(httpClientPolicy);
        http.setTlsClientParameters(tlsClientParameters);
        http.setTrustDecider((MessageTrustDecider)new MyHttpsTrustDecider(new String[]{"Gordy", "Bethal"}));
        http.setBasicAuthSupplier((HttpBasicAuthSupplier)new MyBasicAuthSupplier("Cronus", "Betty", "password"));
        String answer = gordy.sayHi();
        HTTPConduitTest.assertTrue((String)("Unexpected answer: " + answer), (boolean)"Bonjour from Bethal".equals(answer));
        http.setBasicAuthSupplier((HttpBasicAuthSupplier)new MyBasicAuthSupplier());
        try {
            answer = gordy.sayHi();
            HTTPConduitTest.fail((String)("Unexpected answer from Gordy: " + answer));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static {
        addrMap.put("Mortimer", "http://localhost:9000/");
        addrMap.put("Tarpin", "https://localhost:9003/");
        addrMap.put("Rethwel", "http://localhost:9004/");
        addrMap.put("Poltim", "https://localhost:9005/");
        addrMap.put("Gordy", "https://localhost:9001/");
        addrMap.put("Bethal", "https://localhost:9002/");
        addrMap.put("Abost", "http://localhost:9007/");
        addrMap.put("Hurlon", "http://localhost:9006/");
        addrMap.put("Morpit", "https://localhost:9008/");
        tlsClientParameters.setDisableCNCheck(true);
        try {
            String keystore = Server.class.getResource("resources/Morpit.jks").getFile();
            KeyManager[] kmgrs = HTTPConduitTest.getKeyManagers(HTTPConduitTest.getKeyStore("JKS", keystore, "password"), "password");
            String truststore = Server.class.getResource("resources/Truststore.jks").getFile();
            TrustManager[] tmgrs = HTTPConduitTest.getTrustManagers(HTTPConduitTest.getKeyStore("JKS", truststore, "password"));
            tlsClientParameters.setKeyManagers(kmgrs);
            tlsClientParameters.setTrustManagers(tmgrs);
            FiltersType filters = new FiltersType();
            filters.getInclude().add(".*_EXPORT_.*");
            filters.getInclude().add(".*_EXPORT1024_.*");
            filters.getInclude().add(".*_WITH_DES_.*");
            filters.getInclude().add(".*_WITH_NULL_.*");
            filters.getInclude().add(".*_DH_anon_.*");
            tlsClientParameters.setCipherSuitesFilter(filters);
        }
        catch (Exception e) {
            throw new RuntimeException("Static initialization failed", e);
        }
    }

    public class MyBasicAuthSupplier
    extends HttpBasicAuthSupplier {
        String realm;
        String user;
        String pass;

        MyBasicAuthSupplier() {
        }

        MyBasicAuthSupplier(String r, String u, String p) {
            this.realm = r;
            this.user = u;
            this.pass = p;
        }

        public HttpBasicAuthSupplier.UserPass getPreemptiveUserPass(String conduitName, URL currentURL, Message message) {
            return null;
        }

        public HttpBasicAuthSupplier.UserPass getUserPassForRealm(String conduitName, URL currentURL, Message message, String reqestedRealm) {
            if (this.realm != null && this.realm.equals(reqestedRealm)) {
                return this.createUserPass(this.user, this.pass);
            }
            if ("Andromeda".equals(reqestedRealm)) {
                return this.createUserPass("Edward", "password");
            }
            if ("Zorantius".equals(reqestedRealm)) {
                return this.createUserPass("George", "password");
            }
            if ("Cronus".equals(reqestedRealm)) {
                return this.createUserPass("Mary", "password");
            }
            return null;
        }
    }

    class MyHttpsTrustDecider
    extends MessageTrustDecider {
        private String[] trustName;
        private int called;

        MyHttpsTrustDecider(String name) {
            this.trustName = new String[]{name};
        }

        MyHttpsTrustDecider(String[] name) {
            this.trustName = name;
        }

        public int wasCalled() {
            return this.called;
        }

        public void establishTrust(String conduitName, URLConnectionInfo cinfo, Message message) throws UntrustedURLConnectionIOException {
            ++this.called;
            HttpsURLConnectionInfo ci = (HttpsURLConnectionInfo)cinfo;
            boolean trusted = false;
            for (int i = 0; i < this.trustName.length; ++i) {
                trusted = trusted || ((Object)ci.getPeerPrincipal()).toString().contains("OU=" + this.trustName[i]);
            }
            if (!trusted) {
                throw new UntrustedURLConnectionIOException("Peer Principal \"" + ci.getPeerPrincipal() + "\" does not contain " + this.getTrustNames());
            }
        }

        private String getTrustNames() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.trustName.length; ++i) {
                sb.append("\"OU=");
                sb.append(this.trustName[i]);
                sb.append("\"");
                if (i >= this.trustName.length - 1) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
    }

    class DefaultBusFactory
    extends SpringBusFactory {
        DefaultBusFactory() {
        }

        public Bus createBus(URL config) {
            Bus bus = super.createBus(config, true);
            BusFactory.setDefaultBus((Bus)bus);
            BusFactory.setThreadDefaultBus((Bus)bus);
            return bus;
        }
    }
}

