/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http;

import javax.xml.ws.BindingProvider;
import org.apache.cxf.BusFactory;
import org.apache.cxf.systest.http.BusServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world.Greeter;
import org.apache.hello_world.services.SOAPService;
import org.junit.Test;

public class HTTPSClientTest
extends AbstractBusClientServerTestBase {
    private void setTheConfiguration(String config) {
        try {
            System.setProperty("cxf.config.file.url", HTTPSClientTest.class.getResource(config).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startServers() throws Exception {
        HTTPSClientTest.assertTrue((String)"Server failed to launch", (boolean)HTTPSClientTest.launchServer(BusServer.class, (boolean)true));
    }

    public void stopServers() throws Exception {
        HTTPSClientTest.stopAllServers();
        System.clearProperty("cxf.config.file.url");
        BusFactory.setDefaultBus(null);
        BusFactory.setThreadDefaultBus(null);
    }

    public final void testSuccessfulCall(String configuration, String address) throws Exception {
        this.setTheConfiguration(configuration);
        this.startServers();
        SOAPService service = new SOAPService();
        HTTPSClientTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter port = service.getHttpsPort();
        HTTPSClientTest.assertNotNull((String)"Port is null", (Object)port);
        BindingProvider provider = (BindingProvider)port;
        provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", address);
        HTTPSClientTest.assertEquals((Object)port.greetMe("Kitty"), (Object)"Hello Kitty");
        this.stopServers();
    }

    @Test
    public final void testJaxwsServer() throws Exception {
        this.testSuccessfulCall("resources/jaxws-server.xml", "https://localhost:9002/SoapContext/HttpsPort");
    }

    @Test
    public final void testJaxwsEndpoint() throws Exception {
        this.testSuccessfulCall("resources/jaxws-publish.xml", "https://localhost:9001/SoapContext/HttpsPort");
    }

    @Test
    public final void testPKCS12Endpoint() throws Exception {
        this.testSuccessfulCall("resources/pkcs12.xml", "https://localhost:9003/SoapContext/HttpsPort");
    }

    @Test
    public final void testResourceKeySpecEndpoint() throws Exception {
        this.testSuccessfulCall("resources/resource-key-spec.xml", "https://localhost:9004/SoapContext/HttpsPort");
    }
}

