/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jms;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.hello_world_jms.BadRecordLitFault;
import org.apache.cxf.hello_world_jms.HWByteMsgService;
import org.apache.cxf.hello_world_jms.HelloWorldOneWayPort;
import org.apache.cxf.hello_world_jms.HelloWorldOneWayQueueService;
import org.apache.cxf.hello_world_jms.HelloWorldPortType;
import org.apache.cxf.hello_world_jms.HelloWorldPubSubPort;
import org.apache.cxf.hello_world_jms.HelloWorldPubSubService;
import org.apache.cxf.hello_world_jms.HelloWorldService;
import org.apache.cxf.hello_world_jms.NoSuchCodeLitFault;
import org.apache.cxf.systest.jms.EmbeddedJMSBrokerLauncher;
import org.apache.cxf.systest.jms.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSPropertyType;
import org.apache.hello_world_doc_lit.Greeter;
import org.apache.hello_world_doc_lit.PingMeFault;
import org.apache.hello_world_doc_lit.SOAPService2;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JMSClientServerTest
extends AbstractBusClientServerTestBase {
    protected static boolean serversStarted;

    @Before
    public void startServers() throws Exception {
        if (serversStarted) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (System.getProperty("activemq.store.dir") != null) {
            props.put("activemq.store.dir", System.getProperty("activemq.store.dir"));
        }
        props.put("java.util.logging.config.file", System.getProperty("java.util.logging.config.file"));
        JMSClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)JMSClientServerTest.launchServer(EmbeddedJMSBrokerLauncher.class, props, null));
        JMSClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)JMSClientServerTest.launchServer(Server.class, (boolean)false));
        serversStarted = true;
    }

    public URL getWSDLURL(String s) throws Exception {
        return ((Object)((Object)this)).getClass().getResource(s);
    }

    public QName getServiceName(QName q) {
        return q;
    }

    public QName getPortName(QName q) {
        return q;
    }

    @Test
    public void testDocBasicConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://apache.org/hello_world_doc_lit", "SOAPService2"));
        QName portName = this.getPortName(new QName("http://apache.org/hello_world_doc_lit", "SoapPort2"));
        URL wsdl = this.getWSDLURL("/wsdl/hello_world_doc_lit.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        SOAPService2 service = new SOAPService2(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            Greeter greeter = (Greeter)service.getPort(portName, Greeter.class);
            for (int idx = 0; idx < 5; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                JMSClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                JMSClientServerTest.assertEquals((Object)response2, (Object)reply);
                try {
                    greeter.pingMe();
                    JMSClientServerTest.fail((String)"Should have thrown FaultException");
                    continue;
                }
                catch (PingMeFault ex) {
                    JMSClientServerTest.assertNotNull((Object)ex.getFaultInfo());
                }
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testBasicConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPort"));
        URL wsdl = this.getWSDLURL("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldService service = new HelloWorldService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            HelloWorldPortType greeter = (HelloWorldPortType)service.getPort(portName, HelloWorldPortType.class);
            for (int idx = 0; idx < 5; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                JMSClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                JMSClientServerTest.assertEquals((Object)response2, (Object)reply);
                try {
                    greeter.testRpcLitFault("BadRecordLitFault");
                    JMSClientServerTest.fail((String)"Should have thrown BadRecoedLitFault");
                }
                catch (BadRecordLitFault ex) {
                    JMSClientServerTest.assertNotNull((Object)ex.getFaultInfo());
                }
                try {
                    greeter.testRpcLitFault("NoSuchCodeLitFault");
                    JMSClientServerTest.fail((String)"Should have thrown NoSuchCodeLitFault exception");
                    continue;
                }
                catch (NoSuchCodeLitFault nslf) {
                    JMSClientServerTest.assertNotNull((Object)nslf.getFaultInfo());
                    JMSClientServerTest.assertNotNull((Object)nslf.getFaultInfo().getCode());
                }
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testByteMessage() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HWByteMsgService"));
        URL wsdl = this.getWSDLURL("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HWByteMsgService service = new HWByteMsgService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            HelloWorldPortType greeter = service.getHWSByteMsgPort();
            for (int idx = 0; idx < 2; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                JMSClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                JMSClientServerTest.assertEquals((Object)response2, (Object)reply);
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testOneWayTopicConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPubSubService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPubSubPort"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldPubSubService service = new HelloWorldPubSubService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        try {
            HelloWorldPubSubPort greeter = (HelloWorldPubSubPort)service.getPort(portName, HelloWorldPubSubPort.class);
            for (int idx = 0; idx < 5; ++idx) {
                greeter.greetMeOneWay("JMS:PubSub:Milestone-" + idx);
            }
            Thread.sleep(100L);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testConnectionsWithinSpring() throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"/org/apache/cxf/systest/jms/JMSClients.xml"});
        HelloWorldPortType greeter = (HelloWorldPortType)ctx.getBean("jmsRPCClient");
        JMSClientServerTest.assertNotNull((Object)greeter);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            for (int idx = 0; idx < 5; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                JMSClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                JMSClientServerTest.assertEquals((Object)response2, (Object)reply);
                try {
                    greeter.testRpcLitFault("BadRecordLitFault");
                    JMSClientServerTest.fail((String)"Should have thrown BadRecoedLitFault");
                }
                catch (BadRecordLitFault ex) {
                    JMSClientServerTest.assertNotNull((Object)ex.getFaultInfo());
                }
                try {
                    greeter.testRpcLitFault("NoSuchCodeLitFault");
                    JMSClientServerTest.fail((String)"Should have thrown NoSuchCodeLitFault exception");
                    continue;
                }
                catch (NoSuchCodeLitFault nslf) {
                    JMSClientServerTest.assertNotNull((Object)nslf.getFaultInfo());
                    JMSClientServerTest.assertNotNull((Object)nslf.getFaultInfo().getCode());
                }
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
        HelloWorldOneWayPort greeter1 = (HelloWorldOneWayPort)ctx.getBean("jmsQueueOneWayServiceClient");
        JMSClientServerTest.assertNotNull((Object)greeter1);
        try {
            greeter1.greetMeOneWay("hello");
        }
        catch (Exception ex) {
            JMSClientServerTest.fail((String)("There should not throw the exception" + ex));
        }
    }

    @Test
    public void testOneWayQueueConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldOneWayQueueService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldOneWayQueuePort"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldOneWayQueueService service = new HelloWorldOneWayQueueService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        try {
            HelloWorldOneWayPort greeter = (HelloWorldOneWayPort)service.getPort(portName, HelloWorldOneWayPort.class);
            for (int idx = 0; idx < 5; ++idx) {
                greeter.greetMeOneWay("JMS:Queue:Milestone-" + idx);
            }
            Thread.sleep(100L);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testContextPropogation() throws Exception {
        String testReturnPropertyName = "Test_Prop";
        String testIgnoredPropertyName = "Test_Prop_No_Return";
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPort"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldService service = new HelloWorldService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        try {
            HelloWorldPortType greeter = (HelloWorldPortType)service.getPort(portName, HelloWorldPortType.class);
            InvocationHandler handler = Proxy.getInvocationHandler(greeter);
            BindingProvider bp = null;
            if (handler instanceof BindingProvider) {
                bp = (BindingProvider)handler;
                Map requestContext = bp.getRequestContext();
                JMSMessageHeadersType requestHeader = new JMSMessageHeadersType();
                requestHeader.setJMSCorrelationID("JMS_SAMPLE_CORRELATION_ID");
                requestHeader.setJMSExpiration(3600000L);
                JMSPropertyType propType = new JMSPropertyType();
                propType.setName("Test_Prop");
                propType.setValue("mustReturn");
                requestHeader.getProperty().add(propType);
                propType = new JMSPropertyType();
                propType.setName("Test_Prop_No_Return");
                propType.setValue("mustNotReturn");
                requestContext.put("org.apache.cxf.jms.client.request.headers", requestHeader);
            }
            String greeting = greeter.greetMe("Milestone-");
            JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
            JMSClientServerTest.assertEquals((Object)"Hello Milestone-", (Object)greeting);
            if (bp != null) {
                Map responseContext = bp.getResponseContext();
                JMSMessageHeadersType responseHdr = (JMSMessageHeadersType)responseContext.get("org.apache.cxf.jms.client.response.headers");
                if (responseHdr == null) {
                    JMSClientServerTest.fail((String)"response Header should not be null");
                }
                JMSClientServerTest.assertTrue((String)"CORRELATION ID should match :", (boolean)"JMS_SAMPLE_CORRELATION_ID".equals(responseHdr.getJMSCorrelationID()));
                JMSClientServerTest.assertTrue((String)"response Headers must conain the app property set in request context.", (responseHdr.getProperty() != null ? 1 : 0) != 0);
                boolean found = false;
                for (JMSPropertyType p : responseHdr.getProperty()) {
                    if (!"Test_Prop".equals(p.getName())) continue;
                    found = true;
                }
                JMSClientServerTest.assertTrue((String)"response Headers must match the app property set in request context.", (boolean)found);
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }
}

