/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.local_transport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.systest.local_transport.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalTransportFactory;
import org.apache.hello_world_soap_http.Greeter;
import org.junit.BeforeClass;
import org.junit.Test;

public class DirectDispatchClientTest
extends AbstractBusClientServerTestBase {
    private static Bus staticBus;
    private final QName serviceName = new QName("http://apache.org/hello_world_soap_http", "SOAPService");
    private final QName localPortName = new QName("http://apache.org/hello_world_soap_http", "localPortName");

    @BeforeClass
    public static void startServers() throws Exception {
        staticBus = BusFactory.getDefaultBus();
        DirectDispatchClientTest.setupLocalTransport(staticBus);
        BusFactory.setThreadDefaultBus((Bus)staticBus);
        DirectDispatchClientTest.assertTrue((String)"server did not launch correctly", (boolean)DirectDispatchClientTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testDirectDispatch() {
        this.invokeService(true);
    }

    @Test
    public void testPipeLineDispatch() {
        this.invokeService(false);
    }

    public static void setupLocalTransport(Bus bus) {
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        SoapTransportFactory soapDF = new SoapTransportFactory();
        soapDF.setBus(bus);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/", (DestinationFactory)soapDF);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/soap/", (DestinationFactory)soapDF);
        LocalTransportFactory localTransport = new LocalTransportFactory();
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/soap/http", (DestinationFactory)localTransport);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/http", (DestinationFactory)localTransport);
        dfm.registerDestinationFactory("http://cxf.apache.org/bindings/xformat", (DestinationFactory)localTransport);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/local", (DestinationFactory)localTransport);
        ConduitInitiatorManager extension = (ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/local", (ConduitInitiator)localTransport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/soap/http", (ConduitInitiator)localTransport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/soap/http", (ConduitInitiator)localTransport);
        extension.registerConduitInitiator("http://cxf.apache.org/bindings/xformat", (ConduitInitiator)localTransport);
    }

    private void invokeService(boolean isDirectDispatch) {
        BusFactory.setThreadDefaultBus((Bus)staticBus);
        Service service = Service.create((QName)this.serviceName);
        service.addPort(this.localPortName, "http://schemas.xmlsoap.org/soap/", "local://Greeter");
        Greeter greeter = (Greeter)service.getPort(this.localPortName, Greeter.class);
        if (isDirectDispatch) {
            InvocationHandler handler = Proxy.getInvocationHandler(greeter);
            BindingProvider bp = null;
            if (handler instanceof BindingProvider) {
                bp = (BindingProvider)handler;
                Map requestContext = bp.getRequestContext();
                requestContext.put(LocalConduit.DIRECT_DISPATCH, true);
            }
        }
        String reply = greeter.greetMe("test");
        DirectDispatchClientTest.assertEquals((Object)"Hello test", (Object)reply);
        reply = greeter.sayHi();
        DirectDispatchClientTest.assertNotNull((String)"no response received from service", (Object)reply);
        DirectDispatchClientTest.assertEquals((Object)"Bonjour", (Object)reply);
    }
}

