/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.management.jmx.InstrumentationManagerImpl;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.apache.hello_world_soap_http.SOAPService;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class CountersClientServerTest
extends AbstractBusClientServerTestBase {
    private final QName portName = new QName("http://apache.org/hello_world_soap_http", "SoapPort");

    @BeforeClass
    public static void startServers() throws Exception {
        CountersClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)CountersClientServerTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void shutdownBus() throws Exception {
        BusFactory.getDefaultBus().shutdown(false);
    }

    @Test
    public void testCountersWithInstrumentationManager() throws Exception {
        Object val;
        Bus bus = BusFactory.getDefaultBus();
        CounterRepository cr = (CounterRepository)bus.getExtension(CounterRepository.class);
        InstrumentationManager im = (InstrumentationManager)bus.getExtension(InstrumentationManager.class);
        CountersClientServerTest.assertNotNull((Object)im);
        InstrumentationManagerImpl impl = (InstrumentationManagerImpl)im;
        CountersClientServerTest.assertTrue((boolean)impl.isEnabled());
        CountersClientServerTest.assertNotNull((Object)impl.getMBeanServer());
        MBeanServer mbs = im.getMBeanServer();
        ObjectName name = new ObjectName("org.apache.cxf:bus.id=cxf" + bus.hashCode() + ",*");
        SOAPService service = new SOAPService();
        CountersClientServerTest.assertNotNull((Object)service);
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        String response = new String("Bonjour");
        String reply = greeter.sayHi();
        CountersClientServerTest.assertEquals((String)"The Counters are not create yet", (Object)4, (Object)cr.getCounters().size());
        Set<ObjectName> counterNames = mbs.queryNames(name, null);
        CountersClientServerTest.assertEquals((String)"The Counters are not export to JMX ", (Object)6, (Object)counterNames.size());
        ObjectName sayHiCounter = new ObjectName("org.apache.cxf:operation=\"{http://apache.org/hello_world_soap_http}sayHi\",*");
        Set<ObjectName> s = mbs.queryNames(sayHiCounter, null);
        for (ObjectName counterName : s) {
            val = mbs.getAttribute(counterName, "NumInvocations");
            CountersClientServerTest.assertEquals((String)"Wrong Counters Number of Invocations", (Object)val, (Object)1);
        }
        reply = greeter.sayHi();
        CountersClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
        CountersClientServerTest.assertEquals((Object)response, (Object)reply);
        s = mbs.queryNames(sayHiCounter, null);
        for (ObjectName counterName : s) {
            val = mbs.getAttribute(counterName, "NumInvocations");
            CountersClientServerTest.assertEquals((String)"Wrong Counters Number of Invocations", (Object)val, (Object)2);
        }
        greeter.greetMeOneWay("hello");
        CountersClientServerTest.assertEquals((String)"The Counters are not create yet", (Object)6, (Object)cr.getCounters().size());
        counterNames = mbs.queryNames(name, null);
        CountersClientServerTest.assertEquals((String)"The Counters are not export to JMX ", (Object)8, (Object)counterNames.size());
        ObjectName greetMeOneWayCounter = new ObjectName("org.apache.cxf:operation=\"{http://apache.org/hello_world_soap_http}greetMeOneWay\",*");
        s = mbs.queryNames(greetMeOneWayCounter, null);
        for (ObjectName counterName : s) {
            Object val2 = mbs.getAttribute(counterName, "NumInvocations");
            CountersClientServerTest.assertEquals((String)"Wrong Counters Number of Invocations", (Object)val2, (Object)1);
        }
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus("org/apache/cxf/systest/management/counter-spring.xml", true);
            BusFactory.setDefaultBus((Bus)bus);
            GreeterImpl implementor = new GreeterImpl();
            Endpoint.publish((String)"http://localhost:9000/SoapContext/SoapPort", (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

