/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.jmx.InstrumentationManagerImpl;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.junit.Assert;
import org.junit.Test;

public class ManagedBusTest
extends Assert {
    @Test
    public void testManagedSpringBus() throws Exception {
        SpringBusFactory factory = new SpringBusFactory();
        Bus bus = factory.createBus();
        InstrumentationManager im = (InstrumentationManager)bus.getExtension(InstrumentationManager.class);
        ManagedBusTest.assertNotNull((Object)im);
        InstrumentationManagerImpl imi = (InstrumentationManagerImpl)im;
        ManagedBusTest.assertEquals((Object)"service:jmx:rmi:///jndi/rmi://localhost:9913/jmxrmi", (Object)imi.getJMXServiceURL());
        ManagedBusTest.assertTrue((!imi.isEnabled() ? 1 : 0) != 0);
        ManagedBusTest.assertNull((Object)imi.getMBeanServer());
        im.register((Object)imi, new ObjectName("org.apache.cxf:foo=bar"));
        bus.shutdown(true);
    }

    @Test
    public void testManagedBusWithConfig() throws Exception {
        SpringBusFactory factory = new SpringBusFactory();
        Bus bus = factory.createBus("org/apache/cxf/systest/management/managed-spring.xml", true);
        InstrumentationManager im = (InstrumentationManager)bus.getExtension(InstrumentationManager.class);
        ManagedBusTest.assertNotNull((Object)im);
        InstrumentationManagerImpl imi = (InstrumentationManagerImpl)im;
        ManagedBusTest.assertEquals((Object)"service:jmx:rmi:///jndi/rmi://localhost:9916/jmxrmi", (Object)imi.getJMXServiceURL());
        ManagedBusTest.assertTrue((boolean)imi.isEnabled());
        ManagedBusTest.assertNotNull((Object)imi.getMBeanServer());
        WorkQueueManager manager = (WorkQueueManager)bus.getExtension(WorkQueueManager.class);
        manager.getAutomaticWorkQueue();
        MBeanServer mbs = im.getMBeanServer();
        ObjectName name = new ObjectName("org.apache.cxf:type=WorkQueueMBean,*");
        Set<ObjectName> s = mbs.queryNames(name, null);
        ManagedBusTest.assertTrue((s.size() == 1 ? 1 : 0) != 0);
        for (ObjectName n : s) {
            Long result = (Long)mbs.invoke(n, "getWorkQueueMaxSize", new Object[0], new String[0]);
            ManagedBusTest.assertEquals((Object)result, (Object)250L);
        }
        name = new ObjectName("org.apache.cxf:type=Bus,*");
        s = mbs.queryNames(name, null);
        ManagedBusTest.assertTrue((s.size() == 1 ? 1 : 0) != 0);
        for (ObjectName n : s) {
            Object[] params = new Object[]{Boolean.FALSE};
            String[] sig = new String[]{"boolean"};
            mbs.invoke(n, "shutdown", params, sig);
        }
        bus.shutdown(false);
    }
}

