/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.jmx.InstrumentationManagerImpl;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.apache.hello_world_soap_http.SOAPService;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ManagedClientServerTest
extends AbstractBusClientServerTestBase {
    private final QName portName = new QName("http://apache.org/hello_world_soap_http", "SoapPort");

    @BeforeClass
    public static void startServers() throws Exception {
        ManagedClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)ManagedClientServerTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void shutdownBus() throws Exception {
        BusFactory.getDefaultBus().shutdown(false);
    }

    @Test
    public void testManagedEndpoint() throws Exception {
        Bus bus = SpringBusFactory.getDefaultBus();
        InstrumentationManager im = (InstrumentationManager)bus.getExtension(InstrumentationManager.class);
        ManagedClientServerTest.assertNotNull((Object)im);
        InstrumentationManagerImpl impl = (InstrumentationManagerImpl)im;
        ManagedClientServerTest.assertTrue((boolean)impl.isEnabled());
        ManagedClientServerTest.assertNotNull((Object)impl.getMBeanServer());
        MBeanServer mbs = im.getMBeanServer();
        ObjectName name = new ObjectName("org.apache.cxf:type=Bus.Service.Endpoint,*");
        Set<ObjectName> s = mbs.queryNames(name, null);
        ManagedClientServerTest.assertTrue((s.size() == 1 ? 1 : 0) != 0);
        name = s.iterator().next();
        Object val = mbs.invoke(name, "getState", new Object[0], new String[0]);
        ManagedClientServerTest.assertEquals((String)"Service should have been started.", (Object)"STARTED", (Object)val);
        SOAPService service = new SOAPService();
        ManagedClientServerTest.assertNotNull((Object)service);
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        String response = new String("Bonjour");
        String reply = greeter.sayHi();
        ManagedClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
        ManagedClientServerTest.assertEquals((Object)response, (Object)reply);
        mbs.invoke(name, "stop", new Object[0], new String[0]);
        val = mbs.getAttribute(name, "State");
        ManagedClientServerTest.assertEquals((String)"Service should have been stopped.", (Object)"STOPPED", (Object)val);
        try {
            reply = greeter.sayHi();
            ManagedClientServerTest.fail((String)"Endpoint should not be active at this point.");
        }
        catch (Exception ex) {
            // empty catch block
        }
        mbs.invoke(name, "start", new Object[0], new String[0]);
        val = mbs.invoke(name, "getState", new Object[0], new String[0]);
        ManagedClientServerTest.assertEquals((String)"Service should have been started.", (Object)"STARTED", (Object)val);
        reply = greeter.sayHi();
        ManagedClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
        ManagedClientServerTest.assertEquals((Object)response, (Object)reply);
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus("org/apache/cxf/systest/management/managed-spring.xml", true);
            BusFactory.setDefaultBus((Bus)bus);
            GreeterImpl implementor = new GreeterImpl();
            Endpoint.publish(null, (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

