/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.io.InputStream;
import javax.jws.HandlerChain;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider(portName="SoapPortProviderRPCLit1", serviceName="SOAPServiceProviderRPCLit", targetNamespace="http://apache.org/hello_world_rpclit", wsdlLocation="wsdl/hello_world_rpc_lit.wsdl")
@ServiceMode(value=Service.Mode.MESSAGE)
@HandlerChain(file="./handlers_invocation.xml", name="TestHandlerChain")
public class HWSoapMessageProvider
implements Provider<SOAPMessage> {
    private static QName sayHi = new QName("http://apache.org/hello_world_rpclit", "sayHi");
    private static QName greetMe = new QName("http://apache.org/hello_world_rpclit", "greetMe");
    private SOAPMessage sayHiResponse;
    private SOAPMessage greetMeResponse;

    public HWSoapMessageProvider() {
        try {
            MessageFactory factory = MessageFactory.newInstance();
            InputStream is = this.getClass().getResourceAsStream("resources/sayHiRpcLiteralResp.xml");
            this.sayHiResponse = factory.createMessage(null, is);
            is.close();
            is = this.getClass().getResourceAsStream("resources/GreetMeRpcLiteralResp.xml");
            this.greetMeResponse = factory.createMessage(null, is);
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SOAPMessage invoke(SOAPMessage request) {
        SOAPMessage response = null;
        try {
            SOAPBody body = request.getSOAPBody();
            Node n = body.getFirstChild();
            while (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            response = n.getLocalName().equals(sayHi.getLocalPart()) ? this.sayHiResponse : (n.getLocalName().equals(greetMe.getLocalPart()) ? this.greetMeResponse : request);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return response;
    }
}

