/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.io.InputStream;
import java.io.StringWriter;
import javax.jws.HandlerChain;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider(portName="SoapPortProviderRPCLit3", serviceName="SOAPServiceProviderRPCLit", targetNamespace="http://apache.org/hello_world_rpclit", wsdlLocation="/wsdl/hello_world_rpc_lit.wsdl")
@ServiceMode(value=Service.Mode.PAYLOAD)
@HandlerChain(file="./handlers_invocation.xml", name="TestHandlerChain")
public class HWSourcePayloadProvider
implements Provider<Source> {
    public Source invoke(Source request) {
        try {
            String input = HWSourcePayloadProvider.getSourceAsString(request);
            System.out.println(input);
            if (input.indexOf("ServerLogicalHandler") >= 0) {
                StreamSource source = new StreamSource();
                InputStream greetMeInputStream = this.getClass().getResourceAsStream("resources/GreetMeRpcLiteralRespBody.xml");
                source.setInputStream(greetMeInputStream);
                return source;
            }
        }
        catch (Exception e) {
            System.out.println("Received an exception while parsing the source");
            e.printStackTrace();
        }
        return null;
    }

    public static String getSourceAsString(Source s) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        StringWriter out = new StringWriter();
        StreamResult streamResult = new StreamResult();
        streamResult.setWriter(out);
        transformer.transform(s, streamResult);
        return streamResult.getWriter().toString();
    }
}

