/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider.datasource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.annotation.Resource;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.systest.provider.datasource.AbstractProvider;
import org.apache.cxf.systest.provider.datasource.DataSourceProviderTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider(serviceName="ModelProvider")
@BindingType(value="http://cxf.apache.org/bindings/xformat")
@ServiceMode(value=Service.Mode.MESSAGE)
public class TestProvider
extends AbstractProvider<DataSource>
implements Provider<DataSource> {
    static final Logger LOG = LogUtils.getLogger(TestProvider.class);

    @Override
    @Resource
    public void setWebServiceContext(WebServiceContext wsc) {
        super.setWebServiceContext(wsc);
    }

    @Override
    public DataSource invoke(DataSource req) {
        return super.invoke(req);
    }

    @Override
    protected DataSource post(DataSource req) {
        try {
            LOG.info("content type: " + req.getContentType());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)req.getInputStream(), (OutputStream)baos);
            LOG.info("body [" + new String(baos.toByteArray()) + "]");
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            String msg = "<ok/>";
            MimeMultipart multipart = DataSourceProviderTest.readAttachmentParts(req.getContentType(), bais);
            LOG.info("found " + multipart.getCount() + " parts");
            return new ByteArrayDataSource(baos.toByteArray(), req.getContentType());
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "<fail/>";
            return new ByteArrayDataSource(msg.getBytes(), "text/xml");
        }
    }

    @Override
    protected DataSource get(DataSource req) {
        String msg = "<doc><response>Hello</response></doc>";
        return new ByteArrayDataSource(msg.getBytes(), "application/octet-stream");
    }
}

