/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.resolver;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.endpoint.ServiceContractResolver;
import org.apache.cxf.endpoint.ServiceContractResolverRegistry;
import org.apache.cxf.endpoint.ServiceContractResolverRegistryImpl;
import org.apache.cxf.systest.jca.OutBoundConnectionTest;
import org.apache.cxf.systest.resolver.JarServiceContractResolver;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world_soap_http.Greeter;
import org.junit.BeforeClass;
import org.junit.Test;

public class JarResolverTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/hello_world_soap_http", "SOAPService");
    private final QName portName = new QName("http://apache.org/hello_world_soap_http", "SoapPort");

    @BeforeClass
    public static void startServers() throws Exception {
        JarResolverTest.assertTrue((String)"server did not launch correctly", (boolean)JarResolverTest.launchServer(OutBoundConnectionTest.Server.class));
    }

    @Test
    public void testResolver() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        JarResolverTest.assertNotNull((Object)wsdl);
        this.createBus();
        JarResolverTest.assertNotNull((Object)this.bus);
        ServiceContractResolverRegistryImpl registry = new ServiceContractResolverRegistryImpl();
        registry.setBus(this.bus);
        registry.init();
        JarResolverTest.assertNotNull((Object)this.bus.getExtension(ServiceContractResolverRegistry.class));
        JarServiceContractResolver resolver = new JarServiceContractResolver();
        registry.register((ServiceContractResolver)resolver);
        Service service = Service.create((QName)this.serviceName);
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        String resp = greeter.sayHi();
        JarResolverTest.assertNotNull((Object)resp);
    }
}

