/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.schema_validation;

import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.systest.schema_validation.ValidationServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.schema_validation.SchemaValidation;
import org.apache.schema_validation.SchemaValidationService;
import org.apache.schema_validation.types.ComplexStruct;
import org.apache.schema_validation.types.OccuringStruct;
import org.junit.BeforeClass;
import org.junit.Test;

public class ValidationClientServerTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/schema_validation", "SchemaValidationService");
    private final QName portName = new QName("http://apache.org/schema_validation", "SoapPort");

    @BeforeClass
    public static void startservers() throws Exception {
        URL url = ValidationClientServerTest.class.getResource("cxf-config.xml");
        ValidationClientServerTest.assertNotNull((String)"cannot find test resource", (Object)url);
        defaultConfigFileName = url.toString();
        ValidationClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)ValidationClientServerTest.launchServer(ValidationServer.class));
    }

    @Test
    public void testSchemaValidation() throws Exception {
        String expected;
        System.setProperty("cxf.config.file.url", ((Object)((Object)this)).getClass().getResource("cxf-config.xml").toString());
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/schema_validation.wsdl");
        ValidationClientServerTest.assertNotNull((Object)wsdl);
        SchemaValidationService service = new SchemaValidationService(wsdl, this.serviceName);
        ValidationClientServerTest.assertNotNull((Object)service);
        SchemaValidation validation = (SchemaValidation)service.getPort(this.portName, SchemaValidation.class);
        ComplexStruct complexStruct = new ComplexStruct();
        complexStruct.setElem1("one");
        complexStruct.setElem3(3);
        try {
            validation.setComplexStruct(complexStruct);
            ValidationClientServerTest.fail((String)"Set ComplexStruct hould have thrown ProtocolException");
        }
        catch (WebServiceException e) {
            ValidationClientServerTest.assertTrue((boolean)(e.getCause() instanceof Fault));
            String expected2 = "'{\"http://apache.org/schema_validation/types\":elem2}' is expected.";
            ValidationClientServerTest.assertTrue((e.getCause().getMessage().indexOf(expected2) != -1 ? 1 : 0) != 0);
        }
        OccuringStruct occuringStruct = new OccuringStruct();
        List floatIntStringList = occuringStruct.getVarFloatAndVarIntAndVarString();
        floatIntStringList.add(new Integer(42));
        floatIntStringList.add(new Float(4.2f));
        floatIntStringList.add("Goofus and Gallant");
        try {
            validation.setOccuringStruct(occuringStruct);
            ValidationClientServerTest.fail((String)"Set OccuringStruct hould have thrown ProtocolException");
        }
        catch (WebServiceException e) {
            ValidationClientServerTest.assertTrue((boolean)(e.getCause() instanceof Fault));
            expected = "'{\"http://apache.org/schema_validation/types\":varFloat}' is expected.";
            ValidationClientServerTest.assertTrue((e.getCause().getMessage().indexOf(expected) != -1 ? 1 : 0) != 0);
        }
        try {
            validation.getComplexStruct("Hello");
            ValidationClientServerTest.fail((String)"Get ComplexStruct should have thrown ProtocolException");
        }
        catch (WebServiceException e) {
            ValidationClientServerTest.assertTrue((boolean)(e.getCause() instanceof Fault));
            expected = "'{\"http://apache.org/schema_validation/types\":elem2}' is expected.";
            ValidationClientServerTest.assertTrue((String)("Found message " + e.getCause().getMessage()), (e.getCause().getMessage().indexOf(expected) != -1 ? 1 : 0) != 0);
        }
        try {
            validation.getOccuringStruct("World");
            ValidationClientServerTest.fail((String)"Get OccuringStruct should have thrown ProtocolException");
        }
        catch (WebServiceException e) {
            ValidationClientServerTest.assertTrue((boolean)(e.getCause() instanceof Fault));
            expected = "'{\"http://apache.org/schema_validation/types\":varFloat}' is expected.";
            ValidationClientServerTest.assertTrue((e.getCause().getMessage().indexOf(expected) != -1 ? 1 : 0) != 0);
        }
    }
}

