/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.type_test.soap;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.Holder;
import org.apache.cxf.systest.type_test.AbstractTypeTestClient5;
import org.apache.cxf.systest.type_test.soap.SOAPRpcLitServerImpl;
import org.apache.type_test.types2.StructWithAnyArrayLax;
import org.apache.type_test.types2.StructWithAnyStrict;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Element;

public class SOAPRpcLitClientTypeTest
extends AbstractTypeTestClient5 {
    protected static final String WSDL_PATH = "/wsdl/type_test/type_test_rpclit_soap.wsdl";
    protected static final QName SERVICE_NAME = new QName("http://apache.org/type_test/rpc", "SOAPService");
    protected static final QName PORT_NAME = new QName("http://apache.org/type_test/rpc", "SOAPPort");

    @BeforeClass
    public static void startServers() throws Exception {
        boolean ok = SOAPRpcLitClientTypeTest.launchServer(SOAPRpcLitServerImpl.class);
        SOAPRpcLitClientTypeTest.assertTrue((String)"failed to launch server", (boolean)ok);
        SOAPRpcLitClientTypeTest.initClient(AbstractTypeTestClient5.class, SERVICE_NAME, PORT_NAME, WSDL_PATH);
    }

    @Test
    public void testStructWithAnyStrict() throws Exception {
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement elem = factory.createElement("StringElementQualified", "tns", "http://apache.org/type_test/types1");
        elem.addNamespaceDeclaration("tns", "http://apache.org/type_test/types1");
        elem.addTextNode("This is the text of the node");
        StructWithAnyStrict x = new StructWithAnyStrict();
        x.setName("Name x");
        x.setAddress("Some Address x");
        x.setAny((Object)elem);
        elem = factory.createElement("StringElementQualified", "tns", "http://apache.org/type_test/types1");
        elem.addNamespaceDeclaration("tns", "http://apache.org/type_test/types1");
        elem.addTextNode("This is the text of the second node");
        StructWithAnyStrict yOrig = new StructWithAnyStrict();
        yOrig.setName("Name y");
        yOrig.setAddress("Some Address y");
        yOrig.setAny((Object)elem);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithAnyStrict ret = rpcClient.testStructWithAnyStrict(x, y, z);
        if (!this.perfTestOnly) {
            this.assertEqualsStructWithAnyStrict(x, (StructWithAnyStrict)y.value);
            this.assertEqualsStructWithAnyStrict(yOrig, (StructWithAnyStrict)z.value);
            this.assertEqualsStructWithAnyStrict(x, ret);
        }
    }

    @Test
    public void testStructWithAnyStrictComplex() throws Exception {
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement elem = factory.createElement("AnonTypeElementQualified", "tns", "http://apache.org/type_test/types1");
        elem.addNamespaceDeclaration("tns", "http://apache.org/type_test/types1");
        SOAPElement floatElem = factory.createElement("varFloat", "tns", "http://apache.org/type_test/types1");
        floatElem.addTextNode("12.5");
        elem.addChildElement(floatElem);
        SOAPElement intElem = factory.createElement("varInt", "tns", "http://apache.org/type_test/types1");
        intElem.addTextNode("34");
        elem.addChildElement(intElem);
        SOAPElement stringElem = factory.createElement("varString", "tns", "http://apache.org/type_test/types1");
        stringElem.addTextNode("test string within any");
        elem.addChildElement(stringElem);
        StructWithAnyStrict x = new StructWithAnyStrict();
        x.setName("Name x");
        x.setAddress("Some Address x");
        x.setAny((Object)elem);
        elem = factory.createElement("AnonTypeElementQualified", "tns", "http://apache.org/type_test/types1");
        elem.addNamespaceDeclaration("tns", "http://apache.org/type_test/types1");
        floatElem = factory.createElement("varFloat", "tns", "http://apache.org/type_test/types1");
        floatElem.addTextNode("12.76");
        elem.addChildElement(floatElem);
        intElem = factory.createElement("varInt", "tns", "http://apache.org/type_test/types1");
        intElem.addTextNode("56");
        elem.addChildElement(intElem);
        stringElem = factory.createElement("varString", "tns", "http://apache.org/type_test/types1");
        stringElem.addTextNode("test string");
        elem.addChildElement(stringElem);
        StructWithAnyStrict yOrig = new StructWithAnyStrict();
        yOrig.setName("Name y");
        yOrig.setAddress("Some Address y");
        yOrig.setAny((Object)elem);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithAnyStrict ret = rpcClient.testStructWithAnyStrict(x, y, z);
        if (!this.perfTestOnly) {
            this.assertEqualsStructWithAnyStrict(x, (StructWithAnyStrict)y.value);
            this.assertEqualsStructWithAnyStrict(yOrig, (StructWithAnyStrict)z.value);
            this.assertEqualsStructWithAnyStrict(x, ret);
        }
    }

    @Test
    public void testStructWithAnyArrayLax() throws Exception {
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement elem = factory.createElement("StringElementQualified", "tns", "http://apache.org/type_test/types1");
        elem.addNamespaceDeclaration("tns", "http://apache.org/type_test/types1");
        elem.addTextNode("This is the text of the node");
        StructWithAnyArrayLax x = new StructWithAnyArrayLax();
        x.setName("Name x");
        x.setAddress("Some Address x");
        x.getAny().add(elem);
        elem = factory.createElement("StringElementQualified", "tns", "http://apache.org/type_test/types1");
        elem.addNamespaceDeclaration("tns", "http://apache.org/type_test/types1");
        elem.addTextNode("This is the text of the node for the second struct");
        StructWithAnyArrayLax yOrig = new StructWithAnyArrayLax();
        yOrig.setName("Name y");
        yOrig.setAddress("Some Other Address y");
        yOrig.getAny().add(elem);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithAnyArrayLax ret = rpcClient.testStructWithAnyArrayLax(x, y, z);
        if (!this.perfTestOnly) {
            this.assertEqualsStructWithAnyArrayLax(x, (StructWithAnyArrayLax)y.value);
            this.assertEqualsStructWithAnyArrayLax(yOrig, (StructWithAnyArrayLax)z.value);
            this.assertEqualsStructWithAnyArrayLax(x, ret);
        }
    }

    @Test
    public void testStructWithAnyArrayLaxComplex() throws Exception {
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement elem = factory.createElement("AnonTypeElementQualified", "tns", "http://apache.org/type_test/types1");
        elem.addNamespaceDeclaration("tns", "http://apache.org/type_test/types1");
        SOAPElement floatElem = factory.createElement("varFloat", "tns", "http://apache.org/type_test/types1");
        floatElem.addTextNode("12.76");
        elem.addChildElement(floatElem);
        SOAPElement intElem = factory.createElement("varInt", "tns", "http://apache.org/type_test/types1");
        intElem.addTextNode("56");
        elem.addChildElement(intElem);
        SOAPElement stringElem = factory.createElement("varString", "tns", "http://apache.org/type_test/types1");
        stringElem.addTextNode("test string");
        elem.addChildElement(stringElem);
        StructWithAnyArrayLax x = new StructWithAnyArrayLax();
        x.setName("Name x");
        x.setAddress("Some Address x");
        x.getAny().add(elem);
        StructWithAnyArrayLax yOrig = new StructWithAnyArrayLax();
        yOrig.setName("Name y");
        yOrig.setAddress("Some Other Address y");
        yOrig.getAny().add(elem);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithAnyArrayLax ret = rpcClient.testStructWithAnyArrayLax(x, y, z);
        if (!this.perfTestOnly) {
            this.assertEqualsStructWithAnyArrayLax(x, (StructWithAnyArrayLax)y.value);
            this.assertEqualsStructWithAnyArrayLax(yOrig, (StructWithAnyArrayLax)z.value);
            this.assertEqualsStructWithAnyArrayLax(x, ret);
        }
    }

    public void assertEqualsStructWithAnyStrict(StructWithAnyStrict a, StructWithAnyStrict b) throws Exception {
        SOAPRpcLitClientTypeTest.assertEquals((String)"StructWithAnyStrict names don't match", (Object)a.getName(), (Object)b.getName());
        SOAPRpcLitClientTypeTest.assertEquals((String)"StructWithAnyStrict addresses don't match", (Object)a.getAddress(), (Object)b.getAddress());
        if (a.getAny() instanceof SOAPElement && b.getAny() instanceof SOAPElement) {
            this.assertEquals((Element)((SOAPElement)a.getAny()), (Element)((SOAPElement)b.getAny()));
        }
    }

    public void assertEqualsStructWithAnyArrayLax(StructWithAnyArrayLax a, StructWithAnyArrayLax b) throws Exception {
        SOAPRpcLitClientTypeTest.assertEquals((String)"StructWithAnyArrayLax names don't match", (Object)a.getName(), (Object)b.getName());
        SOAPRpcLitClientTypeTest.assertEquals((String)"StructWithAnyArrayLax addresses don't match", (Object)a.getAddress(), (Object)b.getAddress());
        List ae = a.getAny();
        List be = b.getAny();
        SOAPRpcLitClientTypeTest.assertEquals((String)"StructWithAnyArrayLax soap element lengths don't match", (Object)ae.size(), (Object)be.size());
        for (int i = 0; i < ae.size(); ++i) {
            if (!(ae.get(i) instanceof SOAPElement) || !(be.get(i) instanceof SOAPElement)) continue;
            SOAPRpcLitClientTypeTest.assertEquals(ae.get(i), be.get(i));
        }
    }
}

