/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.addressing;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.jaxws.support.ServiceDelegateAccessor;
import org.apache.cxf.systest.ws.addressing.HeaderVerifier;
import org.apache.cxf.systest.ws.addressing.MAPVerifier;
import org.apache.cxf.systest.ws.addressing.Server;
import org.apache.cxf.systest.ws.addressing.VerificationCache;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.hello_world_soap_http.BadRecordLitFault;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.NoSuchCodeLitFault;
import org.apache.hello_world_soap_http.SOAPService;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MAPTestBase
extends AbstractClientServerTestBase
implements VerificationCache {
    protected static Bus staticBus;
    static final String INBOUND_KEY = "inbound";
    static final String OUTBOUND_KEY = "outbound";
    static final QName CUSTOMER_NAME;
    static final String CUSTOMER_KEY = "Key#123456789";
    private static MAPVerifier mapVerifier;
    private static HeaderVerifier headerVerifier;
    private static final QName SERVICE_NAME;
    private static final String NOWHERE = "http://nowhere.nada.nothing.nought:5555";
    private static final String DECOUPLED = "http://localhost:9999/decoupled_endpoint";
    private static Map<Object, Map<String, String>> messageIDs;
    protected Greeter greeter;
    private String verified;

    @BeforeClass
    public static void startServers() throws Exception {
        boolean inProcess = "Windows 2000".equals(System.getProperty("os.name"));
        MAPTestBase.assertTrue((String)"server did not launch correctly", (boolean)MAPTestBase.launchServer(Server.class, (boolean)inProcess));
    }

    @AfterClass
    public static void shutdownBus() throws Exception {
        staticBus.shutdown(true);
    }

    private void addInterceptors(List<Interceptor> chain, Interceptor[] interceptors) {
        for (int i = 0; i < interceptors.length; ++i) {
            chain.add(interceptors[i]);
        }
    }

    private void removeInterceptors(List<Interceptor> chain, Interceptor[] interceptors) {
        for (int i = 0; i < interceptors.length; ++i) {
            chain.add(interceptors[i]);
        }
    }

    public abstract String getConfigFileName();

    @Before
    public void setUp() throws Exception {
        if (staticBus == null) {
            SpringBusFactory bf = new SpringBusFactory();
            staticBus = bf.createBus(this.getConfigFileName());
            BusFactory.setDefaultBus((Bus)staticBus);
        }
        messageIDs.clear();
        mapVerifier = new MAPVerifier();
        headerVerifier = new HeaderVerifier();
        Interceptor[] interceptors = new Interceptor[]{mapVerifier, headerVerifier};
        this.addInterceptors(staticBus.getInInterceptors(), interceptors);
        this.addInterceptors(staticBus.getOutInterceptors(), interceptors);
        this.addInterceptors(staticBus.getOutFaultInterceptors(), interceptors);
        this.addInterceptors(staticBus.getInFaultInterceptors(), interceptors);
        EndpointReferenceType target = EndpointReferenceUtils.getEndpointReference((String)"http://localhost:9008/SoapContext/SoapPort");
        ReferenceParametersType params = ContextUtils.WSA_OBJECT_FACTORY.createReferenceParametersType();
        JAXBElement param = new JAXBElement(CUSTOMER_NAME, String.class, (Object)CUSTOMER_KEY);
        params.getAny().add(param);
        target.setReferenceParameters(params);
        URL wsdl = this.getClass().getResource("/wsdl/hello_world.wsdl");
        ServiceImpl serviceImpl = ServiceDelegateAccessor.get((Service)new SOAPService(wsdl, SERVICE_NAME));
        this.greeter = (Greeter)serviceImpl.getPort(target, Greeter.class);
        MAPTestBase.mapVerifier.verificationCache = this;
        MAPTestBase.headerVerifier.verificationCache = this;
    }

    @After
    public void tearDown() throws Exception {
        Interceptor[] interceptors = new Interceptor[]{mapVerifier, headerVerifier};
        this.removeInterceptors(staticBus.getInInterceptors(), interceptors);
        this.removeInterceptors(staticBus.getOutInterceptors(), interceptors);
        this.removeInterceptors(staticBus.getOutFaultInterceptors(), interceptors);
        this.removeInterceptors(staticBus.getInFaultInterceptors(), interceptors);
        mapVerifier = null;
        headerVerifier = null;
        this.verified = null;
        messageIDs.clear();
    }

    @Test
    public void testImplicitMAPs() throws Exception {
        try {
            String greeting = this.greeter.greetMe("implicit1");
            MAPTestBase.assertEquals((String)"unexpected response received from service", (Object)"Hello implicit1", (Object)greeting);
            this.checkVerification();
            greeting = this.greeter.greetMe("implicit2");
            MAPTestBase.assertEquals((String)"unexpected response received from service", (Object)"Hello implicit2", (Object)greeting);
            this.checkVerification();
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    @Ignore
    public void testExplicitMAPs() throws Exception {
        try {
            Map requestContext = ((BindingProvider)this.greeter).getRequestContext();
            AddressingPropertiesImpl maps = new AddressingPropertiesImpl();
            AttributedURIType id = ContextUtils.getAttributedURI((String)"urn:uuid:12345");
            maps.setMessageID(id);
            requestContext.put("javax.xml.ws.addressing.context", maps);
            String greeting = this.greeter.greetMe("explicit1");
            MAPTestBase.assertEquals((String)"unexpected response received from service", (Object)"Hello explicit1", (Object)greeting);
            this.checkVerification();
            try {
                this.greeter.greetMe("explicit2");
                MAPTestBase.fail((String)"expected ProtocolException on duplicate message ID");
            }
            catch (ProtocolException pe) {
                MAPTestBase.assertTrue((String)"expected duplicate message ID failure", (boolean)"Duplicate Message ID urn:uuid:12345".equals(pe.getMessage()));
                this.checkVerification();
            }
            maps.setMessageID(null);
            maps.setRelatesTo(ContextUtils.getRelatesTo((String)id.getValue()));
            greeting = this.greeter.greetMe("explicit3");
            MAPTestBase.assertEquals((String)"unexpected response received from service", (Object)"Hello explicit3", (Object)greeting);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    @Ignore
    public void testFaultTo() throws Exception {
        try {
            String greeting = this.greeter.greetMe("warmup");
            MAPTestBase.assertEquals((String)"unexpected response received from service", (Object)"Hello warmup", (Object)greeting);
            this.checkVerification();
            Map requestContext = ((BindingProvider)this.greeter).getRequestContext();
            AddressingPropertiesImpl maps = new AddressingPropertiesImpl();
            maps.setReplyTo(EndpointReferenceUtils.getEndpointReference((String)NOWHERE));
            maps.setFaultTo(EndpointReferenceUtils.getEndpointReference((String)DECOUPLED));
            requestContext.put("javax.xml.ws.addressing.context", maps);
            try {
                this.greeter.testDocLitFault("BadRecordLitFault");
                MAPTestBase.fail((String)"expected fault from service");
            }
            catch (BadRecordLitFault brlf) {
                this.checkVerification();
            }
            catch (UndeclaredThrowableException ex) {
                throw (Exception)ex.getCause();
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testOneway() throws Exception {
        try {
            this.greeter.greetMeOneWay("implicit_oneway1");
            this.checkVerification();
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    @Ignore(value="Random failure on Linux")
    public void testApplicationFault() throws Exception {
        try {
            this.greeter.testDocLitFault("BadRecordLitFault");
            MAPTestBase.fail((String)"expected fault from service");
        }
        catch (BadRecordLitFault brlf) {
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
        String greeting = this.greeter.greetMe("intra-fault");
        MAPTestBase.assertEquals((String)"unexpected response received from service", (Object)"Hello intra-fault", (Object)greeting);
        try {
            this.greeter.testDocLitFault("NoSuchCodeLitFault");
            MAPTestBase.fail((String)"expected NoSuchCodeLitFault");
        }
        catch (NoSuchCodeLitFault nsclf) {
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testVersioning() throws Exception {
        try {
            MAPTestBase.mapVerifier.expectedExposedAs.add("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            MAPTestBase.mapVerifier.expectedExposedAs.add("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            String greeting = this.greeter.greetMe("versioning1");
            MAPTestBase.assertEquals((String)"unexpected response received from service", (Object)"Hello versioning1", (Object)greeting);
            this.checkVerification();
            greeting = this.greeter.greetMe("versioning2");
            MAPTestBase.assertEquals((String)"unexpected response received from service", (Object)"Hello versioning2", (Object)greeting);
            this.checkVerification();
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Override
    public void put(String verification) {
        if (verification != null) {
            this.verified = this.verified == null ? verification : this.verified + "; " + verification;
        }
    }

    protected static String verifyMAPs(AddressingProperties maps, Object checkPoint) {
        if (maps == null) {
            return "expected MAPs";
        }
        String id = maps.getMessageID().getValue();
        if (id == null) {
            return "expected MessageID MAP";
        }
        if (!id.startsWith("urn:uuid")) {
            return "bad URN format in MessageID MAP: " + id;
        }
        Map<String, String> checkPointMessageIDs = messageIDs.get(checkPoint);
        if (checkPointMessageIDs != null) {
            if (checkPointMessageIDs.containsKey(id)) {
                return null;
            }
        } else {
            checkPointMessageIDs = new HashMap<String, String>();
            messageIDs.put(checkPoint, checkPointMessageIDs);
        }
        checkPointMessageIDs.put(id, id);
        if (maps.getTo() == null) {
            return "expected To MAP";
        }
        return null;
    }

    protected static String verifyHeaders(List<String> wsaHeaders, boolean partial, boolean requestLeg) {
        String ret = null;
        if (!wsaHeaders.contains("MessageID")) {
            ret = "expected MessageID header";
        }
        if (!wsaHeaders.contains("To")) {
            ret = "expected To header";
        }
        if (!wsaHeaders.contains("ReplyTo") && !wsaHeaders.contains("RelatesTo")) {
            ret = "expected ReplyTo or RelatesTo header";
        }
        if (partial && !wsaHeaders.contains("From")) {
            ret = "expected From header";
        }
        if (requestLeg && !wsaHeaders.contains(CUSTOMER_NAME.getLocalPart())) {
            ret = "expected CustomerKey header";
        }
        return ret;
    }

    private void checkVerification() {
        MAPTestBase.assertNull((String)("MAP/Header verification failed: " + this.verified), (Object)this.verified);
    }

    static {
        CUSTOMER_NAME = new QName("http://example.org/customer", "CustomerKey", "customer");
        SERVICE_NAME = new QName("http://apache.org/hello_world_soap_http", "SOAPServiceAddressing");
        messageIDs = new HashMap<Object, Map<String, String>>();
    }
}

