/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.PingMeFault;
import org.apache.cxf.greeter_control.ReliableGreeterService;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.systest.ws.policy.PolicyTestUtils;
import org.apache.cxf.systest.ws.util.ConnectionHelper;
import org.apache.cxf.systest.ws.util.InMessageRecorder;
import org.apache.cxf.systest.ws.util.MessageFlow;
import org.apache.cxf.systest.ws.util.MessageRecorder;
import org.apache.cxf.systest.ws.util.OutMessageRecorder;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.junit.BeforeClass;
import org.junit.Test;

public class RMPolicyWsdlTest
extends AbstractBusClientServerTestBase {
    private static final Logger LOG = LogUtils.getLogger(RMPolicyWsdlTest.class);
    private static final String GREETMEONEWAY_ACTION = "http://cxf.apache.org/greeter_control/Greeter/greetMeOneWayRequest";
    private static final String GREETME_ACTION = "http://cxf.apache.org/greeter_control/Greeter/greetMeRequest";
    private static final String GREETME_RESPONSE_ACTION = "http://cxf.apache.org/greeter_control/Greeter/greetMeResponse";
    private static final String PINGME_ACTION = "http://cxf.apache.org/greeter_control/Greeter/pingMeRequest";
    private static final String PINGME_RESPONSE_ACTION = "http://cxf.apache.org/greeter_control/Greeter/pingMeResponse";
    private static final String GREETER_FAULT_ACTION = "http://cxf.apache.org/greeter_control/Greeter/Fault/faultDetail";

    @BeforeClass
    public static void startServers() throws Exception {
        RMPolicyWsdlTest.assertTrue((String)"server did not launch correctly", (boolean)RMPolicyWsdlTest.launchServer(Server.class));
    }

    @Test
    public void testUsingRM() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus("org/apache/cxf/systest/ws/policy/rmwsdl.xml");
        PolicyTestUtils.setPolicyConstants(this.bus, "http://www.w3.org/2006/07/ws-policy");
        BusFactory.setDefaultBus((Bus)this.bus);
        OutMessageRecorder outRecorder = new OutMessageRecorder();
        this.bus.getOutInterceptors().add(outRecorder);
        InMessageRecorder inRecorder = new InMessageRecorder();
        this.bus.getInInterceptors().add(inRecorder);
        ReliableGreeterService gs = new ReliableGreeterService();
        Greeter greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        ConnectionHelper.setKeepAliveConnection(greeter, true);
        greeter.greetMeOneWay("CXF");
        RMPolicyWsdlTest.assertEquals((Object)"CXF", (Object)greeter.greetMe("cxf"));
        try {
            greeter.pingMe();
        }
        catch (PingMeFault ex) {
            RMPolicyWsdlTest.fail((String)"First invocation should have succeeded.");
        }
        try {
            greeter.pingMe();
            RMPolicyWsdlTest.fail((String)"Expected PingMeFault not thrown.");
        }
        catch (PingMeFault ex) {
            RMPolicyWsdlTest.assertEquals((Object)2, (Object)ex.getFaultInfo().getMajor());
            RMPolicyWsdlTest.assertEquals((Object)1, (Object)ex.getFaultInfo().getMinor());
        }
        MessageRecorder mr = new MessageRecorder(outRecorder, inRecorder);
        mr.awaitMessages(5, 9, 5000);
        MessageFlow mf = new MessageFlow(outRecorder.getOutboundMessages(), inRecorder.getInboundMessages());
        mf.verifyMessages(5, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETMEONEWAY_ACTION, GREETME_ACTION, PINGME_ACTION, PINGME_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3", "4"}, true);
        mf.verifyLastMessage(new boolean[]{false, false, false, false, false}, true);
        mf.verifyAcknowledgements(new boolean[]{false, false, false, true, true}, true);
        mf.verifyMessages(9, false);
        mf.verifyPartialResponses(5);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION, PINGME_RESPONSE_ACTION, GREETER_FAULT_ACTION};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3"}, false);
        mf.verifyLastMessage(new boolean[]{false, false, false, false}, false);
        mf.verifyAcknowledgements(new boolean[]{false, true, true, true}, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus("org/apache/cxf/systest/ws/policy/rmwsdl_server.xml");
            BusFactory.setDefaultBus((Bus)bus);
            ServerRegistry sr = (ServerRegistry)bus.getExtension(ServerRegistry.class);
            PolicyEngine pe = (PolicyEngine)bus.getExtension(PolicyEngine.class);
            List<Assertion> assertions1 = this.getAssertions(pe, (org.apache.cxf.endpoint.Server)sr.getServers().get(0));
            Server.assertEquals((String)"2 assertions should be available", (int)2, (int)assertions1.size());
            List<Assertion> assertions2 = this.getAssertions(pe, (org.apache.cxf.endpoint.Server)sr.getServers().get(1));
            Server.assertEquals((String)"1 assertion should be available", (int)1, (int)assertions2.size());
            LOG.info("Published greeter endpoints.");
        }

        protected List<Assertion> getAssertions(PolicyEngine pe, org.apache.cxf.endpoint.Server s) {
            Policy p1 = pe.getServerEndpointPolicy(s.getEndpoint().getEndpointInfo(), null).getPolicy();
            List pops = CastUtils.cast((List)p1.getPolicyComponents(), ExactlyOne.class);
            Server.assertEquals((String)"New policy must have 1 top level policy operator", (int)1, (int)pops.size());
            List alts = CastUtils.cast((List)((ExactlyOne)pops.get(0)).getPolicyComponents(), All.class);
            Server.assertEquals((String)"1 alternatives should be available", (int)1, (int)alts.size());
            return CastUtils.cast((List)((All)alts.get(0)).getAssertions(), Assertion.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

