/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.rm;

import java.util.logging.Logger;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.GreeterService;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.systest.ws.rm.GreeterImpl;
import org.apache.cxf.systest.ws.util.ConnectionHelper;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class DecoupledClientServerTest
extends AbstractBusClientServerTestBase {
    private static final Logger LOG = LogUtils.getLogger(DecoupledClientServerTest.class);
    private Bus bus;

    @BeforeClass
    public static void startServers() throws Exception {
        DecoupledClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)DecoupledClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testDecoupled() throws Exception {
        long start;
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus("/org/apache/cxf/systest/ws/rm/decoupled.xml");
        BusFactory.setDefaultBus((Bus)this.bus);
        LoggingInInterceptor in = new LoggingInInterceptor();
        this.bus.getInInterceptors().add(in);
        this.bus.getInFaultInterceptors().add(in);
        LoggingOutInterceptor out = new LoggingOutInterceptor();
        this.bus.getOutInterceptors().add(out);
        this.bus.getOutFaultInterceptors().add(out);
        GreeterService gs = new GreeterService();
        final Greeter greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        ConnectionHelper.setKeepAliveConnection(greeter, true);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TwowayThread
        extends Thread {
            String response;

            TwowayThread() {
            }

            @Override
            public void run() {
                this.response = greeter.greetMe("twoway");
            }
        }
        TwowayThread t = new TwowayThread();
        t.start();
        for (long wait = 3000L; wait > 0L; wait -= System.currentTimeMillis() - start) {
            start = System.currentTimeMillis();
            try {
                Thread.sleep(wait);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        greeter.greetMeOneWay("oneway");
        t.join();
        DecoupledClientServerTest.assertEquals((String)"Unexpected response to twoway request", (Object)"oneway", (Object)t.response);
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus("/org/apache/cxf/systest/ws/rm/decoupled.xml");
            BusFactory.setDefaultBus((Bus)bus);
            LoggingInInterceptor in = new LoggingInInterceptor();
            bus.getInInterceptors().add(in);
            bus.getInFaultInterceptors().add(in);
            LoggingOutInterceptor out = new LoggingOutInterceptor();
            bus.getOutInterceptors().add(out);
            bus.getOutFaultInterceptors().add(out);
            GreeterImpl implementor = new GreeterImpl();
            implementor.useLastOnewayArg(true);
            implementor.setDelay(5000L);
            String address = "http://localhost:9020/SoapContext/GreeterPort";
            Endpoint.publish((String)address, (Object)((Object)implementor));
            LOG.info("Published greeter endpoint.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

