/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.aegis;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.authservice.AuthService;
import org.apache.cxf.authservice.Authenticate;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.dynamic.DynamicClientFactory;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.systest.aegis.AegisServer;
import org.apache.cxf.systest.aegis.SportsService;
import org.apache.cxf.systest.aegis.Team;
import org.apache.cxf.test.TestUtilities;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AegisClientServerTest
extends AbstractBusClientServerTestBase {
    static final Logger LOG = LogUtils.getLogger(AegisClientServerTest.class);

    @BeforeClass
    public static void startServers() throws Exception {
        AegisClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)AegisClientServerTest.launchServer(AegisServer.class));
    }

    @Test
    public void testAegisClient() throws Exception {
        AegisDatabinding aegisBinding = new AegisDatabinding();
        ClientProxyFactoryBean proxyFactory = new ClientProxyFactoryBean();
        proxyFactory.setDataBinding((DataBinding)aegisBinding);
        proxyFactory.setServiceClass(AuthService.class);
        proxyFactory.setAddress("http://localhost:9002/service");
        AuthService service = (AuthService)proxyFactory.create();
        AegisClientServerTest.assertTrue((boolean)service.authenticate("Joe", "Joe", "123"));
        AegisClientServerTest.assertFalse((boolean)service.authenticate("Joe1", "Joe", "fang"));
        AegisClientServerTest.assertTrue((boolean)service.authenticate("Joe", null, "123"));
        List list = service.getRoles("Joe");
        AegisClientServerTest.assertEquals((Object)3, (Object)list.size());
        AegisClientServerTest.assertEquals((Object)"Joe", list.get(0));
        AegisClientServerTest.assertEquals((Object)"Joe-1", list.get(1));
        AegisClientServerTest.assertEquals((Object)"Joe-2", list.get(2));
        String[] roles = service.getRolesAsArray("Joe");
        AegisClientServerTest.assertEquals((Object)2, (Object)roles.length);
        AegisClientServerTest.assertEquals((Object)"Joe", (Object)roles[0]);
        AegisClientServerTest.assertEquals((Object)"Joe-1", (Object)roles[1]);
        AegisClientServerTest.assertEquals((Object)"get Joe", (Object)service.getAuthentication("Joe"));
        Authenticate au = new Authenticate();
        au.setSid("ffang");
        au.setUid("ffang");
        AegisClientServerTest.assertTrue((boolean)service.authenticate(au));
        au.setUid("ffang1");
        AegisClientServerTest.assertFalse((boolean)service.authenticate(au));
    }

    @Test
    public void testJaxWsAegisClient() throws Exception {
        AegisDatabinding aegisBinding = new AegisDatabinding();
        JaxWsProxyFactoryBean proxyFactory = new JaxWsProxyFactoryBean();
        proxyFactory.setDataBinding((DataBinding)aegisBinding);
        proxyFactory.setServiceClass(AuthService.class);
        proxyFactory.setAddress("http://localhost:9002/jaxwsAndAegis");
        AuthService service = (AuthService)proxyFactory.create();
        AegisClientServerTest.assertTrue((boolean)service.authenticate("Joe", "Joe", "123"));
        AegisClientServerTest.assertFalse((boolean)service.authenticate("Joe1", "Joe", "fang"));
        AegisClientServerTest.assertTrue((boolean)service.authenticate("Joe", null, "123"));
        List list = service.getRoles("Joe");
        AegisClientServerTest.assertEquals((Object)3, (Object)list.size());
        AegisClientServerTest.assertEquals((Object)"Joe", list.get(0));
        AegisClientServerTest.assertEquals((Object)"Joe-1", list.get(1));
        AegisClientServerTest.assertEquals((Object)"Joe-2", list.get(2));
        String[] roles = service.getRolesAsArray("Joe");
        AegisClientServerTest.assertEquals((Object)2, (Object)roles.length);
        AegisClientServerTest.assertEquals((Object)"Joe", (Object)roles[0]);
        AegisClientServerTest.assertEquals((Object)"Joe-1", (Object)roles[1]);
        roles = service.getRolesAsArray("null");
        AegisClientServerTest.assertNull((Object)roles);
        roles = service.getRolesAsArray("0");
        AegisClientServerTest.assertEquals((Object)0, (Object)roles.length);
        AegisClientServerTest.assertEquals((Object)"get Joe", (Object)service.getAuthentication("Joe"));
        Authenticate au = new Authenticate();
        au.setSid("ffang");
        au.setUid("ffang");
        AegisClientServerTest.assertTrue((boolean)service.authenticate(au));
        au.setUid("ffang1");
        AegisClientServerTest.assertFalse((boolean)service.authenticate(au));
    }

    @Test
    public void testWSDL() throws Exception {
        URL url = new URL("http://localhost:9002/jaxwsAndAegis?wsdl");
        Document dom = XMLUtils.parse((InputStream)url.openStream());
        TestUtilities util = new TestUtilities(((Object)((Object)this)).getClass());
        util.addDefaultNamespaces();
        util.assertInvalid("//wsdl:definitions/wsdl:types/xsd:schema/xsd:complexType[@name='getRolesAsArrayResponse']/xsd:sequence/xsd:element[@maxOccurs]", (Node)dom);
        util.assertValid("//wsdl:definitions/wsdl:types/xsd:schema/xsd:complexType[@name='getRolesAsArrayResponse']/xsd:sequence/xsd:element[@nillable='true']", (Node)dom);
        url = new URL("http://localhost:9002/serviceWithCustomNS?wsdl");
        dom = XMLUtils.parse((InputStream)url.openStream());
        util.assertValid("//wsdl:definitions[@targetNamespace='http://foo.bar.com']", (Node)dom);
    }

    @Test
    public void testCollection() throws Exception {
        AegisDatabinding aegisBinding = new AegisDatabinding();
        JaxWsProxyFactoryBean proxyFactory = new JaxWsProxyFactoryBean();
        proxyFactory.setDataBinding((DataBinding)aegisBinding);
        proxyFactory.setServiceClass(SportsService.class);
        proxyFactory.setWsdlLocation("http://localhost:9002/jaxwsAndAegisSports?wsdl");
        SportsService service = (SportsService)proxyFactory.create();
        Collection<Team> teams = service.getTeams();
        AegisClientServerTest.assertEquals((Object)1, (Object)teams.size());
        AegisClientServerTest.assertEquals((Object)"Patriots", (Object)teams.iterator().next().getName());
        String s = service.testForMinOccurs0("A", null, "b");
        AegisClientServerTest.assertEquals((Object)"Anullb", (Object)s);
    }

    @Test
    public void testDynamicClient() throws Exception {
        DynamicClientFactory dcf = DynamicClientFactory.newInstance();
        Client client = dcf.createClient("http://localhost:9002/jaxwsAndAegisSports?wsdl");
        Object r = client.invoke("getAttributeBean", new Object[0])[0];
        Method getAddrPlainString = r.getClass().getMethod("getAttrPlainString", new Class[0]);
        String s = (String)getAddrPlainString.invoke(r, new Object[0]);
        AegisClientServerTest.assertEquals((Object)"attrPlain", (Object)s);
    }
}

