/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.aegis;

import java.util.Map;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.systest.aegis.AegisJaxWs;
import org.apache.cxf.systest.aegis.bean.Item;
import org.junit.Test;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

public class AegisJaxWsTest
extends AbstractDependencyInjectionSpringContextTests {
    private AegisJaxWs client;

    protected String[] getConfigLocations() {
        return new String[]{"classpath:aegisJaxWsBeans.xml"};
    }

    private void setupForTest() throws Exception {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(AegisJaxWs.class);
        factory.setAddress("http://localhost:9167/aegisJaxWs");
        factory.getServiceFactory().setDataBinding((DataBinding)new AegisDatabinding());
        this.client = (AegisJaxWs)factory.create();
    }

    @Test
    public void testGetItem() throws Exception {
        this.setupForTest();
        Item item = this.client.getItemByKey("a", "b");
        AegisJaxWsTest.assertEquals((int)33, (int)item.getKey());
    }

    @Test
    public void testMapSpecified() throws Exception {
        this.setupForTest();
        Item item = new Item();
        item.setKey(new Integer(42));
        item.setData("Godzilla");
        this.client.addItem(item);
        Map<Integer, Item> items = this.client.getItemsMapSpecified();
        AegisJaxWsTest.assertNotNull(items);
        AegisJaxWsTest.assertEquals((int)1, (int)items.size());
        Map.Entry<Integer, Item> entry = items.entrySet().iterator().next();
        AegisJaxWsTest.assertNotNull(entry);
        Item item2 = entry.getValue();
        Integer key2 = entry.getKey();
        AegisJaxWsTest.assertEquals((int)42, (int)key2);
        AegisJaxWsTest.assertEquals((String)"Godzilla", (String)item2.getData());
    }
}

