/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.aegis;

import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.aegis.type.basic.CharacterAsStringType;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.test.TestUtilities;
import org.junit.Test;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CharacterSchemaTest
extends AbstractDependencyInjectionSpringContextTests {
    private TestUtilities testUtilities = new TestUtilities(((Object)((Object)this)).getClass());

    protected String[] getConfigLocations() {
        return new String[]{"classpath:aegisSportsServiceBeans.xml"};
    }

    @Test
    public void testSchema() throws Exception {
        this.testUtilities.setBus((Bus)this.applicationContext.getBean("cxf"));
        this.testUtilities.addDefaultNamespaces();
        this.testUtilities.addNamespace("aegis", "http://cxf.apache.org/aegisTypes");
        Server s = this.testUtilities.getServerForService(new QName("http://aegis.systest.cxf.apache.org/", "SportsService"));
        CharacterSchemaTest.assertNotNull((Object)s);
        Document wsdl = this.testUtilities.getWSDLDocument(s);
        CharacterSchemaTest.assertNotNull((Object)wsdl);
        NodeList typeAttrList = this.testUtilities.assertValid("//xsd:complexType[@name='BeanWithCharacter']/xsd:sequence/xsd:element[@name='character']/@type", (Node)wsdl);
        Attr typeAttr = (Attr)typeAttrList.item(0);
        String typeAttrValue = typeAttr.getValue();
        String[] pieces = typeAttrValue.split(":");
        CharacterSchemaTest.assertEquals((String)CharacterAsStringType.CHARACTER_AS_STRING_TYPE_QNAME.getLocalPart(), (String)pieces[1]);
        Element elementNode = typeAttr.getOwnerElement();
        String url = this.testUtilities.resolveNamespacePrefix(pieces[0], (Node)elementNode);
        CharacterSchemaTest.assertEquals((String)CharacterAsStringType.CHARACTER_AS_STRING_TYPE_QNAME.getNamespaceURI(), (String)url);
    }
}

