/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.aegis.mtom;

import java.util.HashMap;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.systest.aegis.mtom.fortest.DataHandlerBean;
import org.apache.cxf.systest.aegis.mtom.fortest.MtomTestImpl;
import org.apache.cxf.test.TestUtilities;
import org.junit.Test;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MtomTest
extends AbstractDependencyInjectionSpringContextTests {
    private MtomTestImpl impl;
    private org.apache.cxf.systest.aegis.mtom.fortest.MtomTest client;
    private TestUtilities testUtilities = new TestUtilities(((Object)((Object)this)).getClass());

    protected String[] getConfigLocations() {
        return new String[]{"classpath:mtomTestBeans.xml"};
    }

    private void setupForTest(boolean enableClientMTOM) throws Exception {
        AegisDatabinding aegisBinding = new AegisDatabinding();
        aegisBinding.setMtomEnabled(enableClientMTOM);
        ClientProxyFactoryBean proxyFac = new ClientProxyFactoryBean();
        proxyFac.setDataBinding((DataBinding)aegisBinding);
        proxyFac.setAddress("http://localhost:9002/mtom");
        proxyFac.setServiceClass(org.apache.cxf.systest.aegis.mtom.fortest.MtomTest.class);
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        if (enableClientMTOM) {
            props.put("mtom-enabled", Boolean.TRUE);
        }
        proxyFac.setProperties(props);
        this.client = (org.apache.cxf.systest.aegis.mtom.fortest.MtomTest)proxyFac.create();
        this.impl = (MtomTestImpl)this.applicationContext.getBean("mtomImpl");
    }

    @Test
    public void testMtomReply() throws Exception {
        this.setupForTest(true);
        DataHandlerBean dhBean = this.client.produceDataHandlerBean();
        MtomTest.assertNotNull((Object)dhBean);
        MtomTest.assertEquals((Object)"What rough beast, its hour come at last, slouches toward Bethlehem to be born?", (Object)dhBean.getDataHandler().getContent());
    }

    @Test
    public void testAcceptDataHandler() throws Exception {
        this.setupForTest(true);
        DataHandlerBean dhBean = new DataHandlerBean();
        dhBean.setName("some name");
        String someData = "This is the cereal shot from guns.";
        DataHandler dataHandler = new DataHandler((Object)someData, "text/plain;charset=utf-8");
        dhBean.setDataHandler(dataHandler);
        this.client.acceptDataHandler(dhBean);
        DataHandlerBean accepted = this.impl.getLastDhBean();
        MtomTest.assertNotNull((Object)accepted);
        String data = (String)accepted.getDataHandler().getContent();
        MtomTest.assertNotNull((Object)data);
        MtomTest.assertEquals((String)"This is the cereal shot from guns.", (String)data);
    }

    @Test
    public void testAcceptDataHandlerNoMTOM() throws Exception {
        this.setupForTest(false);
        DataHandlerBean dhBean = new DataHandlerBean();
        dhBean.setName("some name");
        String someData = "This is the cereal shot from guns.";
        DataHandler dataHandler = new DataHandler((Object)someData, "text/plain;charset=utf-8");
        dhBean.setDataHandler(dataHandler);
        this.client.acceptDataHandler(dhBean);
        DataHandlerBean accepted = this.impl.getLastDhBean();
        MtomTest.assertNotNull((Object)accepted);
        Object data = accepted.getDataHandler().getContent();
        MtomTest.assertNotNull((Object)data);
        MtomTest.assertEquals((Object)"This is the cereal shot from guns.", (Object)data);
    }

    @Test
    public void testMtomSchema() throws Exception {
        this.testUtilities.setBus((Bus)this.applicationContext.getBean("cxf"));
        this.testUtilities.addDefaultNamespaces();
        this.testUtilities.addNamespace("xmime", "http://www.w3.org/2005/05/xmlmime");
        Server s = this.testUtilities.getServerForService(new QName("http://fortest.mtom.aegis.systest.cxf.apache.org/", "MtomTest"));
        Document wsdl = this.testUtilities.getWSDLDocument(s);
        MtomTest.assertNotNull((Object)wsdl);
        NodeList typeAttrList = this.testUtilities.assertValid("//xsd:complexType[@name='inputDhBean']/xsd:sequence/xsd:element[@name='dataHandler']/@type", (Node)wsdl);
        Attr typeAttr = (Attr)typeAttrList.item(0);
        String typeAttrValue = typeAttr.getValue();
        String[] pieces = typeAttrValue.split(":");
        MtomTest.assertEquals((String)"base64Binary", (String)pieces[1]);
        Element elementNode = typeAttr.getOwnerElement();
        String url = this.testUtilities.resolveNamespacePrefix(pieces[0], (Node)elementNode);
        MtomTest.assertEquals((String)"http://www.w3.org/2001/XMLSchema", (String)url);
        s = this.testUtilities.getServerForAddress("http://localhost:9002/mtomXmime");
        wsdl = this.testUtilities.getWSDLDocument(s);
        MtomTest.assertNotNull((Object)wsdl);
        typeAttrList = this.testUtilities.assertValid("//xsd:complexType[@name='inputDhBean']/xsd:sequence/xsd:element[@name='dataHandler']/@type", (Node)wsdl);
        typeAttr = (Attr)typeAttrList.item(0);
        typeAttrValue = typeAttr.getValue();
        pieces = typeAttrValue.split(":");
        MtomTest.assertEquals((String)"base64Binary", (String)pieces[1]);
        elementNode = typeAttr.getOwnerElement();
        url = this.testUtilities.resolveNamespacePrefix(pieces[0], (Node)elementNode);
        MtomTest.assertEquals((String)"http://www.w3.org/2005/05/xmlmime", (String)url);
    }
}

