/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.basicDOCBare;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.systest.basicDOCBare.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world_doc_lit_bare.PutLastTradedPricePortType;
import org.apache.hello_world_doc_lit_bare.SOAPService;
import org.apache.hello_world_doc_lit_bare.types.TradePriceData;
import org.junit.BeforeClass;
import org.junit.Test;

public class DOCBareClientServerTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/hello_world_doc_lit_bare", "SOAPService");
    private final QName portName = new QName("http://apache.org/hello_world_doc_lit_bare", "SoapPort");

    @BeforeClass
    public static void startServers() throws Exception {
        System.setProperty("org.apache.cxf.bus.factory", "org.apache.cxf.bus.CXFBusFactory");
        DOCBareClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)DOCBareClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testBasicConnection() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/doc_lit_bare.wsdl");
        DOCBareClientServerTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        DOCBareClientServerTest.assertNotNull((String)"Service is null", (Object)service);
        PutLastTradedPricePortType putLastTradedPrice = (PutLastTradedPricePortType)service.getPort(this.portName, PutLastTradedPricePortType.class);
        String response = putLastTradedPrice.bareNoParam();
        DOCBareClientServerTest.assertEquals((Object)"testResponse", (Object)response);
        TradePriceData priceData = new TradePriceData();
        priceData.setTickerPrice(1.0f);
        priceData.setTickerSymbol("CELTIX");
        Holder holder = new Holder((Object)priceData);
        for (int i = 0; i < 5; ++i) {
            putLastTradedPrice.sayHi(holder);
            DOCBareClientServerTest.assertEquals((Object)Float.valueOf(4.5f), (Object)Float.valueOf(((TradePriceData)holder.value).getTickerPrice()));
            DOCBareClientServerTest.assertEquals((Object)"APACHE", (Object)((TradePriceData)holder.value).getTickerSymbol());
            putLastTradedPrice.putLastTradedPrice(priceData);
        }
    }

    @Test
    public void testAnnotation() throws Exception {
        Annotation[][] paraAnns;
        WebMethod ann;
        Class<PutLastTradedPricePortType> claz = PutLastTradedPricePortType.class;
        TradePriceData priceData = new TradePriceData();
        Holder holder = new Holder((Object)priceData);
        Method method = claz.getMethod("sayHi", holder.getClass());
        DOCBareClientServerTest.assertNotNull((String)"Can not find SayHi method in generated class ", (Object)method);
        WebMethod webMethod = ann = method.getAnnotation(WebMethod.class);
        DOCBareClientServerTest.assertEquals((Object)webMethod.operationName(), (Object)"SayHi");
        Annotation[][] arr$ = paraAnns = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] paraType;
            for (Annotation an : paraType = arr$[i$]) {
                if (an.annotationType() != WebParam.class) continue;
                WebParam webParam = (WebParam)an;
                DOCBareClientServerTest.assertNotSame((Object)"", (Object)webParam.targetNamespace());
            }
        }
    }

    @Test
    public void testNillableParameter() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/doc_lit_bare.wsdl");
        DOCBareClientServerTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        DOCBareClientServerTest.assertNotNull((String)"Service is null", (Object)service);
        PutLastTradedPricePortType port = (PutLastTradedPricePortType)service.getPort(this.portName, PutLastTradedPricePortType.class);
        String result = port.nillableParameter(null);
        DOCBareClientServerTest.assertNull((Object)result);
    }
}

