/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.clustering;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Response;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.greeter_control.Control;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.types.FaultLocation;
import org.apache.cxf.greeter_control.types.StartGreeterResponse;
import org.apache.cxf.greeter_control.types.StopGreeterResponse;
import org.apache.cxf.systest.clustering.GreeterImplA;
import org.apache.cxf.systest.clustering.GreeterImplB;
import org.apache.cxf.systest.clustering.GreeterImplC;
import org.apache.cxf.systest.clustering.GreeterImplD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="ControlService", portName="ControlPort", endpointInterface="org.apache.cxf.greeter_control.Control", targetNamespace="http://cxf.apache.org/greeter_control")
public class ControlImpl
implements Control {
    private static final Logger LOG = LogUtils.getLogger(ControlImpl.class);
    private Map<String, Greeter> implementors = new HashMap<String, Greeter>();
    private Map<String, Endpoint> endpoints;

    ControlImpl() {
        this.implementors.put("http://localhost:9051/SoapContext/ReplicatedPortA", (Greeter)new GreeterImplA());
        this.implementors.put("http://localhost:9052/SoapContext/ReplicatedPortB", (Greeter)new GreeterImplB());
        this.implementors.put("http://localhost:9053/SoapContext/ReplicatedPortC", (Greeter)new GreeterImplC());
        this.implementors.put("http://localhost:9054/SoapContext/ReplicatedPortD", (Greeter)new GreeterImplD());
        this.endpoints = new HashMap<String, Endpoint>();
    }

    public boolean startGreeter(String address) {
        this.endpoints.put(address, Endpoint.publish((String)address, (Object)this.implementors.get(address)));
        LOG.info("Published greeter endpoint on: " + address);
        return true;
    }

    public boolean stopGreeter(String address) {
        Endpoint endpoint = this.endpoints.get(address);
        if (null != endpoint) {
            LOG.info("Stopping Greeter endpoint on: " + address);
            endpoint.stop();
        } else {
            LOG.info("No endpoint active for: " + address);
        }
        endpoint = null;
        return true;
    }

    public void setFaultLocation(FaultLocation fl) {
    }

    public Future<?> startGreeterAsync(String requestType, AsyncHandler<StartGreeterResponse> asyncHandler) {
        return null;
    }

    public Response<StartGreeterResponse> startGreeterAsync(String requestType) {
        return null;
    }

    public Response<StopGreeterResponse> stopGreeterAsync(String requestType) {
        return null;
    }

    public Future<?> stopGreeterAsync(String requestType, AsyncHandler<StopGreeterResponse> asyncHandler) {
        return null;
    }
}

