/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.coloc;

import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.systest.coloc.AbstractColocTest;
import org.apache.headers.coloc.types.HeaderInfo;
import org.apache.headers.coloc.types.InHeaderResponseT;
import org.apache.headers.coloc.types.InHeaderT;
import org.apache.headers.coloc.types.InoutHeaderResponseT;
import org.apache.headers.coloc.types.InoutHeaderT;
import org.apache.headers.coloc.types.OutHeaderResponseT;
import org.apache.headers.coloc.types.OutHeaderT;
import org.apache.headers.doc_lit.HeaderTester;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractHeaderServiceDocLitTest
extends AbstractColocTest {
    static final QName SERVICE_NAME = new QName("http://apache.org/headers/doc_lit", "SOAPHeaderService");
    static final QName PORT_NAME = new QName("http://apache.org/headers/doc_lit", "SoapPort9000");
    static final String WSDL_LOCATION = "/wsdl/header_doc_lit.wsdl";
    private HeaderTester service;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = this.getPort(this.getServiceQname(), this.getPortQName(), this.getWsdlLocation(), HeaderTester.class);
    }

    @Test
    public void testInHeaderParts() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyInHeaderParts(this.service);
        }
    }

    @Test
    public void testInOutHeaderParts() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyInOutHeaderParts(this.service);
        }
    }

    @Test
    public void testOutHeaderParts() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyOutHeaderParts(this.service);
        }
    }

    @Test
    public void testAll() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyInHeaderParts(this.service);
            this.verifyInOutHeaderParts(this.service);
            this.verifyOutHeaderParts(this.service);
        }
    }

    protected void verifyInHeaderParts(HeaderTester ht) {
        this.getLogger().debug((Object)"Client: calling inHeader");
        InHeaderT inHeader = new InHeaderT();
        inHeader.setRequestType("in request type");
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setMessage("in message");
        headerInfo.setOriginator("in originator");
        InHeaderResponseT inHeaderResponse = ht.inHeader(inHeader, headerInfo);
        AbstractHeaderServiceDocLitTest.assertEquals((Object)"out Header type", (Object)inHeaderResponse.getResponseType());
    }

    protected void verifyInOutHeaderParts(HeaderTester ht) {
        this.getLogger().debug((Object)"Client: calling inoutHeader");
        InoutHeaderT inoutHeader = new InoutHeaderT();
        inoutHeader.setRequestType("inout request type in");
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setMessage("inout message in");
        headerInfo.setOriginator("inout originator in");
        Holder holder = new Holder();
        holder.value = headerInfo;
        InoutHeaderResponseT inoutHeaderResponse = ht.inoutHeader(inoutHeader, holder);
        AbstractHeaderServiceDocLitTest.assertEquals((Object)"inout request type out", (Object)inoutHeaderResponse.getResponseType());
        AbstractHeaderServiceDocLitTest.assertNotSame((Object)"inout request type out", (Object)inoutHeader.getRequestType());
        AbstractHeaderServiceDocLitTest.assertEquals((Object)"inout message out", (Object)((HeaderInfo)holder.value).getMessage());
        AbstractHeaderServiceDocLitTest.assertEquals((Object)"inout orginator out", (Object)((HeaderInfo)holder.value).getOriginator());
    }

    protected void verifyOutHeaderParts(HeaderTester ht) {
        this.getLogger().debug((Object)"Client: calling outHeader");
        OutHeaderT outHeader = new OutHeaderT();
        outHeader.setRequestType("out request test");
        OutHeaderResponseT theResponse = new OutHeaderResponseT();
        theResponse.setResponseType("bogus");
        Holder respHolder = new Holder();
        respHolder.value = theResponse;
        Holder holder = new Holder();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setMessage("out message in");
        headerInfo.setOriginator("out orginator in");
        holder.value = headerInfo;
        ht.outHeader(outHeader, respHolder, holder);
        AbstractHeaderServiceDocLitTest.assertEquals((Object)"out message out", (Object)((HeaderInfo)holder.value).getMessage());
        AbstractHeaderServiceDocLitTest.assertEquals((Object)"out orginator out", (Object)((HeaderInfo)holder.value).getOriginator());
        AbstractHeaderServiceDocLitTest.assertEquals((Object)"out Header type", (Object)((OutHeaderResponseT)respHolder.value).getResponseType());
    }

    protected String getWsdlLocation() {
        return WSDL_LOCATION;
    }

    protected QName getServiceQname() {
        return SERVICE_NAME;
    }

    protected QName getPortQName() {
        return PORT_NAME;
    }

    protected HeaderTester getService() {
        return this.service;
    }
}

