/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.coloc;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.message.Message;
import org.apache.cxf.systest.coloc.AbstractColocTest;
import org.apache.headers.coloc.types.FaultDetailT;
import org.apache.headers.coloc.types.HeaderInfo;
import org.apache.headers.coloc.types.InHeaderResponseT;
import org.apache.headers.coloc.types.InHeaderT;
import org.apache.headers.coloc.types.InoutHeaderResponseT;
import org.apache.headers.coloc.types.InoutHeaderT;
import org.apache.headers.coloc.types.OutHeaderResponseT;
import org.apache.headers.coloc.types.OutHeaderT;
import org.apache.headers.coloc.types.PingMeResponseT;
import org.apache.headers.coloc.types.PingMeT;
import org.apache.headers.rpc_lit.HeaderTester;
import org.apache.headers.rpc_lit.PingMeFault;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractHeaderServiceRpcLitTest
extends AbstractColocTest {
    static final QName SERVICE_NAME = new QName("http://apache.org/headers/rpc_lit", "SOAPHeaderService");
    static final QName PORT_NAME = new QName("http://apache.org/headers/rpc_lit", "SoapPort");
    static final String WSDL_LOCATION = "/wsdl/header_rpc_lit.wsdl";
    private HeaderTester port;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.port = this.getPort(this.getServiceQname(), this.getPortQName(), this.getWsdlLocation(), HeaderTester.class);
    }

    @Test
    public void testTwoWayOperation() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyTwoWay(this.port);
        }
    }

    @Test
    public void testInHeaderParts() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyInHeaderParts(this.port);
        }
    }

    @Test
    public void testInOutHeaderParts() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyInOutHeaderParts(this.port);
        }
    }

    @Test
    public void testOutHeaderParts() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyOutHeaderParts(this.port);
        }
    }

    @Test
    public void testFault() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyFaults(this.port);
        }
    }

    @Test
    public void testAll() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyTwoWay(this.port);
            this.verifyInHeaderParts(this.port);
            this.verifyInOutHeaderParts(this.port);
            this.verifyOutHeaderParts(this.port);
            this.verifyFaults(this.port);
        }
    }

    public void verifyTwoWay(HeaderTester ht) {
        this.getLogger().debug((Object)"Client: calling pingMe");
        PingMeT in = new PingMeT();
        try {
            in.setFaultType("ABCD");
            PingMeResponseT ret = ht.pingMe(in);
            AbstractHeaderServiceRpcLitTest.assertNotNull((Object)ret);
        }
        catch (Exception ex) {
            AbstractHeaderServiceRpcLitTest.fail((String)"Should not throw any exception");
        }
    }

    protected void verifyInHeaderParts(HeaderTester ht) {
        this.getLogger().debug((Object)"Client: calling inHeader");
        InHeaderT inHeader = new InHeaderT();
        inHeader.setRequestType("in request type");
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setMessage("in message");
        headerInfo.setOriginator("in originator");
        InHeaderResponseT inHeaderResponse = ht.inHeader(inHeader, headerInfo);
        AbstractHeaderServiceRpcLitTest.assertEquals((Object)"out Header type", (Object)inHeaderResponse.getResponseType());
    }

    protected void verifyInOutHeaderParts(HeaderTester ht) {
        this.getLogger().debug((Object)"Client: calling inoutHeader");
        InoutHeaderT inoutHeader = new InoutHeaderT();
        inoutHeader.setRequestType("inout request type in");
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setMessage("inout message in");
        headerInfo.setOriginator("inout originator in");
        Holder holder = new Holder();
        holder.value = headerInfo;
        InoutHeaderResponseT inoutHeaderResponse = ht.inoutHeader(inoutHeader, holder);
        AbstractHeaderServiceRpcLitTest.assertEquals((Object)"inout request type out", (Object)inoutHeaderResponse.getResponseType());
        AbstractHeaderServiceRpcLitTest.assertNotSame((Object)"inout request type out", (Object)inoutHeader.getRequestType());
        AbstractHeaderServiceRpcLitTest.assertEquals((Object)"inout message out", (Object)((HeaderInfo)holder.value).getMessage());
        AbstractHeaderServiceRpcLitTest.assertEquals((Object)"inout orginator out", (Object)((HeaderInfo)holder.value).getOriginator());
    }

    protected void verifyOutHeaderParts(HeaderTester ht) {
        this.getLogger().debug((Object)"Client: calling outHeader");
        OutHeaderT outHeader = new OutHeaderT();
        outHeader.setRequestType("out request test");
        OutHeaderResponseT theResponse = new OutHeaderResponseT();
        theResponse.setResponseType("bogus");
        Holder respHolder = new Holder();
        respHolder.value = theResponse;
        Holder holder = new Holder();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setMessage("out message in");
        headerInfo.setOriginator("out orginator in");
        holder.value = headerInfo;
        ht.outHeader(outHeader, respHolder, holder);
        AbstractHeaderServiceRpcLitTest.assertEquals((Object)"out message out", (Object)((HeaderInfo)holder.value).getMessage());
        AbstractHeaderServiceRpcLitTest.assertEquals((Object)"out orginator out", (Object)((HeaderInfo)holder.value).getOriginator());
        AbstractHeaderServiceRpcLitTest.assertEquals((Object)"out Header type", (Object)((OutHeaderResponseT)respHolder.value).getResponseType());
    }

    public void verifyFaults(HeaderTester ht) {
        PingMeT in;
        block10: {
            this.getLogger().debug((Object)"Client: calling pingMe user fault");
            in = new PingMeT();
            try {
                in.setFaultType("USER");
                ht.pingMe(in);
                AbstractHeaderServiceRpcLitTest.fail((String)"Should throw a PingeMeFault exception");
            }
            catch (PingMeFault pmf) {
                FaultDetailT detail = pmf.getFaultInfo();
                AbstractHeaderServiceRpcLitTest.assertNotNull((Object)detail);
                AbstractHeaderServiceRpcLitTest.assertEquals((String)"Major Version should be 1", (Object)1, (Object)detail.getMajor());
                AbstractHeaderServiceRpcLitTest.assertEquals((String)"Minor Version should be 2", (Object)2, (Object)detail.getMinor());
                if (!this.isFaultCodeCheckEnabled()) break block10;
                this.verifyFaultCode(this.port);
            }
        }
        this.getLogger().debug((Object)"Client: calling pingMe Cxf System Fault");
        try {
            in.setFaultType("SYSTEM");
            ht.pingMe(in);
            AbstractHeaderServiceRpcLitTest.fail((String)"Should throw a CXF Fault exception");
        }
        catch (WebServiceException fault) {
            AbstractHeaderServiceRpcLitTest.assertFalse((String)("Wrong message: " + fault.getMessage()), (-1 == fault.getMessage().lastIndexOf("CXF RUNTIME EXCEPTION") ? 1 : 0) != 0);
            if (this.isFaultCodeCheckEnabled()) {
                this.verifyFaultCode(this.port);
            }
        }
        catch (PingMeFault pmf) {
            AbstractHeaderServiceRpcLitTest.fail((String)"Should not receive PingMefault");
        }
        this.getLogger().debug((Object)"Client: calling pingMe java runtime exception");
        try {
            in.setFaultType("RUNTIME");
            ht.pingMe(in);
            AbstractHeaderServiceRpcLitTest.fail((String)"Should throw a CXF Fault exception");
        }
        catch (WebServiceException fault) {
            AbstractHeaderServiceRpcLitTest.assertFalse((-1 == fault.getMessage().lastIndexOf("CXF RUNTIME EXCEPTION") ? 1 : 0) != 0);
            if (this.isFaultCodeCheckEnabled()) {
                this.verifyFaultCode(this.port);
            }
        }
        catch (PingMeFault pmf) {
            AbstractHeaderServiceRpcLitTest.fail((String)"Should not receive PingMefault");
        }
    }

    protected void verifyFaultCode(HeaderTester proxy) {
        BindingProvider bp = (BindingProvider)proxy;
        Map respCtx = bp.getResponseContext();
        AbstractHeaderServiceRpcLitTest.assertNotNull((Object)respCtx);
        Integer val = (Integer)respCtx.get(Message.RESPONSE_CODE);
        AbstractHeaderServiceRpcLitTest.assertNotNull((Object)val);
        AbstractHeaderServiceRpcLitTest.assertEquals((String)"Message.RESPONSE_CODE should be 500", (Object)500, (Object)val);
    }

    protected String getWsdlLocation() {
        return WSDL_LOCATION;
    }

    protected QName getServiceQname() {
        return SERVICE_NAME;
    }

    protected QName getPortQName() {
        return PORT_NAME;
    }

    protected boolean isFaultCodeCheckEnabled() {
        return false;
    }
}

