/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.coloc;

import javax.xml.namespace.QName;
import org.apache.cxf.systest.coloc.AbstractColocTest;
import org.apache.hello_world_soap_http.BadRecordLitFault;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.apache.hello_world_soap_http.NoSuchCodeLitFault;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractWrappedDocLitTest
extends AbstractColocTest {
    static final QName SERVICE_NAME = new QName("http://apache.org/hello_world_soap_http", "SOAPService");
    static final QName PORT_NAME = new QName("http://apache.org/hello_world_soap_http", "SoapPort");
    static final String WSDL_LOCATION = "/wsdl/hello_world.wsdl";
    private Greeter port;
    private GreeterImpl impl = new GreeterImpl();

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.port = this.getPort(this.getServiceQname(), this.getPortQName(), this.getWsdlLocation(), Greeter.class);
    }

    @Test
    public void testTwoWayOperation() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifySayHi(this.port);
            this.verifyGreetMe(this.port);
        }
    }

    @Test
    public void testOneWayOperation() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyGreetMeOneway(this.port);
        }
    }

    @Test
    public void testFault() {
        for (int idx = 0; idx < 2; ++idx) {
            this.verifyTestDocLitFault(this.port);
        }
    }

    protected void verifyTestDocLitFault(Greeter proxy) {
        try {
            proxy.testDocLitFault(BadRecordLitFault.class.getSimpleName());
            AbstractWrappedDocLitTest.fail((String)"Should throw a BadRecordLitFault Exception");
        }
        catch (BadRecordLitFault brlf) {
            AbstractWrappedDocLitTest.assertEquals((Object)BadRecordLitFault.class.getSimpleName(), (Object)brlf.getFaultInfo());
        }
        catch (NoSuchCodeLitFault nsclf) {
            AbstractWrappedDocLitTest.fail((String)"Should not throw a NoSuchCodeLitFault Exception");
        }
    }

    protected void verifyGreetMeOneway(Greeter proxy) {
        int count = this.impl.getInvocationCount();
        proxy.greetMeOneWay("oneWay");
        AbstractWrappedDocLitTest.assertTrue((String)"Count Should not be same", (count != this.impl.getInvocationCount() ? 1 : 0) != 0);
    }

    protected void verifySayHi(Greeter greeterPort) {
        String resp = greeterPort.sayHi();
        AbstractWrappedDocLitTest.assertEquals((Object)"Bonjour", (Object)resp);
    }

    protected void verifyGreetMe(Greeter greeterPort) {
        String resp = greeterPort.greetMe("BART");
        AbstractWrappedDocLitTest.assertEquals((Object)"Hello BART", (Object)resp);
    }

    protected Object getServiceImpl() {
        return this.impl;
    }

    protected String getWsdlLocation() {
        return WSDL_LOCATION;
    }

    protected QName getServiceQname() {
        return SERVICE_NAME;
    }

    protected QName getPortQName() {
        return PORT_NAME;
    }

    protected boolean isFaultCodeCheckEnabled() {
        return false;
    }
}

