/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.dispatch;

import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Future;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.systest.dispatch.TestDispatchFeature;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.apache.hello_world_soap_http.SOAPService;
import org.apache.hello_world_soap_http.types.GreetMe;
import org.apache.hello_world_soap_http.types.GreetMeResponse;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DispatchClientServerTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/hello_world_soap_http", "SOAPDispatchService");
    private final QName portName = new QName("http://apache.org/hello_world_soap_http", "SoapDispatchPort");

    @BeforeClass
    public static void startServers() throws Exception {
        DispatchClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)DispatchClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testSOAPMessage() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        DispatchClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        DispatchClientServerTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portName, SOAPMessage.class, Service.Mode.MESSAGE);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq.xml");
        SOAPMessage soapReqMsg = MessageFactory.newInstance().createMessage(null, is);
        DispatchClientServerTest.assertNotNull((Object)soapReqMsg);
        SOAPMessage soapResMsg = (SOAPMessage)disp.invoke((Object)soapReqMsg);
        DispatchClientServerTest.assertNotNull((Object)soapResMsg);
        String expected = "Hello TestSOAPInputMessage";
        DispatchClientServerTest.assertEquals((String)"Response should be : Hello TestSOAPInputMessage", (Object)expected, (Object)soapResMsg.getSOAPBody().getTextContent().trim());
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq1.xml");
        SOAPMessage soapReqMsg1 = MessageFactory.newInstance().createMessage(null, is1);
        DispatchClientServerTest.assertNotNull((Object)soapReqMsg1);
        disp.invokeOneWay((Object)soapReqMsg1);
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq2.xml");
        SOAPMessage soapReqMsg2 = MessageFactory.newInstance().createMessage(null, is2);
        DispatchClientServerTest.assertNotNull((Object)soapReqMsg2);
        Response response = disp.invokeAsync((Object)soapReqMsg2);
        SOAPMessage soapResMsg2 = (SOAPMessage)response.get();
        DispatchClientServerTest.assertNotNull((Object)soapResMsg2);
        String expected2 = "Hello TestSOAPInputMessage2";
        DispatchClientServerTest.assertEquals((String)"Response should be : Hello TestSOAPInputMessage2", (Object)expected2, (Object)soapResMsg2.getSOAPBody().getTextContent().trim());
        InputStream is3 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq3.xml");
        SOAPMessage soapReqMsg3 = MessageFactory.newInstance().createMessage(null, is3);
        DispatchClientServerTest.assertNotNull((Object)soapReqMsg3);
        TestSOAPMessageHandler tsmh = new TestSOAPMessageHandler();
        Future f = disp.invokeAsync((Object)soapReqMsg3, (AsyncHandler)tsmh);
        DispatchClientServerTest.assertNotNull((Object)f);
        while (!f.isDone()) {
        }
        String expected3 = "Hello TestSOAPInputMessage3";
        DispatchClientServerTest.assertEquals((String)"Response should be : Hello TestSOAPInputMessage3", (Object)expected3, (Object)tsmh.getReplyBuffer().trim());
    }

    @Test
    public void testDOMSourceMESSAGE() throws Exception {
        Service service = Service.create((QName)this.serviceName);
        DispatchClientServerTest.assertNotNull((Object)service);
        service.addPort(this.portName, "http://schemas.xmlsoap.org/soap/", "http://localhost:9006/SOAPDispatchService/SoapDispatchPort");
        Dispatch disp = service.createDispatch(this.portName, DOMSource.class, Service.Mode.MESSAGE);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq.xml");
        SOAPMessage soapReqMsg = MessageFactory.newInstance().createMessage(null, is);
        DOMSource domReqMsg = new DOMSource((Node)soapReqMsg.getSOAPPart());
        DispatchClientServerTest.assertNotNull((Object)domReqMsg);
        DOMSource domResMsg = (DOMSource)disp.invoke((Object)domReqMsg);
        DispatchClientServerTest.assertNotNull((Object)domResMsg);
        String expected = "Hello TestSOAPInputMessage";
        DispatchClientServerTest.assertEquals((String)"Response should be : Hello TestSOAPInputMessage", (Object)expected, (Object)domResMsg.getNode().getFirstChild().getTextContent().trim());
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq1.xml");
        SOAPMessage soapReqMsg1 = MessageFactory.newInstance().createMessage(null, is1);
        DOMSource domReqMsg1 = new DOMSource((Node)soapReqMsg1.getSOAPPart());
        DispatchClientServerTest.assertNotNull((Object)domReqMsg1);
        disp.invokeOneWay((Object)domReqMsg1);
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq2.xml");
        SOAPMessage soapReqMsg2 = MessageFactory.newInstance().createMessage(null, is2);
        DOMSource domReqMsg2 = new DOMSource((Node)soapReqMsg2.getSOAPPart());
        DispatchClientServerTest.assertNotNull((Object)domReqMsg2);
        Response response = disp.invokeAsync((Object)domReqMsg2);
        DOMSource domRespMsg2 = (DOMSource)response.get();
        DispatchClientServerTest.assertNotNull((Object)domReqMsg2);
        String expected2 = "Hello TestSOAPInputMessage2";
        DispatchClientServerTest.assertEquals((String)"Response should be : Hello TestSOAPInputMessage2", (Object)expected2, (Object)domRespMsg2.getNode().getFirstChild().getTextContent().trim());
        InputStream is3 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq3.xml");
        SOAPMessage soapReqMsg3 = MessageFactory.newInstance().createMessage(null, is3);
        DOMSource domReqMsg3 = new DOMSource((Node)soapReqMsg3.getSOAPPart());
        DispatchClientServerTest.assertNotNull((Object)domReqMsg3);
        TestDOMSourceHandler tdsh = new TestDOMSourceHandler();
        Future fd = disp.invokeAsync((Object)domReqMsg3, (AsyncHandler)tdsh);
        DispatchClientServerTest.assertNotNull((Object)fd);
        while (!fd.isDone()) {
        }
        String expected3 = "Hello TestSOAPInputMessage3";
        DispatchClientServerTest.assertEquals((String)"Response should be : Hello TestSOAPInputMessage3", (Object)expected3, (Object)tdsh.getReplyBuffer().trim());
    }

    @Test
    public void testDOMSourcePAYLOAD() throws Exception {
        Service service = Service.create((QName)this.serviceName);
        DispatchClientServerTest.assertNotNull((Object)service);
        service.addPort(this.portName, "http://schemas.xmlsoap.org/soap/", "http://localhost:9006/SOAPDispatchService/SoapDispatchPort");
        Dispatch disp = service.createDispatch(this.portName, DOMSource.class, Service.Mode.PAYLOAD);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq.xml");
        SOAPMessage soapReqMsg = MessageFactory.newInstance().createMessage(null, is);
        DOMSource domReqMsg = new DOMSource(soapReqMsg.getSOAPBody().extractContentAsDocument());
        DispatchClientServerTest.assertNotNull((Object)domReqMsg);
        DOMSource domResMsg = (DOMSource)disp.invoke((Object)domReqMsg);
        DispatchClientServerTest.assertNotNull((Object)domResMsg);
        String expected = "Hello TestSOAPInputMessage";
        DispatchClientServerTest.assertEquals((String)"Response should be : Hello TestSOAPInputMessage", (Object)expected, (Object)domResMsg.getNode().getTextContent().trim());
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq1.xml");
        SOAPMessage soapReqMsg1 = MessageFactory.newInstance().createMessage(null, is1);
        DOMSource domReqMsg1 = new DOMSource(soapReqMsg1.getSOAPBody().extractContentAsDocument());
        DispatchClientServerTest.assertNotNull((Object)domReqMsg1);
        disp.invokeOneWay((Object)domReqMsg1);
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq2.xml");
        SOAPMessage soapReqMsg2 = MessageFactory.newInstance().createMessage(null, is2);
        DOMSource domReqMsg2 = new DOMSource(soapReqMsg2.getSOAPBody().extractContentAsDocument());
        DispatchClientServerTest.assertNotNull((Object)domReqMsg2);
        Response response = disp.invokeAsync((Object)domReqMsg2);
        DOMSource domRespMsg2 = (DOMSource)response.get();
        DispatchClientServerTest.assertNotNull((Object)domRespMsg2);
        String expected2 = "Hello TestSOAPInputMessage2";
        DispatchClientServerTest.assertEquals((String)"Response should be : Hello TestSOAPInputMessage2", (Object)expected2, (Object)domRespMsg2.getNode().getTextContent().trim());
        InputStream is3 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq3.xml");
        SOAPMessage soapReqMsg3 = MessageFactory.newInstance().createMessage(null, is3);
        DOMSource domReqMsg3 = new DOMSource(soapReqMsg3.getSOAPBody().extractContentAsDocument());
        DispatchClientServerTest.assertNotNull((Object)domReqMsg3);
        TestDOMSourceHandler tdsh = new TestDOMSourceHandler();
        Future fd = disp.invokeAsync((Object)domReqMsg3, (AsyncHandler)tdsh);
        DispatchClientServerTest.assertNotNull((Object)fd);
        while (!fd.isDone()) {
        }
        String expected3 = "Hello TestSOAPInputMessage3";
        DispatchClientServerTest.assertEquals((String)"Response should be : Hello TestSOAPInputMessage3", (Object)expected3, (Object)tdsh.getReplyBuffer().trim());
    }

    @Test
    public void testJAXBObjectPAYLOAD() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        DispatchClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        DispatchClientServerTest.assertNotNull((Object)service);
        JAXBContext jc = JAXBContext.newInstance((String)"org.apache.hello_world_soap_http.types");
        Dispatch disp = service.createDispatch(this.portName, jc, Service.Mode.PAYLOAD);
        String expected = "Hello Jeeves";
        GreetMe greetMe = new GreetMe();
        greetMe.setRequestType("Jeeves");
        Object response = disp.invoke((Object)greetMe);
        DispatchClientServerTest.assertNotNull((Object)response);
        String responseValue = ((GreetMeResponse)response).getResponseType();
        DispatchClientServerTest.assertTrue((String)("Expected string, " + expected), (boolean)expected.equals(responseValue));
        disp.invokeOneWay((Object)greetMe);
        Response response2 = disp.invokeAsync((Object)greetMe);
        DispatchClientServerTest.assertNotNull((Object)response2);
        GreetMeResponse greetMeResponse = (GreetMeResponse)response2.get();
        String responseValue2 = greetMeResponse.getResponseType();
        DispatchClientServerTest.assertTrue((String)("Expected string, " + expected), (boolean)expected.equals(responseValue2));
        TestJAXBHandler tjbh = new TestJAXBHandler();
        Future fd = disp.invokeAsync((Object)greetMe, (AsyncHandler)tjbh);
        DispatchClientServerTest.assertNotNull((Object)fd);
        while (!fd.isDone()) {
        }
        String responseValue3 = ((GreetMeResponse)tjbh.getResponse()).getResponseType();
        DispatchClientServerTest.assertTrue((String)("Expected string, " + expected), (boolean)expected.equals(responseValue3));
    }

    @Test
    public void testJAXBObjectPAYLOADWithFeature() throws Exception {
        this.bus = BusFactory.getDefaultBus((boolean)false);
        this.bus.shutdown(true);
        this.configFileName = "org/apache/cxf/systest/dispatch/client-config.xml";
        SpringBusFactory bf = (SpringBusFactory)SpringBusFactory.newInstance();
        this.bus = bf.createBus(this.configFileName, false);
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        DispatchClientServerTest.assertNotNull((Object)wsdl);
        String bindingId = "http://schemas.xmlsoap.org/wsdl/soap/";
        String endpointUrl = "http://localhost:9006/SOAPDispatchService/SoapDispatchPort";
        Service service = Service.create((URL)wsdl, (QName)this.serviceName);
        service.addPort(this.portName, bindingId, endpointUrl);
        DispatchClientServerTest.assertNotNull((Object)service);
        JAXBContext jc = JAXBContext.newInstance((String)"org.apache.hello_world_soap_http.types");
        Dispatch disp = service.createDispatch(this.portName, jc, Service.Mode.PAYLOAD);
        String expected = "Hello Jeeves";
        GreetMe greetMe = new GreetMe();
        greetMe.setRequestType("Jeeves");
        Object response = disp.invoke((Object)greetMe);
        DispatchClientServerTest.assertNotNull((Object)response);
        String responseValue = ((GreetMeResponse)response).getResponseType();
        DispatchClientServerTest.assertTrue((String)("Expected string, " + expected), (boolean)expected.equals(responseValue));
        DispatchClientServerTest.assertEquals((String)"Feature should be applied", (Object)1, (Object)TestDispatchFeature.getCount());
        DispatchClientServerTest.assertEquals((String)"Feature based interceptors should be added", (Object)1, (Object)TestDispatchFeature.getCount());
        DispatchClientServerTest.assertEquals((String)"Feature based In interceptors has be added to in chain.", (Object)1, (Object)TestDispatchFeature.getInInterceptorCount());
        DispatchClientServerTest.assertEquals((String)"Feature based interceptors has to be added to out chain.", (Object)1, (Object)TestDispatchFeature.getOutInterceptorCount());
    }

    @Test
    public void testSAXSourceMESSAGE() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        DispatchClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        DispatchClientServerTest.assertNotNull((Object)service);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq.xml");
        InputSource inputSource = new InputSource(is);
        SAXSource saxSourceReq = new SAXSource(inputSource);
        DispatchClientServerTest.assertNotNull((Object)saxSourceReq);
        Dispatch disp = service.createDispatch(this.portName, SAXSource.class, Service.Mode.MESSAGE);
        SAXSource saxSourceResp = (SAXSource)disp.invoke((Object)saxSourceReq);
        DispatchClientServerTest.assertNotNull((Object)saxSourceResp);
        String expected = "Hello TestSOAPInputMessage";
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)saxSourceResp).contains(expected));
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq1.xml");
        InputSource inputSource1 = new InputSource(is1);
        SAXSource saxSourceReq1 = new SAXSource(inputSource1);
        DispatchClientServerTest.assertNotNull((Object)saxSourceReq1);
        disp.invokeOneWay((Object)saxSourceReq1);
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq2.xml");
        InputSource inputSource2 = new InputSource(is2);
        SAXSource saxSourceReq2 = new SAXSource(inputSource2);
        DispatchClientServerTest.assertNotNull((Object)saxSourceReq2);
        Response response = disp.invokeAsync((Object)saxSourceReq2);
        SAXSource saxSourceResp2 = (SAXSource)response.get();
        DispatchClientServerTest.assertNotNull((Object)saxSourceResp2);
        String expected2 = "Hello TestSOAPInputMessage2";
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)saxSourceResp2).contains(expected2));
        InputStream is3 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq3.xml");
        InputSource inputSource3 = new InputSource(is3);
        SAXSource saxSourceReq3 = new SAXSource(inputSource3);
        DispatchClientServerTest.assertNotNull((Object)saxSourceReq3);
        TestSAXSourceHandler tssh = new TestSAXSourceHandler();
        Future fd = disp.invokeAsync((Object)saxSourceReq3, (AsyncHandler)tssh);
        DispatchClientServerTest.assertNotNull((Object)fd);
        while (!fd.isDone()) {
        }
        String expected3 = "Hello TestSOAPInputMessage3";
        SAXSource saxSourceResp3 = tssh.getSAXSource();
        DispatchClientServerTest.assertNotNull((Object)saxSourceResp3);
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)saxSourceResp3).contains(expected3));
    }

    @Test
    public void testSAXSourcePAYLOAD() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        DispatchClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        DispatchClientServerTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portName, SAXSource.class, Service.Mode.PAYLOAD);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralSOAPBodyReq.xml");
        InputSource inputSource = new InputSource(is);
        SAXSource saxSourceReq = new SAXSource(inputSource);
        DispatchClientServerTest.assertNotNull((Object)saxSourceReq);
        SAXSource saxSourceResp = (SAXSource)disp.invoke((Object)saxSourceReq);
        DispatchClientServerTest.assertNotNull((Object)saxSourceResp);
        String expected = "Hello TestSOAPInputMessage";
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)saxSourceResp).contains(expected));
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralSOAPBodyReq1.xml");
        InputSource inputSource1 = new InputSource(is1);
        SAXSource saxSourceReq1 = new SAXSource(inputSource1);
        DispatchClientServerTest.assertNotNull((Object)saxSourceReq1);
        disp.invokeOneWay((Object)saxSourceReq1);
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralSOAPBodyReq2.xml");
        InputSource inputSource2 = new InputSource(is2);
        SAXSource saxSourceReq2 = new SAXSource(inputSource2);
        DispatchClientServerTest.assertNotNull((Object)saxSourceReq2);
        Response response = disp.invokeAsync((Object)saxSourceReq2);
        SAXSource saxSourceResp2 = (SAXSource)response.get();
        DispatchClientServerTest.assertNotNull((Object)saxSourceResp2);
        String expected2 = "Hello TestSOAPInputMessage2";
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)saxSourceResp2).contains(expected2));
        InputStream is3 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralSOAPBodyReq3.xml");
        InputSource inputSource3 = new InputSource(is3);
        SAXSource saxSourceReq3 = new SAXSource(inputSource3);
        DispatchClientServerTest.assertNotNull((Object)saxSourceReq3);
        TestSAXSourceHandler tssh = new TestSAXSourceHandler();
        Future fd = disp.invokeAsync((Object)saxSourceReq3, (AsyncHandler)tssh);
        DispatchClientServerTest.assertNotNull((Object)fd);
        while (!fd.isDone()) {
        }
        String expected3 = "Hello TestSOAPInputMessage3";
        SAXSource saxSourceResp3 = tssh.getSAXSource();
        DispatchClientServerTest.assertNotNull((Object)saxSourceResp3);
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)saxSourceResp3).contains(expected3));
    }

    @Test
    public void testStreamSourceMESSAGE() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        DispatchClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        DispatchClientServerTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portName, StreamSource.class, Service.Mode.MESSAGE);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq.xml");
        StreamSource streamSourceReq = new StreamSource(is);
        DispatchClientServerTest.assertNotNull((Object)streamSourceReq);
        StreamSource streamSourceResp = (StreamSource)disp.invoke((Object)streamSourceReq);
        DispatchClientServerTest.assertNotNull((Object)streamSourceResp);
        String expected = "Hello TestSOAPInputMessage";
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)streamSourceResp).contains(expected));
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq1.xml");
        StreamSource streamSourceReq1 = new StreamSource(is1);
        DispatchClientServerTest.assertNotNull((Object)streamSourceReq1);
        disp.invokeOneWay((Object)streamSourceReq1);
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq2.xml");
        StreamSource streamSourceReq2 = new StreamSource(is2);
        DispatchClientServerTest.assertNotNull((Object)streamSourceReq2);
        Response response = disp.invokeAsync((Object)streamSourceReq2);
        StreamSource streamSourceResp2 = (StreamSource)response.get();
        DispatchClientServerTest.assertNotNull((Object)streamSourceResp2);
        String expected2 = "Hello TestSOAPInputMessage2";
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)streamSourceResp2).contains(expected2));
        InputStream is3 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq3.xml");
        StreamSource streamSourceReq3 = new StreamSource(is3);
        DispatchClientServerTest.assertNotNull((Object)streamSourceReq3);
        TestStreamSourceHandler tssh = new TestStreamSourceHandler();
        Future fd = disp.invokeAsync((Object)streamSourceReq3, (AsyncHandler)tssh);
        DispatchClientServerTest.assertNotNull((Object)fd);
        while (!fd.isDone()) {
        }
        String expected3 = "Hello TestSOAPInputMessage3";
        StreamSource streamSourceResp3 = tssh.getStreamSource();
        DispatchClientServerTest.assertNotNull((Object)streamSourceResp3);
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)streamSourceResp3).contains(expected3));
    }

    @Test
    public void testStreamSourcePAYLOAD() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        DispatchClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        DispatchClientServerTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portName, StreamSource.class, Service.Mode.PAYLOAD);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralSOAPBodyReq.xml");
        StreamSource streamSourceReq = new StreamSource(is);
        DispatchClientServerTest.assertNotNull((Object)streamSourceReq);
        StreamSource streamSourceResp = (StreamSource)disp.invoke((Object)streamSourceReq);
        DispatchClientServerTest.assertNotNull((Object)streamSourceResp);
        String expected = "Hello TestSOAPInputMessage";
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)streamSourceResp).contains(expected));
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralSOAPBodyReq1.xml");
        StreamSource streamSourceReq1 = new StreamSource(is1);
        DispatchClientServerTest.assertNotNull((Object)streamSourceReq1);
        disp.invokeOneWay((Object)streamSourceReq1);
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralSOAPBodyReq2.xml");
        StreamSource streamSourceReq2 = new StreamSource(is2);
        DispatchClientServerTest.assertNotNull((Object)streamSourceReq2);
        Response response = disp.invokeAsync((Object)streamSourceReq2);
        StreamSource streamSourceResp2 = (StreamSource)response.get();
        DispatchClientServerTest.assertNotNull((Object)streamSourceResp2);
        String expected2 = "Hello TestSOAPInputMessage2";
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)streamSourceResp2).contains(expected2));
        InputStream is3 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralSOAPBodyReq3.xml");
        StreamSource streamSourceReq3 = new StreamSource(is3);
        DispatchClientServerTest.assertNotNull((Object)streamSourceReq3);
        TestStreamSourceHandler tssh = new TestStreamSourceHandler();
        Future fd = disp.invokeAsync((Object)streamSourceReq3, (AsyncHandler)tssh);
        DispatchClientServerTest.assertNotNull((Object)fd);
        while (!fd.isDone()) {
        }
        String expected3 = "Hello TestSOAPInputMessage3";
        StreamSource streamSourceResp3 = tssh.getStreamSource();
        DispatchClientServerTest.assertNotNull((Object)streamSourceResp3);
        DispatchClientServerTest.assertTrue((String)("Expected: " + expected), (boolean)XMLUtils.toString((Source)streamSourceResp3).contains(expected3));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestStreamSourceHandler
    implements AsyncHandler<StreamSource> {
        StreamSource reply;

        TestStreamSourceHandler() {
        }

        public void handleResponse(Response<StreamSource> response) {
            try {
                this.reply = (StreamSource)response.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public StreamSource getStreamSource() {
            return this.reply;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestSAXSourceHandler
    implements AsyncHandler<SAXSource> {
        SAXSource reply;

        TestSAXSourceHandler() {
        }

        public void handleResponse(Response<SAXSource> response) {
            try {
                this.reply = (SAXSource)response.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public SAXSource getSAXSource() {
            return this.reply;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestJAXBHandler
    implements AsyncHandler<Object> {
        Object reply;

        TestJAXBHandler() {
        }

        public void handleResponse(Response<Object> response) {
            try {
                this.reply = response.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Object getResponse() {
            return this.reply;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestDOMSourceHandler
    implements AsyncHandler<DOMSource> {
        String replyBuffer;

        TestDOMSourceHandler() {
        }

        public void handleResponse(Response<DOMSource> response) {
            try {
                DOMSource reply = (DOMSource)response.get();
                this.replyBuffer = DOMUtils.getChild((Node)reply.getNode(), (int)1).getTextContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getReplyBuffer() {
            return this.replyBuffer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestSOAPMessageHandler
    implements AsyncHandler<SOAPMessage> {
        String replyBuffer;

        TestSOAPMessageHandler() {
        }

        public void handleResponse(Response<SOAPMessage> response) {
            try {
                SOAPMessage reply = (SOAPMessage)response.get();
                this.replyBuffer = reply.getSOAPBody().getTextContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getReplyBuffer() {
            return this.replyBuffer;
        }
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            GreeterImpl implementor = new GreeterImpl();
            String address = "http://localhost:9006/SOAPDispatchService/SoapDispatchPort";
            Endpoint.publish((String)address, (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

