/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.dispatch;

import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.systest.dispatch.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world_xml_http.wrapped.XMLService;
import org.apache.hello_world_xml_http.wrapped.types.GreetMe;
import org.apache.hello_world_xml_http.wrapped.types.GreetMeResponse;
import org.apache.hello_world_xml_http.wrapped.types.ObjectFactory;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DispatchXMLClientServerTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/hello_world_xml_http/wrapped", "XMLService");
    private final QName portName = new QName("http://apache.org/hello_world_xml_http/wrapped", "XMLDispatchPort");

    @BeforeClass
    public static void startServers() throws Exception {
        DispatchXMLClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)DispatchXMLClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testJAXBMESSAGE() throws Exception {
        Service service = Service.create((QName)this.serviceName);
        DispatchXMLClientServerTest.assertNotNull((Object)service);
        service.addPort(this.portName, "http://cxf.apache.org/bindings/xformat", "http://localhost:9007/XMLService/XMLDispatchPort");
        GreetMe gm = new GreetMe();
        gm.setRequestType("CXF");
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Dispatch disp = service.createDispatch(this.portName, ctx, Service.Mode.MESSAGE);
        GreetMeResponse resp = (GreetMeResponse)disp.invoke((Object)gm);
        DispatchXMLClientServerTest.assertNotNull((Object)resp);
        DispatchXMLClientServerTest.assertEquals((Object)"Hello CXF", (Object)resp.getResponseType());
        try {
            disp.invoke(null);
            DispatchXMLClientServerTest.fail((String)"Should have thrown a fault");
        }
        catch (WebServiceException ex) {
            // empty catch block
        }
    }

    @Test
    public void testStreamSourceMESSAGE() throws Exception {
        Service service = Service.create((QName)this.serviceName);
        DispatchXMLClientServerTest.assertNotNull((Object)service);
        service.addPort(this.portName, "http://cxf.apache.org/bindings/xformat", "http://localhost:9007/XMLService/XMLDispatchPort");
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/messages/XML_GreetMeDocLiteralReq.xml");
        StreamSource reqMsg = new StreamSource(is);
        DispatchXMLClientServerTest.assertNotNull((Object)reqMsg);
        Dispatch disp = service.createDispatch(this.portName, Source.class, Service.Mode.MESSAGE);
        Source source = (Source)disp.invoke((Object)reqMsg);
        DispatchXMLClientServerTest.assertNotNull((Object)source);
        String streamString = XMLUtils.toString((Source)source);
        Document doc = XMLUtils.parse((String)streamString);
        DispatchXMLClientServerTest.assertEquals((Object)"greetMeResponse", (Object)doc.getFirstChild().getLocalName());
        DispatchXMLClientServerTest.assertEquals((Object)"Hello tli", (Object)doc.getFirstChild().getTextContent());
    }

    @Test
    public void testDOMSourcePAYLOAD() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_xml_wrapped.wsdl");
        DispatchXMLClientServerTest.assertNotNull((Object)wsdl);
        XMLService service = new XMLService(wsdl, this.serviceName);
        DispatchXMLClientServerTest.assertNotNull((Object)service);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/messages/XML_GreetMeDocLiteralReq.xml");
        Document doc = XMLUtils.parse((InputStream)is);
        DOMSource reqMsg = new DOMSource(doc);
        DispatchXMLClientServerTest.assertNotNull((Object)reqMsg);
        Dispatch disp = service.createDispatch(this.portName, DOMSource.class, Service.Mode.PAYLOAD);
        DOMSource result = (DOMSource)disp.invoke((Object)reqMsg);
        DispatchXMLClientServerTest.assertNotNull((Object)result);
        Node respDoc = result.getNode();
        DispatchXMLClientServerTest.assertEquals((Object)"greetMeResponse", (Object)respDoc.getFirstChild().getLocalName());
        DispatchXMLClientServerTest.assertEquals((Object)"Hello tli", (Object)respDoc.getFirstChild().getTextContent());
    }
}

