/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.factory_pattern;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.cxf.Bus;
import org.apache.cxf.factory_pattern.IsEvenResponse;
import org.apache.cxf.factory_pattern.Number;
import org.apache.cxf.factory_pattern.NumberFactory;
import org.apache.cxf.factory_pattern.NumberFactoryService;
import org.apache.cxf.factory_pattern.NumberService;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.jaxws.support.ServiceDelegateAccessor;
import org.apache.cxf.systest.factory_pattern.ManualNumberFactoryImpl;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.junit.BeforeClass;
import org.junit.Test;

public class ManualHttpMulitplexClientServerTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        ManualHttpMulitplexClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)ManualHttpMulitplexClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testWithManualMultiplexEprCreation() throws Exception {
        NumberFactoryService service = new NumberFactoryService();
        NumberFactory nfact = service.getNumberFactoryPort();
        W3CEndpointReference w3cEpr = nfact.create("2");
        ManualHttpMulitplexClientServerTest.assertNotNull((String)"reference", (Object)w3cEpr);
        EndpointReferenceType epr = VersionTransformer.convertToInternal((EndpointReference)w3cEpr);
        QName serviceName = EndpointReferenceUtils.getServiceName((EndpointReferenceType)epr, (Bus)this.bus);
        Service numService = Service.create((QName)serviceName);
        String portString = EndpointReferenceUtils.getPortName((EndpointReferenceType)epr);
        QName portName = new QName(serviceName.getNamespaceURI(), portString);
        numService.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/", "http://foo");
        Number num = (Number)numService.getPort(portName, Number.class);
        this.setupContextWithEprAddress(epr, num);
        IsEvenResponse numResp = num.isEven();
        ManualHttpMulitplexClientServerTest.assertTrue((String)"2 is even", (boolean)Boolean.TRUE.equals(numResp.isEven()));
        w3cEpr = nfact.create("3");
        epr = VersionTransformer.convertToInternal((EndpointReference)w3cEpr);
        this.setupContextWithEprAddress(epr, num);
        numResp = num.isEven();
        ManualHttpMulitplexClientServerTest.assertTrue((String)"3 is not even", (boolean)Boolean.FALSE.equals(numResp.isEven()));
        w3cEpr = nfact.create("6");
        epr = VersionTransformer.convertToInternal((EndpointReference)w3cEpr);
        this.setupContextWithEprAddress(epr, num);
        numResp = num.isEven();
        ManualHttpMulitplexClientServerTest.assertTrue((String)"6 is even", (boolean)Boolean.TRUE.equals(numResp.isEven()));
    }

    @Test
    public void testWithGetPortExtensionHttp() throws Exception {
        NumberFactoryService service = new NumberFactoryService();
        NumberFactory factory = service.getNumberFactoryPort();
        W3CEndpointReference w3cEpr = factory.create("20");
        EndpointReferenceType numberTwoRef = VersionTransformer.convertToInternal((EndpointReference)w3cEpr);
        ManualHttpMulitplexClientServerTest.assertNotNull((String)"reference", (Object)numberTwoRef);
        NumberService numService = new NumberService();
        ServiceImpl serviceImpl = ServiceDelegateAccessor.get((Service)numService);
        Number num = (Number)serviceImpl.getPort(numberTwoRef, Number.class);
        ManualHttpMulitplexClientServerTest.assertTrue((String)"20 is even", (boolean)num.isEven().isEven());
        w3cEpr = factory.create("23");
        EndpointReferenceType numberTwentyThreeRef = VersionTransformer.convertToInternal((EndpointReference)w3cEpr);
        num = (Number)serviceImpl.getPort(numberTwentyThreeRef, Number.class);
        ManualHttpMulitplexClientServerTest.assertTrue((String)"23 is not even", (!num.isEven().isEven() ? 1 : 0) != 0);
    }

    private void setupContextWithEprAddress(EndpointReferenceType epr, Number num) {
        String address = EndpointReferenceUtils.getAddress((EndpointReferenceType)epr);
        InvocationHandler handler = Proxy.getInvocationHandler(num);
        BindingProvider bp = null;
        if (handler instanceof BindingProvider) {
            bp = (BindingProvider)handler;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", address);
        }
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            ManualNumberFactoryImpl implementor = new ManualNumberFactoryImpl();
            Endpoint.publish((String)"http://localhost:9006/NumberFactoryService/NumberFactoryPort", (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

