/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.factory_pattern;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.cxf.factory_pattern.IsEvenResponse;
import org.apache.cxf.factory_pattern.Number;
import org.apache.cxf.factory_pattern.NumberFactory;
import org.apache.cxf.factory_pattern.NumberFactoryService;
import org.apache.cxf.factory_pattern.NumberService;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.jaxws.support.ServiceDelegateAccessor;
import org.apache.cxf.systest.factory_pattern.HttpNumberFactoryImpl;
import org.apache.cxf.systest.factory_pattern.NumberFactoryImpl;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class MultiplexHttpAddressClientServerTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cxf.config.file", "org/apache/cxf/systest/factory_pattern/cxf.xml");
        MultiplexHttpAddressClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)MultiplexHttpAddressClientServerTest.launchServer(Server.class, props, null, (boolean)false));
    }

    @Test
    public void testWithGetPortExtensionHttp() throws Exception {
        NumberFactoryService service = new NumberFactoryService();
        NumberFactory factory = service.getNumberFactoryPort();
        NumberService numService = new NumberService();
        ServiceImpl serviceImpl = ServiceDelegateAccessor.get((Service)numService);
        W3CEndpointReference numberTwoRef = factory.create("20");
        MultiplexHttpAddressClientServerTest.assertNotNull((String)"reference", (Object)numberTwoRef);
        Number num = (Number)serviceImpl.getPort((EndpointReference)numberTwoRef, Number.class, new WebServiceFeature[0]);
        MultiplexHttpAddressClientServerTest.assertTrue((String)"20 is even", (boolean)num.isEven().isEven());
        W3CEndpointReference numberTwentyThreeRef = factory.create("23");
        num = (Number)serviceImpl.getPort((EndpointReference)numberTwentyThreeRef, Number.class, new WebServiceFeature[0]);
        MultiplexHttpAddressClientServerTest.assertTrue((String)"23 is not even", (!num.isEven().isEven() ? 1 : 0) != 0);
    }

    @Test
    public void testWithManualMultiplexEprCreation() throws Exception {
        Service numService = Service.create((QName)NumberFactoryImpl.NUMBER_SERVICE_QNAME);
        Number num = (Number)numService.getPort(Number.class);
        InvocationHandler handler = Proxy.getInvocationHandler(num);
        BindingProvider bp = (BindingProvider)handler;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:9006/NumberService/NumberPort/103");
        IsEvenResponse numResp = num.isEven();
        MultiplexHttpAddressClientServerTest.assertTrue((String)"103 is not even", (boolean)Boolean.FALSE.equals(numResp.isEven()));
    }

    @Test
    public void testWithGetWsdlOnServant() throws Exception {
        int firstChar = new URL("http://localhost:9006/NumberService/NumberPort/?wsdl").openStream().read();
        MultiplexHttpAddressClientServerTest.assertTrue((String)("firstChar :" + String.valueOf(firstChar)), (firstChar == 60 ? 1 : 0) != 0);
        firstChar = new URL("http://localhost:9006/NumberService/NumberPort/103?wsdl").openStream().read();
        MultiplexHttpAddressClientServerTest.assertTrue((String)("firstChar :" + String.valueOf(firstChar)), (firstChar == 60 ? 1 : 0) != 0);
    }

    @Test
    public void testSoapAddressLocation() throws Exception {
        MultiplexHttpAddressClientServerTest.assertTrue((String)"Should have received the soap:address location http://localhost:9006/NumberService/NumberPort/", (boolean)this.checkSoapAddressLocation("http://localhost:9006/NumberService/NumberPort/"));
        MultiplexHttpAddressClientServerTest.assertTrue((String)"Should have received the soap:address location http://localhost:9006/NumberService/NumberPort/20", (boolean)this.checkSoapAddressLocation("http://localhost:9006/NumberService/NumberPort/20"));
        MultiplexHttpAddressClientServerTest.assertTrue((String)"Should have received the soap:address location http://localhost:9006/NumberService/NumberPort/22", (boolean)this.checkSoapAddressLocation("http://localhost:9006/NumberService/NumberPort/22"));
        MultiplexHttpAddressClientServerTest.assertTrue((String)"Should have received the soap:address location http://localhost:9006/NumberService/NumberPort/20", (boolean)this.checkSoapAddressLocation("http://localhost:9006/NumberService/NumberPort/20"));
        MultiplexHttpAddressClientServerTest.assertTrue((String)"Should have received the soap:address location http://localhost:9006/NumberService/NumberPort/", (boolean)this.checkSoapAddressLocation("http://localhost:9006/NumberService/NumberPort/"));
    }

    private boolean checkSoapAddressLocation(String address) throws Exception {
        URL url = new URL(address + "?wsdl");
        URLConnection urlConn = url.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
        while (br.ready()) {
            String str = br.readLine();
            if (!str.contains("soap:address") || !str.contains("location=\"" + address + "\"")) continue;
            return true;
        }
        return false;
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            HttpNumberFactoryImpl implementor = new HttpNumberFactoryImpl();
            Endpoint.publish((String)"http://localhost:9006/NumberFactoryService/NumberFactoryPort", (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

