/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.handlers;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.systest.handlers.HandlerServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.handlers.AddNumbersService;
import org.apache.handlers.types.AddNumbers;
import org.apache.handlers.types.AddNumbersResponse;
import org.apache.handlers.types.ObjectFactory;
import org.apache.hello_world_xml_http.wrapped.XMLService;
import org.apache.hello_world_xml_http.wrapped.types.GreetMe;
import org.apache.hello_world_xml_http.wrapped.types.GreetMeResponse;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Node;

public class DispatchHandlerInvocationTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/handlers", "AddNumbersService");
    private final QName portName = new QName("http://apache.org/handlers", "AddNumbersPort");
    private final QName portNameXML = new QName("http://apache.org/hello_world_xml_http/wrapped", "XMLDispatchPort");

    @BeforeClass
    public static void startServers() throws Exception {
        DispatchHandlerInvocationTest.assertTrue((String)"server did not launch correctly", (boolean)DispatchHandlerInvocationTest.launchServer(HandlerServer.class));
    }

    @Test
    public void testInvokeWithJAXBPayloadMode() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        DispatchHandlerInvocationTest.assertNotNull((Object)wsdl);
        AddNumbersService service = new AddNumbersService(wsdl, this.serviceName);
        DispatchHandlerInvocationTest.assertNotNull((Object)service);
        JAXBContext jc = JAXBContext.newInstance((String)"org.apache.handlers.types");
        Dispatch disp = service.createDispatch(this.portName, jc, Service.Mode.PAYLOAD);
        TestHandler handler = new TestHandler();
        TestSOAPHandler soapHandler = new TestSOAPHandler();
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{handler, soapHandler});
        AddNumbers req = new AddNumbers();
        req.setArg0(10);
        req.setArg1(20);
        ObjectFactory factory = new ObjectFactory();
        JAXBElement e = factory.createAddNumbers(req);
        JAXBElement response = (JAXBElement)disp.invoke((Object)e);
        DispatchHandlerInvocationTest.assertNotNull((Object)response);
        AddNumbersResponse value = (AddNumbersResponse)response.getValue();
        DispatchHandlerInvocationTest.assertEquals((Object)222, (Object)value.getReturn());
    }

    @Test
    public void testInvokeWithDOMSourcMessageMode() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        DispatchHandlerInvocationTest.assertNotNull((Object)wsdl);
        AddNumbersService service = new AddNumbersService(wsdl, this.serviceName);
        DispatchHandlerInvocationTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portName, DOMSource.class, Service.Mode.MESSAGE);
        TestHandler handler = new TestHandler();
        TestSOAPHandler soapHandler = new TestSOAPHandler();
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{handler, soapHandler});
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq.xml");
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage soapReq = factory.createMessage(null, is);
        DOMSource domReqMessage = new DOMSource((Node)soapReq.getSOAPPart());
        DOMSource response = (DOMSource)disp.invoke((Object)domReqMessage);
        DispatchHandlerInvocationTest.assertNotNull((Object)response);
    }

    @Test
    public void testInvokeWithDOMSourcPayloadMode() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        DispatchHandlerInvocationTest.assertNotNull((Object)wsdl);
        AddNumbersService service = new AddNumbersService(wsdl, this.serviceName);
        DispatchHandlerInvocationTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portName, DOMSource.class, Service.Mode.PAYLOAD);
        TestHandler handler = new TestHandler();
        TestSOAPHandler soapHandler = new TestSOAPHandler();
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{handler, soapHandler});
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReqPayload.xml");
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage soapReq = factory.createMessage(null, is2);
        DOMSource domReqMessage = new DOMSource((Node)soapReq.getSOAPPart());
        DOMSource response = (DOMSource)disp.invoke((Object)domReqMessage);
        DispatchHandlerInvocationTest.assertNotNull((Object)response);
    }

    @Test
    public void testInvokeWithSOAPMessageMessageMode() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        DispatchHandlerInvocationTest.assertNotNull((Object)wsdl);
        AddNumbersService service = new AddNumbersService(wsdl, this.serviceName);
        DispatchHandlerInvocationTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portName, SOAPMessage.class, Service.Mode.MESSAGE);
        TestHandler handler = new TestHandler();
        TestSOAPHandler soapHandler = new TestSOAPHandler();
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{handler, soapHandler});
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq.xml");
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage soapReq = factory.createMessage(null, is2);
        SOAPMessage response = (SOAPMessage)disp.invoke((Object)soapReq);
        DispatchHandlerInvocationTest.assertNotNull((Object)response);
    }

    @Test
    public void testInvokeWithSOAPMessagePayloadMode() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        DispatchHandlerInvocationTest.assertNotNull((Object)wsdl);
        AddNumbersService service = new AddNumbersService(wsdl, this.serviceName);
        DispatchHandlerInvocationTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portName, SOAPMessage.class, Service.Mode.PAYLOAD);
        TestHandler handler = new TestHandler();
        TestSOAPHandler soapHandler = new TestSOAPHandler();
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{handler, soapHandler});
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/GreetMeDocLiteralReq.xml");
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage soapReq = factory.createMessage(null, is2);
        try {
            disp.invoke((Object)soapReq);
            DispatchHandlerInvocationTest.fail((String)"Did not get expected exception");
        }
        catch (SOAPFaultException e) {
            DispatchHandlerInvocationTest.assertTrue((String)"Did not get expected exception message", (e.getMessage().indexOf("is not valid in PAYLOAD mode with SOAP/HTTP binding") > -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testInvokeWithDOMSourcMessageModeXMLBinding() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        DispatchHandlerInvocationTest.assertNotNull((Object)wsdl);
        XMLService service = new XMLService();
        DispatchHandlerInvocationTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portNameXML, DOMSource.class, Service.Mode.MESSAGE);
        TestHandlerXMLBinding handler = new TestHandlerXMLBinding();
        TestSOAPHandler soapHandler = new TestSOAPHandler();
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{handler, soapHandler});
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/messages/XML_GreetMeDocLiteralReq.xml");
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage soapReq = factory.createMessage(null, is);
        DOMSource domReqMessage = new DOMSource((Node)soapReq.getSOAPPart());
        DOMSource response = (DOMSource)disp.invoke((Object)domReqMessage);
        DispatchHandlerInvocationTest.assertNotNull((Object)response);
    }

    @Test
    public void testInvokeWithDOMSourcPayloadModeXMLBinding() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        DispatchHandlerInvocationTest.assertNotNull((Object)wsdl);
        XMLService service = new XMLService();
        DispatchHandlerInvocationTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portNameXML, DOMSource.class, Service.Mode.PAYLOAD);
        TestHandlerXMLBinding handler = new TestHandlerXMLBinding();
        TestSOAPHandler soapHandler = new TestSOAPHandler();
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{handler, soapHandler});
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/messages/XML_GreetMeDocLiteralReq.xml");
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage soapReq = factory.createMessage(null, is);
        DOMSource domReqMessage = new DOMSource((Node)soapReq.getSOAPPart());
        DOMSource response = (DOMSource)disp.invoke((Object)domReqMessage);
        DispatchHandlerInvocationTest.assertNotNull((Object)response);
    }

    @Test
    public void testInvokeWithDataSourcMessageModeXMLBinding() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        DispatchHandlerInvocationTest.assertNotNull((Object)wsdl);
        XMLService service = new XMLService();
        DispatchHandlerInvocationTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portNameXML, DataSource.class, Service.Mode.MESSAGE);
        TestHandlerXMLBinding handler = new TestHandlerXMLBinding();
        TestSOAPHandler soapHandler = new TestSOAPHandler();
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{handler, soapHandler});
        URL is = ((Object)((Object)this)).getClass().getResource("/messages/XML_GreetMeDocLiteralReq.xml");
        URLDataSource ds = new URLDataSource(is);
        try {
            disp.invoke((Object)ds);
            DispatchHandlerInvocationTest.fail((String)"Did not get expected exception");
        }
        catch (HTTPException e) {
            // empty catch block
        }
    }

    @Test
    public void testInvokeWithDataSourcPayloadModeXMLBinding() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        DispatchHandlerInvocationTest.assertNotNull((Object)wsdl);
        XMLService service = new XMLService();
        DispatchHandlerInvocationTest.assertNotNull((Object)service);
        Dispatch disp = service.createDispatch(this.portNameXML, DataSource.class, Service.Mode.PAYLOAD);
        TestHandlerXMLBinding handler = new TestHandlerXMLBinding();
        TestSOAPHandler soapHandler = new TestSOAPHandler();
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{handler, soapHandler});
        URL is = ((Object)((Object)this)).getClass().getResource("/messages/XML_GreetMeDocLiteralReq.xml");
        URLDataSource ds = new URLDataSource(is);
        try {
            disp.invoke((Object)ds);
            DispatchHandlerInvocationTest.fail((String)"Did not get expected exception");
        }
        catch (HTTPException e) {
            DispatchHandlerInvocationTest.assertEquals((Object)e.getCause().getMessage(), (Object)"DataSource is not valid in PAYLOAD mode with XML/HTTP binding.");
        }
    }

    @Test
    public void testInvokeWithJAXBMessageModeXMLBinding() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        DispatchHandlerInvocationTest.assertNotNull((Object)wsdl);
        XMLService service = new XMLService();
        DispatchHandlerInvocationTest.assertNotNull((Object)service);
        JAXBContext jc = JAXBContext.newInstance((String)"org.apache.hello_world_xml_http.wrapped.types");
        Dispatch disp = service.createDispatch(this.portNameXML, jc, Service.Mode.MESSAGE);
        TestHandlerXMLBinding handler = new TestHandlerXMLBinding();
        TestSOAPHandler soapHandler = new TestSOAPHandler();
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{handler, soapHandler});
        GreetMe req = new GreetMe();
        req.setRequestType("tli");
        Object response = disp.invoke((Object)req);
        DispatchHandlerInvocationTest.assertNotNull((Object)response);
        GreetMeResponse value = (GreetMeResponse)response;
        DispatchHandlerInvocationTest.assertEquals((Object)"Hello tli", (Object)value.getResponseType());
    }

    @Test
    public void testInvokeWithJAXBPayloadModeXMLBinding() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        DispatchHandlerInvocationTest.assertNotNull((Object)wsdl);
        XMLService service = new XMLService();
        DispatchHandlerInvocationTest.assertNotNull((Object)service);
        JAXBContext jc = JAXBContext.newInstance((String)"org.apache.hello_world_xml_http.wrapped.types");
        Dispatch disp = service.createDispatch(this.portNameXML, jc, Service.Mode.PAYLOAD);
        TestHandlerXMLBinding handler = new TestHandlerXMLBinding();
        TestSOAPHandler soapHandler = new TestSOAPHandler();
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{handler, soapHandler});
        GreetMe req = new GreetMe();
        req.setRequestType("tli");
        Object response = disp.invoke((Object)req);
        DispatchHandlerInvocationTest.assertNotNull((Object)response);
        GreetMeResponse value = (GreetMeResponse)response;
        DispatchHandlerInvocationTest.assertEquals((Object)"Hello tli", (Object)value.getResponseType());
    }

    public void addHandlersProgrammatically(BindingProvider bp, Handler ... handlers) {
        List handlerChain = bp.getBinding().getHandlerChain();
        DispatchHandlerInvocationTest.assertNotNull((Object)handlerChain);
        for (Handler h : handlers) {
            handlerChain.add(h);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestSOAPHandler
    implements SOAPHandler<SOAPMessageContext> {
        TestSOAPHandler() {
        }

        public boolean handleMessage(SOAPMessageContext ctx) {
            try {
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                if (outbound.booleanValue()) {
                    SOAPMessage msg = ctx.getMessage();
                    SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
                    SOAPBody body = env.getBody();
                    Iterator it = body.getChildElements();
                    while (it.hasNext()) {
                        Object elem = it.next();
                        if (!(elem instanceof SOAPElement)) continue;
                        Iterator it2 = ((SOAPElement)elem).getChildElements();
                        while (it2.hasNext()) {
                            Object elem2 = it2.next();
                            if (!(elem2 instanceof SOAPElement)) continue;
                            String value = ((SOAPElement)elem2).getValue();
                            String name = ((SOAPElement)elem2).getLocalName();
                            if (name.indexOf("arg0") >= 0 && value.equalsIgnoreCase("11")) {
                                value = "12";
                                ((SOAPElement)elem2).setValue(value);
                            }
                            if (name.indexOf("arg1") < 0 || !value.equalsIgnoreCase("21")) continue;
                            value = "22";
                            ((SOAPElement)elem2).setValue(value);
                        }
                    }
                    msg.saveChanges();
                } else {
                    SOAPMessage msg = ctx.getMessage();
                    SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
                    SOAPBody body = env.getBody();
                    Iterator it = body.getChildElements();
                    while (it.hasNext()) {
                        Object elem = it.next();
                        if (!(elem instanceof SOAPElement)) continue;
                        Iterator it2 = ((SOAPElement)elem).getChildElements();
                        while (it2.hasNext()) {
                            Object elem2 = it2.next();
                            if (!(elem2 instanceof SOAPElement)) continue;
                            String value = ((SOAPElement)elem2).getValue();
                            String name = ((SOAPElement)elem2).getLocalName();
                            if (name.indexOf("return") < 0 || !value.equalsIgnoreCase("264")) continue;
                            value = "333";
                            ((SOAPElement)elem2).setValue(value);
                        }
                    }
                    msg.saveChanges();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.toString());
            }
            return true;
        }

        public final Set<QName> getHeaders() {
            return null;
        }

        public boolean handleFault(SOAPMessageContext ctx) {
            return true;
        }

        public void close(MessageContext arg0) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestHandlerXMLBinding
    implements LogicalHandler<LogicalMessageContext> {
        TestHandlerXMLBinding() {
        }

        public boolean handleMessage(LogicalMessageContext ctx) {
            LogicalMessage msg = ctx.getMessage();
            Source payload = msg.getPayload();
            Assert.assertNotNull((Object)payload);
            return true;
        }

        public boolean handleFault(LogicalMessageContext ctx) {
            return true;
        }

        public void close(MessageContext arg0) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestHandler
    implements LogicalHandler<LogicalMessageContext> {
        TestHandler() {
        }

        public boolean handleMessage(LogicalMessageContext ctx) {
            try {
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                if (outbound.booleanValue()) {
                    LogicalMessage msg = ctx.getMessage();
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class, org.apache.hello_world_xml_http.wrapped.types.ObjectFactory.class});
                    Object payload = ((JAXBElement)msg.getPayload(jaxbContext)).getValue();
                    AddNumbers req = (AddNumbers)payload;
                    Assert.assertEquals((Object)10, (Object)req.getArg0());
                    Assert.assertEquals((Object)20, (Object)req.getArg1());
                    req.setArg0(11);
                    req.setArg1(21);
                    ObjectFactory of = new ObjectFactory();
                    of.createAddNumbers(req);
                    msg.setPayload((Object)of.createAddNumbers(req), jaxbContext);
                } else {
                    LogicalMessage msg = ctx.getMessage();
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
                    Object payload = ((JAXBElement)msg.getPayload(jaxbContext)).getValue();
                    AddNumbersResponse res = (AddNumbersResponse)payload;
                    Assert.assertEquals((Object)333, (Object)res.getReturn());
                    res.setReturn(222);
                    ObjectFactory of = new ObjectFactory();
                    msg.setPayload((Object)of.createAddNumbersResponse(res), jaxbContext);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.toString());
            }
            return true;
        }

        public boolean handleFault(LogicalMessageContext ctx) {
            return true;
        }

        public void close(MessageContext arg0) {
        }
    }
}

