/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.handlers;

import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.BusException;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.systest.handlers.HandlerTestServiceWithAnnotation;
import org.apache.cxf.systest.handlers.Server;
import org.apache.cxf.systest.handlers.TestHandler;
import org.apache.cxf.systest.handlers.TestSOAPHandler;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.handler_test.HandlerTest;
import org.apache.handler_test.HandlerTestService;
import org.apache.handler_test.PingException;
import org.apache.handler_test.types.PingOneWay;
import org.apache.handler_test.types.PingResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerInvocationTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/handler_test", "HandlerTestService");
    private final QName portName = new QName("http://apache.org/handler_test", "SoapPort");
    private URL wsdl;
    private HandlerTestService service;
    private HandlerTest handlerTest;

    @BeforeClass
    public static void startServers() throws Exception {
        HandlerInvocationTest.assertTrue((String)"server did not launch correctly", (boolean)HandlerInvocationTest.launchServer(Server.class, (boolean)true));
    }

    @Before
    public void setUp() throws BusException {
        try {
            super.createBus();
            this.wsdl = HandlerInvocationTest.class.getResource("/wsdl/handler_test.wsdl");
            this.service = new HandlerTestService(this.wsdl, this.serviceName);
            this.handlerTest = (HandlerTest)this.service.getPort(this.portName, HandlerTest.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HandlerInvocationTest.fail((String)ex.toString());
        }
    }

    @Test
    public void testAddHandlerThroughHandlerResolverClientSide() {
        TestHandler handler1 = new TestHandler(false);
        TestHandler handler2 = new TestHandler(false);
        MyHandlerResolver myHandlerResolver = new MyHandlerResolver(new Handler[]{handler1, handler2});
        this.service.setHandlerResolver((HandlerResolver)myHandlerResolver);
        HandlerTest handlerTestNew = (HandlerTest)this.service.getPort(this.portName, HandlerTest.class);
        handlerTestNew.pingOneWay();
        String bindingID = myHandlerResolver.bindingID;
        HandlerInvocationTest.assertEquals((Object)"http://schemas.xmlsoap.org/wsdl/soap/http", (Object)bindingID);
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getHandleMessageInvoked());
    }

    @Test
    public void testAddingUnusedHandlersThroughConfigFile() {
        HandlerTestServiceWithAnnotation service1 = new HandlerTestServiceWithAnnotation(this.wsdl, this.serviceName);
        HandlerTest handlerTest1 = (HandlerTest)service1.getPort(this.portName, HandlerTest.class);
        BindingProvider bp1 = (BindingProvider)handlerTest1;
        Binding binding1 = bp1.getBinding();
        List port1HandlerChain = binding1.getHandlerChain();
        HandlerInvocationTest.assertEquals((Object)1, (Object)port1HandlerChain.size());
    }

    @Test
    public void testLogicalHandlerOneWay() {
        TestHandler handler1 = new TestHandler(false);
        TestHandler handler2 = new TestHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2});
        this.handlerTest.pingOneWay();
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getHandleMessageInvoked());
    }

    @Test
    public void testLogicalHandlerTwoWay() throws Exception {
        TestHandler handler1 = new TestHandler(false);
        TestHandler handler2 = new TestHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2});
        this.handlerTest.pingWithArgs("hello");
        HandlerInvocationTest.assertEquals((Object)2, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)handler2.getHandleMessageInvoked());
    }

    @Test
    public void testSOAPHandlerHandleMessageReturnTrueClient() throws Exception {
        TestHandler handler1 = new TestHandler(false);
        TestHandler<LogicalMessageContext> handler2 = new TestHandler<LogicalMessageContext>(false){

            @Override
            public boolean handleMessage(LogicalMessageContext ctx) {
                super.handleMessage(ctx);
                try {
                    Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                    if (!outbound.booleanValue()) {
                        LogicalMessage msg = ctx.getMessage();
                        Source source = msg.getPayload();
                        Assert.assertNotNull((Object)source);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.toString());
                }
                return true;
            }
        };
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        TestSOAPHandler soapHandler2 = new TestSOAPHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1, soapHandler2});
        List resp = this.handlerTest.ping();
        HandlerInvocationTest.assertNotNull((Object)resp);
        HandlerInvocationTest.assertEquals((String)"handle message was not invoked", (Object)2, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"handle message was not invoked", (Object)2, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"handle message was not invoked", (Object)2, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"handle message was not invoked", (Object)2, (Object)soapHandler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)soapHandler2.getCloseInvoked());
        HandlerInvocationTest.assertTrue((soapHandler2.getInvokeOrderOfClose() < soapHandler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
        HandlerInvocationTest.assertTrue((soapHandler1.getInvokeOrderOfClose() < handler2.getInvokeOrderOfClose() ? 1 : 0) != 0);
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
        String[] handlerNames = new String[]{"soapHandler4", "soapHandler3", "handler2", "handler1", "servant", "handler1", "handler2", "soapHandler3", "soapHandler4"};
        HandlerInvocationTest.assertEquals((Object)handlerNames.length, (Object)resp.size());
        Iterator iter = resp.iterator();
        for (String expected : handlerNames) {
            HandlerInvocationTest.assertEquals((Object)expected, iter.next());
        }
    }

    @Test
    public void testLogicalHandlerHandleMessageReturnFalseClientOutBound() throws Exception {
        String clientHandlerMessage = "handler2 client side";
        TestHandler handler1 = new TestHandler(false);
        TestHandler<LogicalMessageContext> handler2 = new TestHandler<LogicalMessageContext>(false){

            @Override
            public boolean handleMessage(LogicalMessageContext ctx) {
                super.handleMessage(ctx);
                try {
                    Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                    if (outbound.booleanValue()) {
                        LogicalMessage msg = ctx.getMessage();
                        Assert.assertNotNull((String)"logical message is null", (Object)msg);
                        JAXBContext jaxbCtx = JAXBContext.newInstance((String)PackageUtils.getPackageName(PingOneWay.class));
                        PingResponse resp = new PingResponse();
                        resp.getHandlersInfo().add("handler2 client side");
                        msg.setPayload((Object)resp, jaxbCtx);
                        return false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.toString());
                }
                return true;
            }
        };
        TestHandler handler3 = new TestHandler(false);
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, handler3, soapHandler1});
        List resp = this.handlerTest.ping();
        HandlerInvocationTest.assertEquals((Object)"handler2 client side", resp.get(0));
        HandlerInvocationTest.assertEquals((String)"the first handler must be invoked twice", (Object)2, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"the second handler must be invoked once only on outbound", (Object)1, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"the third handler must not be invoked", (Object)0, (Object)handler3.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"the last handler must not be invoked", (Object)0, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)0, (Object)handler3.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)0, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testLogicalHandlerHandleMessageReturnFalseClientInBound() throws Exception {
        TestHandler handler1 = new TestHandler(false);
        TestHandler<LogicalMessageContext> handler2 = new TestHandler<LogicalMessageContext>(false){

            @Override
            public boolean handleMessage(LogicalMessageContext ctx) {
                super.handleMessage(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                return outbound != false;
            }
        };
        TestHandler handler3 = new TestHandler(false);
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, handler3, soapHandler1});
        this.handlerTest.ping();
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)handler3.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler3.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertTrue((soapHandler1.getInvokeOrderOfClose() < handler3.getInvokeOrderOfClose() ? 1 : 0) != 0);
        HandlerInvocationTest.assertTrue((handler3.getInvokeOrderOfClose() < handler2.getInvokeOrderOfClose() ? 1 : 0) != 0);
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testSOAPHandlerHandleMessageReturnFalseClientOutbound() throws Exception {
        String clientHandlerMessage = "client side";
        TestHandler handler1 = new TestHandler(false);
        TestHandler<LogicalMessageContext> handler2 = new TestHandler<LogicalMessageContext>(false){

            @Override
            public boolean handleMessage(LogicalMessageContext ctx) {
                super.handleMessage(ctx);
                try {
                    Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                    if (outbound.booleanValue()) {
                        LogicalMessage msg = ctx.getMessage();
                        Assert.assertNotNull((String)"logical message is null", (Object)msg);
                        JAXBContext jaxbCtx = JAXBContext.newInstance((String)PackageUtils.getPackageName(PingOneWay.class));
                        PingResponse resp = new PingResponse();
                        resp.getHandlersInfo().add("client side");
                        msg.setPayload((Object)resp, jaxbCtx);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.toString());
                }
                return true;
            }
        };
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        TestSOAPHandler<SOAPMessageContext> soapHandler2 = new TestSOAPHandler<SOAPMessageContext>(false){

            @Override
            public boolean handleMessage(SOAPMessageContext ctx) {
                super.handleMessage(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                return outbound == false;
            }
        };
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1, soapHandler2});
        List resp = this.handlerTest.ping();
        HandlerInvocationTest.assertEquals((Object)"client side", resp.get(0));
        HandlerInvocationTest.assertEquals((Object)2, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)soapHandler2.getCloseInvoked());
        HandlerInvocationTest.assertTrue((soapHandler2.getInvokeOrderOfClose() < soapHandler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
        HandlerInvocationTest.assertTrue((soapHandler1.getInvokeOrderOfClose() < handler2.getInvokeOrderOfClose() ? 1 : 0) != 0);
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testSOAPHandlerHandleMessageReturnFalseClientInbound() throws Exception {
        TestHandler handler1 = new TestHandler(false);
        TestHandler handler2 = new TestHandler(false);
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        TestSOAPHandler<SOAPMessageContext> soapHandler2 = new TestSOAPHandler<SOAPMessageContext>(false){

            @Override
            public boolean handleMessage(SOAPMessageContext ctx) {
                super.handleMessage(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                return outbound != false;
            }
        };
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1, soapHandler2});
        this.handlerTest.ping();
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)soapHandler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)soapHandler2.getCloseInvoked());
        HandlerInvocationTest.assertTrue((soapHandler2.getInvokeOrderOfClose() < soapHandler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
        HandlerInvocationTest.assertTrue((soapHandler1.getInvokeOrderOfClose() < handler2.getInvokeOrderOfClose() ? 1 : 0) != 0);
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testLogicalHandlerHandleMessageReturnsFalseServerInbound() throws PingException {
        String[] expectedHandlers = new String[]{"soapHandler4", "soapHandler3", "handler2", "soapHandler3", "soapHandler4"};
        List resp = this.handlerTest.pingWithArgs("handler2 inbound stop");
        HandlerInvocationTest.assertEquals((Object)expectedHandlers.length, (Object)resp.size());
        int i = 0;
        for (String expected : expectedHandlers) {
            HandlerInvocationTest.assertEquals((Object)expected, resp.get(i++));
        }
    }

    @Test
    public void testSOAPHandlerHandleMessageReturnsFalseServerInbound() throws PingException {
        String[] expectedHandlers = new String[]{"soapHandler4", "soapHandler3", "soapHandler4"};
        List resp = this.handlerTest.pingWithArgs("soapHandler3 inbound stop");
        HandlerInvocationTest.assertEquals((Object)expectedHandlers.length, (Object)resp.size());
        int i = 0;
        for (String expected : expectedHandlers) {
            HandlerInvocationTest.assertEquals((Object)expected, resp.get(i++));
        }
    }

    @Test
    public void testSOAPHandlerHandleMessageReturnsFalseServerOutbound() throws PingException {
        String[] expectedHandlers = new String[]{"soapHandler3 outbound stop", "soapHandler4", "soapHandler3", "handler2", "handler1", "handler1", "handler2", "soapHandler3"};
        List resp = this.handlerTest.pingWithArgs("soapHandler3 outbound stop");
        HandlerInvocationTest.assertEquals((Object)expectedHandlers.length, (Object)resp.size());
        int i = 0;
        for (String expected : expectedHandlers) {
            HandlerInvocationTest.assertEquals((Object)expected, resp.get(i++));
        }
    }

    @Test
    public void testLogicalHandlerHandleMessageThrowsProtocolExceptionClientOutbound() throws Exception {
        String clientHandlerMessage = "handler1 client side";
        TestHandler handler1 = new TestHandler(false);
        TestHandler<LogicalMessageContext> handler2 = new TestHandler<LogicalMessageContext>(false){

            @Override
            public boolean handleMessage(LogicalMessageContext ctx) {
                super.handleMessage(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                if (outbound.booleanValue()) {
                    throw new ProtocolException("handler1 client side");
                }
                return true;
            }
        };
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1});
        try {
            this.handlerTest.ping();
            HandlerInvocationTest.fail((String)"did not get expected exception");
        }
        catch (ProtocolException e) {
            HandlerInvocationTest.assertEquals((Object)"handler1 client side", (Object)e.getMessage());
        }
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)handler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testLogicalHandlerHandleMessageThrowsProtocolExceptionClientInbound() throws Exception {
        String clientHandlerMessage = "handler1 client side";
        TestHandler handler1 = new TestHandler(false);
        TestHandler<LogicalMessageContext> handler2 = new TestHandler<LogicalMessageContext>(false){

            @Override
            public boolean handleMessage(LogicalMessageContext ctx) {
                super.handleMessage(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                if (!outbound.booleanValue()) {
                    throw new ProtocolException("handler1 client side");
                }
                return true;
            }
        };
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1});
        try {
            this.handlerTest.ping();
        }
        catch (ProtocolException e) {
            HandlerInvocationTest.assertEquals((Object)"handler1 client side", (Object)e.getMessage());
        }
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)handler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)handler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testLogicalHandlerHandleMessageThrowsRuntimeExceptionClientOutbound() throws Exception {
        String clientHandlerMessage = "handler1 client side";
        TestHandler handler1 = new TestHandler(false);
        TestHandler<LogicalMessageContext> handler2 = new TestHandler<LogicalMessageContext>(false){

            @Override
            public boolean handleMessage(LogicalMessageContext ctx) {
                super.handleMessage(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                if (outbound.booleanValue()) {
                    throw new RuntimeException("handler1 client side");
                }
                return true;
            }
        };
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1});
        try {
            this.handlerTest.ping();
            HandlerInvocationTest.fail((String)"did not get expected exception");
        }
        catch (RuntimeException e) {
            HandlerInvocationTest.assertTrue((boolean)e.getMessage().contains("handler1 client side"));
        }
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)handler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)handler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testLogicalHandlerHandleMessageThrowsRuntimeExceptionClientInbound() throws Exception {
        String clientHandlerMessage = "handler1 client side";
        TestHandler handler1 = new TestHandler(false);
        TestHandler<LogicalMessageContext> handler2 = new TestHandler<LogicalMessageContext>(false){

            @Override
            public boolean handleMessage(LogicalMessageContext ctx) {
                super.handleMessage(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                if (!outbound.booleanValue()) {
                    throw new RuntimeException("handler1 client side");
                }
                return true;
            }
        };
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1});
        try {
            this.handlerTest.ping();
            HandlerInvocationTest.fail((String)"did not get expected exception");
        }
        catch (RuntimeException e) {
            HandlerInvocationTest.assertTrue((boolean)e.getMessage().contains("handler1 client side"));
        }
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)handler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)handler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testSOAPHandlerHandleMessageThrowsProtocolExceptionClientOutbound() throws Exception {
        String clientHandlerMessage = "handler1 client side";
        TestHandler handler1 = new TestHandler(false);
        TestHandler handler2 = new TestHandler(false);
        TestSOAPHandler<SOAPMessageContext> soapHandler1 = new TestSOAPHandler<SOAPMessageContext>(false){

            @Override
            public boolean handleMessage(SOAPMessageContext ctx) {
                super.handleMessage(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                if (outbound.booleanValue()) {
                    throw new ProtocolException("handler1 client side");
                }
                return true;
            }
        };
        TestSOAPHandler soapHandler2 = new TestSOAPHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1, soapHandler2});
        try {
            this.handlerTest.ping();
            HandlerInvocationTest.fail((String)"did not get expected exception");
        }
        catch (ProtocolException e) {
            HandlerInvocationTest.assertEquals((Object)"handler1 client side", (Object)e.getMessage());
        }
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler2.getCloseInvoked());
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testSOAPHandlerHandleMessageThrowsProtocolExceptionClientInbound() throws Exception {
        String clientHandlerMessage = "handler1 client side";
        TestHandler handler1 = new TestHandler(false);
        TestHandler handler2 = new TestHandler(false);
        TestSOAPHandler<SOAPMessageContext> soapHandler1 = new TestSOAPHandler<SOAPMessageContext>(false){

            @Override
            public boolean handleMessage(SOAPMessageContext ctx) {
                super.handleMessage(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                if (!outbound.booleanValue()) {
                    throw new ProtocolException("handler1 client side");
                }
                return true;
            }
        };
        TestSOAPHandler soapHandler2 = new TestSOAPHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1, soapHandler2});
        try {
            this.handlerTest.ping();
        }
        catch (ProtocolException e) {
            HandlerInvocationTest.assertEquals((Object)"handler1 client side", (Object)e.getMessage());
        }
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)2, (Object)soapHandler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)handler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)handler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler2.getCloseInvoked());
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testSOAPHandlerHandleMessageThrowsRuntimeExceptionClientOutbound() throws Exception {
        String clientHandlerMessage = "handler1 client side";
        TestHandler handler1 = new TestHandler(false);
        TestHandler handler2 = new TestHandler(false);
        TestSOAPHandler<SOAPMessageContext> soapHandler1 = new TestSOAPHandler<SOAPMessageContext>(false){

            @Override
            public boolean handleMessage(SOAPMessageContext ctx) {
                super.handleMessage(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                if (outbound.booleanValue()) {
                    throw new RuntimeException("handler1 client side");
                }
                return true;
            }
        };
        TestSOAPHandler soapHandler2 = new TestSOAPHandler(false);
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1, soapHandler2});
        try {
            this.handlerTest.ping();
            HandlerInvocationTest.fail((String)"did not get expected exception");
        }
        catch (RuntimeException e) {
            HandlerInvocationTest.assertTrue((boolean)e.getMessage().contains("handler1 client side"));
        }
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)handler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)handler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)0, (Object)soapHandler2.getCloseInvoked());
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testSOAPHandlerHandleMessageThrowsRuntimeExceptionServerInbound() throws PingException {
        try {
            this.handlerTest.pingWithArgs("soapHandler3 inbound throw RuntimeException");
            HandlerInvocationTest.fail((String)"did not get expected exception");
        }
        catch (SOAPFaultException e) {
            HandlerInvocationTest.assertEquals((Object)"HandleMessage throws exception", (Object)e.getMessage());
        }
    }

    @Test
    public void testSOAPHandlerHandleMessageThrowsRuntimeExceptionServerOutbound() throws PingException {
        try {
            this.handlerTest.pingWithArgs("soapHandler3 outbound throw RuntimeException");
            HandlerInvocationTest.fail((String)"did not get expected exception");
        }
        catch (SOAPFaultException e) {
            HandlerInvocationTest.assertEquals((Object)"HandleMessage throws exception", (Object)e.getMessage());
        }
    }

    @Test
    public void testSOAPHandlerHandleMessageThrowsProtocolExceptionServerInbound() throws PingException {
        try {
            this.handlerTest.pingWithArgs("soapHandler3 inbound throw ProtocolException");
            HandlerInvocationTest.fail((String)"did not get expected WebServiceException");
        }
        catch (WebServiceException e) {
            HandlerInvocationTest.assertEquals((Object)"HandleMessage throws exception", (Object)e.getMessage());
        }
    }

    @Test
    public void testSOAPHandlerHandleMessageThrowsSOAPFaultExceptionServerInbound() throws PingException {
        try {
            this.handlerTest.pingWithArgs("soapHandler3 inbound throw SOAPFaultExceptionWDetail");
            HandlerInvocationTest.fail((String)"did not get expected SOAPFaultException");
        }
        catch (SOAPFaultException e) {
            HandlerInvocationTest.assertEquals((Object)"HandleMessage throws exception", (Object)e.getMessage());
            SOAPFault fault = e.getFault();
            HandlerInvocationTest.assertNotNull((Object)fault);
            HandlerInvocationTest.assertEquals((Object)new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"), (Object)fault.getFaultCodeAsQName());
            HandlerInvocationTest.assertEquals((Object)"http://gizmos.com/orders", (Object)fault.getFaultActor());
            Detail detail = fault.getDetail();
            HandlerInvocationTest.assertNotNull((Object)detail);
            QName nn = new QName("http://gizmos.com/orders/", "order");
            Iterator it = CastUtils.cast((Iterator)detail.getChildElements(nn));
            HandlerInvocationTest.assertTrue((boolean)it.hasNext());
            Element el = (Element)it.next();
            el.normalize();
            HandlerInvocationTest.assertEquals((Object)"Quantity element does not have a value", (Object)el.getFirstChild().getNodeValue());
            el = (Element)it.next();
            el.normalize();
            HandlerInvocationTest.assertEquals((Object)"Incomplete address: no zip code", (Object)el.getFirstChild().getNodeValue());
        }
    }

    @Test
    public void testSOAPHandlerHandleFaultThrowsRuntimeExceptionServerOutbound() throws PingException {
        try {
            this.handlerTest.pingWithArgs("soapHandler3 inbound throw ProtocolException soapHandler4HandleFaultThrowsRunException");
            HandlerInvocationTest.fail((String)"did not get expected WebServiceException");
        }
        catch (WebServiceException e) {
            HandlerInvocationTest.assertEquals((Object)"soapHandler4 HandleFault throws RuntimeException", (Object)e.getMessage());
        }
    }

    @Test
    public void testSOAPHandlerHandleFaultThrowsSOAPFaultExceptionServerOutbound() throws PingException {
        try {
            this.handlerTest.pingWithArgs("soapHandler3 inbound throw ProtocolException soapHandler4HandleFaultThrowsSOAPFaultException");
            HandlerInvocationTest.fail((String)"did not get expected SOAPFaultException");
        }
        catch (SOAPFaultException e) {
            HandlerInvocationTest.assertEquals((Object)"soapHandler4 HandleFault throws SOAPFaultException", (Object)e.getMessage());
        }
    }

    @Test
    public void testSOAPHandlerHandleMessageThrowsProtocolExceptionServerOutbound() throws PingException {
        try {
            this.handlerTest.pingWithArgs("soapHandler3 outbound throw ProtocolException");
            HandlerInvocationTest.fail((String)"did not get expected WebServiceException");
        }
        catch (WebServiceException e) {
            HandlerInvocationTest.assertEquals((Object)"HandleMessage throws exception", (Object)e.getMessage());
        }
    }

    @Test
    public void testServerSOAPInboundHandlerThrowsSOAPFaultToClientHandlers() throws Exception {
        TestHandler handler1 = new TestHandler(false);
        TestHandler<LogicalMessageContext> handler2 = new TestHandler<LogicalMessageContext>(false){

            @Override
            public boolean handleFault(LogicalMessageContext ctx) {
                super.handleFault(ctx);
                try {
                    Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                    if (!outbound.booleanValue()) {
                        LogicalMessage msg = ctx.getMessage();
                        Source source = msg.getPayload();
                        Assert.assertNotNull((Object)source);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.toString());
                }
                return true;
            }
        };
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        TestSOAPHandler soapHandler2 = new TestSOAPHandler(false){

            public boolean handleFault(SOAPMessageContext ctx) {
                super.handleFault(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                if (!outbound.booleanValue()) {
                    try {
                        SOAPMessage msg = ctx.getMessage();
                        Assert.assertNotNull((Object)msg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.toString());
                    }
                }
                return true;
            }
        };
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1, soapHandler2});
        try {
            this.handlerTest.pingWithArgs("soapHandler3 inbound throw SOAPFaultException");
            HandlerInvocationTest.fail((String)"did not get expected SOAPFaultException");
        }
        catch (SOAPFaultException e) {
            // empty catch block
        }
    }

    @Test
    public void testServerEndpointRemoteRuntimeException() throws PingException {
        try {
            this.handlerTest.pingWithArgs("servant throw WebServiceException");
            HandlerInvocationTest.fail((String)"did not get expected WebServiceException");
        }
        catch (WebServiceException webServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testServerEndpointRemoteFault() throws PingException {
        TestHandler handler1 = new TestHandler(false);
        TestHandler<LogicalMessageContext> handler2 = new TestHandler<LogicalMessageContext>(false){

            @Override
            public boolean handleFault(LogicalMessageContext ctx) {
                super.handleFault(ctx);
                try {
                    Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                    if (!outbound.booleanValue()) {
                        LogicalMessage msg = ctx.getMessage();
                        String payload = this.convertDOMToString(msg.getPayload());
                        Assert.assertTrue((payload.indexOf("<faultstring>servant throws SOAPFaultException</faultstring>") > -1 ? 1 : 0) != 0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.toString());
                }
                return true;
            }

            private String convertDOMToString(Source s) throws TransformerException {
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "no");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.setOutputProperty("method", "xml");
                transformer.transform(s, streamResult);
                return stringWriter.toString();
            }
        };
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        TestSOAPHandler soapHandler2 = new TestSOAPHandler(false){

            public boolean handleFault(SOAPMessageContext ctx) {
                super.handleFault(ctx);
                try {
                    Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                    if (!outbound.booleanValue()) {
                        SOAPEnvelope env = ctx.getMessage().getSOAPPart().getEnvelope();
                        Assert.assertTrue((String)"expected SOAPFault in SAAJ model", (boolean)env.getBody().hasFault());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.toString());
                }
                return true;
            }
        };
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler1, handler2, soapHandler1, soapHandler2});
        try {
            this.handlerTest.pingWithArgs("servant throw SOAPFaultException");
            HandlerInvocationTest.fail((String)"did not get expected Exception");
        }
        catch (SOAPFaultException sfe) {
            // empty catch block
        }
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler1.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler2.getHandleFaultInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((Object)1, (Object)soapHandler2.getCloseInvoked());
        HandlerInvocationTest.assertTrue((handler2.getInvokeOrderOfClose() < handler1.getInvokeOrderOfClose() ? 1 : 0) != 0);
    }

    @Test
    public void testLogicalHandlerHandleFaultThrowsRuntimeExceptionServerOutbound() throws PingException {
        try {
            this.handlerTest.pingWithArgs("handler1 inbound throw ProtocolException handler2HandleFaultThrowsRunException");
            HandlerInvocationTest.fail((String)"did not get expected WebServiceException");
        }
        catch (WebServiceException webServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testLogicalHandlerHandleFaultThrowsSOAPFaultExceptionServerOutbound() throws PingException {
        try {
            this.handlerTest.pingWithArgs("handler1 inbound throw ProtocolException handler2HandleFaultThrowsSOAPFaultException");
            HandlerInvocationTest.fail((String)"did not get expected SOAPFaultException");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
    }

    @Test
    public void testLogicalHandlerHandleMessageThrowsProtocolExceptionServerInbound() throws PingException {
        try {
            this.handlerTest.pingWithArgs("handler2 inbound throw ProtocolException");
            HandlerInvocationTest.fail((String)"did not get expected exception");
        }
        catch (WebServiceException e) {
            HandlerInvocationTest.assertTrue((e.getMessage().indexOf("HandleMessage throws exception") >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDescription() throws PingException {
        TestHandler<LogicalMessageContext> handler = new TestHandler<LogicalMessageContext>(false){

            @Override
            public boolean handleMessage(LogicalMessageContext ctx) {
                super.handleMessage(ctx);
                Assert.assertTrue((String)"wsdl description not found or invalid", (boolean)HandlerInvocationTest.this.isValidWsdlDescription(ctx.get((Object)"javax.xml.ws.wsdl.description")));
                return true;
            }
        };
        TestSOAPHandler<SOAPMessageContext> soapHandler = new TestSOAPHandler<SOAPMessageContext>(false){

            @Override
            public boolean handleMessage(SOAPMessageContext ctx) {
                super.handleMessage(ctx);
                Assert.assertTrue((String)"wsdl description not found or invalid", (boolean)HandlerInvocationTest.this.isValidWsdlDescription(ctx.get((Object)"javax.xml.ws.wsdl.description")));
                return true;
            }
        };
        this.addHandlersToChain((BindingProvider)this.handlerTest, new Handler[]{handler, soapHandler});
        List resp = this.handlerTest.ping();
        HandlerInvocationTest.assertNotNull((Object)resp);
        HandlerInvocationTest.assertEquals((String)"handler was not invoked", (Object)2, (Object)handler.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"handle message was not invoked", (Object)2, (Object)soapHandler.getHandleMessageInvoked());
        HandlerInvocationTest.assertTrue((String)"close must be  called", (boolean)handler.isCloseInvoked());
        HandlerInvocationTest.assertTrue((String)"close must be  called", (boolean)soapHandler.isCloseInvoked());
    }

    @Test
    public void testHandlersInvokedForDispatch() throws Exception {
        Dispatch disp = this.service.createDispatch(this.portName, SOAPMessage.class, Service.Mode.MESSAGE);
        TestHandler handler1 = new TestHandler(false);
        TestHandler handler2 = new TestHandler(false);
        TestSOAPHandler soapHandler1 = new TestSOAPHandler(false);
        TestSOAPHandler soapHandler2 = new TestSOAPHandler(false);
        this.addHandlersToChain((BindingProvider)disp, new Handler[]{handler1, handler2, soapHandler1, soapHandler2});
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("PingReq.xml");
        SOAPMessage outMsg = MessageFactory.newInstance().createMessage(null, is);
        SOAPMessage inMsg = (SOAPMessage)disp.invoke((Object)outMsg);
        HandlerInvocationTest.assertNotNull((Object)inMsg);
        HandlerInvocationTest.assertEquals((String)"handle message was not invoked", (Object)2, (Object)handler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"handle message was not invoked", (Object)2, (Object)handler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"handle message was not invoked", (Object)2, (Object)soapHandler1.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"handle message was not invoked", (Object)2, (Object)soapHandler2.getHandleMessageInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)handler2.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)soapHandler1.getCloseInvoked());
        HandlerInvocationTest.assertEquals((String)"close must be called", (Object)1, (Object)soapHandler2.getCloseInvoked());
        String[] handlerNames = new String[]{"soapHandler4", "soapHandler3", "handler2", "handler1", "servant", "handler1", "handler2", "soapHandler3", "soapHandler4"};
        List<String> resp = this.getHandlerNames(inMsg.getSOAPBody());
        HandlerInvocationTest.assertEquals((Object)handlerNames.length, (Object)resp.size());
        Iterator<String> iter = resp.iterator();
        for (String expected : handlerNames) {
            HandlerInvocationTest.assertEquals((Object)expected, (Object)iter.next());
        }
    }

    void addHandlersToChain(BindingProvider bp, Handler ... handlers) {
        List handlerChain = bp.getBinding().getHandlerChain();
        HandlerInvocationTest.assertNotNull((Object)handlerChain);
        for (Handler h : handlers) {
            handlerChain.add(h);
        }
    }

    List<String> getHandlerNames(SOAPBody soapBody) throws Exception {
        Element elNode = DOMUtils.getFirstElement((Node)soapBody);
        List stringList = null;
        JAXBContext jaxbCtx = JAXBContext.newInstance((Class[])new Class[]{PingResponse.class});
        Unmarshaller um = jaxbCtx.createUnmarshaller();
        Object obj = um.unmarshal((Node)elNode);
        if (obj instanceof PingResponse) {
            PingResponse pr = (PingResponse)PingResponse.class.cast(obj);
            stringList = pr.getHandlersInfo();
        }
        return stringList;
    }

    private boolean isValidWsdlDescription(Object wsdlDescription) {
        return wsdlDescription != null && (wsdlDescription instanceof URI || wsdlDescription instanceof URL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyHandlerResolver
    implements HandlerResolver {
        List<Handler> chain = new ArrayList<Handler>();
        String bindingID;

        public MyHandlerResolver(Handler ... handlers) {
            for (Handler h : handlers) {
                this.chain.add(h);
            }
        }

        public List<Handler> getHandlerChain(PortInfo portInfo) {
            this.bindingID = portInfo.getBindingID();
            return this.chain;
        }
    }
}

