/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.handlers;

import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.systest.handlers.AddNumbersServiceWithAnnotation;
import org.apache.cxf.systest.handlers.HandlerServer;
import org.apache.cxf.systest.handlers.SmallNumberHandler;
import org.apache.cxf.systest.handlers.TestResourceResolver;
import org.apache.cxf.systest.handlers.TestSOAPHandler;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.handlers.AddNumbers;
import org.apache.handlers.AddNumbersService;
import org.apache.handlers.types.AddNumbersResponse;
import org.apache.handlers.types.ObjectFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HandlerInvocationUsingAddNumbersTest
extends AbstractBusClientServerTestBase {
    static QName serviceName = new QName("http://apache.org/handlers", "AddNumbersService");
    static QName portName = new QName("http://apache.org/handlers", "AddNumbersPort");

    @BeforeClass
    public static void startServers() throws Exception {
        HandlerInvocationUsingAddNumbersTest.assertTrue((String)"server did not launch correctly", (boolean)HandlerInvocationUsingAddNumbersTest.launchServer(HandlerServer.class));
    }

    @Test
    public void testAddHandlerProgrammaticallyClientSide() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        AddNumbersService service = new AddNumbersService(wsdl, serviceName);
        AddNumbers port = (AddNumbers)service.getPort(portName, AddNumbers.class);
        SmallNumberHandler sh = new SmallNumberHandler();
        this.addHandlersProgrammatically((BindingProvider)port, new Handler[]{sh});
        int result = port.addNumbers(10, 20);
        HandlerInvocationUsingAddNumbersTest.assertEquals((Object)200, (Object)result);
        int result1 = port.addNumbers(5, 6);
        HandlerInvocationUsingAddNumbersTest.assertEquals((Object)11, (Object)result1);
    }

    @Test
    public void testAddHandlerByAnnotationClientSide() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        AddNumbersServiceWithAnnotation service = new AddNumbersServiceWithAnnotation(wsdl, serviceName);
        AddNumbers port = (AddNumbers)service.getPort(portName, AddNumbers.class);
        int result = port.addNumbers(10, 20);
        HandlerInvocationUsingAddNumbersTest.assertEquals((Object)200, (Object)result);
        int result1 = port.addNumbers(5, 6);
        HandlerInvocationUsingAddNumbersTest.assertEquals((Object)11, (Object)result1);
    }

    @Test
    public void testInvokeFromDispatchWithJAXBPayload() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        HandlerInvocationUsingAddNumbersTest.assertNotNull((Object)wsdl);
        AddNumbersService service = new AddNumbersService(wsdl, serviceName);
        HandlerInvocationUsingAddNumbersTest.assertNotNull((Object)service);
        JAXBContext jc = JAXBContext.newInstance((String)"org.apache.handlers.types");
        Dispatch disp = service.createDispatch(portName, jc, Service.Mode.PAYLOAD);
        SmallNumberHandler sh = new SmallNumberHandler();
        TestSOAPHandler<SOAPMessageContext> soapHandler = new TestSOAPHandler<SOAPMessageContext>(false){

            @Override
            public boolean handleMessage(SOAPMessageContext ctx) {
                super.handleMessage(ctx);
                Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                if (outbound.booleanValue()) {
                    try {
                        SOAPMessage msg = ctx.getMessage();
                        Assert.assertNotNull((Object)msg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.toString());
                    }
                }
                return true;
            }
        };
        this.addHandlersProgrammatically((BindingProvider)disp, new Handler[]{sh, soapHandler});
        org.apache.handlers.types.AddNumbers req = new org.apache.handlers.types.AddNumbers();
        req.setArg0(10);
        req.setArg1(20);
        ObjectFactory factory = new ObjectFactory();
        JAXBElement e = factory.createAddNumbers(req);
        JAXBElement response = (JAXBElement)disp.invoke((Object)e);
        HandlerInvocationUsingAddNumbersTest.assertNotNull((Object)response);
        AddNumbersResponse value = (AddNumbersResponse)response.getValue();
        HandlerInvocationUsingAddNumbersTest.assertEquals((Object)200, (Object)value.getReturn());
    }

    @Test
    public void testHandlerPostConstruct() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        AddNumbersServiceWithAnnotation service = new AddNumbersServiceWithAnnotation(wsdl, serviceName);
        AddNumbers port = (AddNumbers)service.getPort(portName, AddNumbers.class);
        List handlerChain = ((BindingProvider)port).getBinding().getHandlerChain();
        SmallNumberHandler h = (SmallNumberHandler)handlerChain.get(0);
        HandlerInvocationUsingAddNumbersTest.assertTrue((boolean)h.isPostConstructInvoked());
    }

    @Test
    public void testHandlerInjectingResource() throws Exception {
        Bus bus = BusFactory.getDefaultBus();
        ResourceManager resourceManager = (ResourceManager)bus.getExtension(ResourceManager.class);
        HandlerInvocationUsingAddNumbersTest.assertNotNull((Object)resourceManager);
        resourceManager.addResourceResolver((ResourceResolver)new TestResourceResolver());
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/addNumbers.wsdl");
        AddNumbersServiceWithAnnotation service = new AddNumbersServiceWithAnnotation(wsdl, serviceName);
        AddNumbers port = (AddNumbers)service.getPort(portName, AddNumbers.class);
        List handlerChain = ((BindingProvider)port).getBinding().getHandlerChain();
        SmallNumberHandler h = (SmallNumberHandler)handlerChain.get(0);
        HandlerInvocationUsingAddNumbersTest.assertEquals((Object)"injectedValue", (Object)h.getInjectedString());
    }

    private void addHandlersProgrammatically(BindingProvider bp, Handler ... handlers) {
        List handlerChain = bp.getBinding().getHandlerChain();
        HandlerInvocationUsingAddNumbersTest.assertNotNull((Object)handlerChain);
        for (Handler h : handlers) {
            handlerChain.add(h);
        }
    }
}

