/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.handlers;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.handler_test.HandlerTest;
import org.apache.handler_test.PingException;
import org.apache.handler_test.types.PingFaultDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="HandlerTestService", portName="SoapPort", endpointInterface="org.apache.handler_test.HandlerTest", targetNamespace="http://apache.org/handler_test", wsdlLocation="testutils/handler_test.wsdl")
@HandlerChain(file="./handlers_invocation.xml", name="TestHandlerChain")
public class HandlerTestImpl
implements HandlerTest {
    private WebServiceContext context;

    public final List<String> ping() {
        try {
            List<String> handlerInfoList = this.getHandlersInfo(this.context.getMessageContext());
            handlerInfoList.add("servant");
            this.context.getMessageContext().remove((Object)"handler.info");
            return handlerInfoList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final void pingOneWay() {
    }

    public final List<String> pingWithArgs(String handlerCommand) throws PingException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(handlerCommand);
        ret.addAll(this.getHandlersInfo(this.context.getMessageContext()));
        if (handlerCommand.contains("servant throw exception")) {
            PingFaultDetails details = new PingFaultDetails();
            details.setDetail(((Object)ret).toString());
            throw new PingException("from servant", details);
        }
        if (handlerCommand.contains("servant throw RuntimeException")) {
            throw new RuntimeException("servant throw RuntimeException");
        }
        if (handlerCommand.contains("servant throw SOAPFaultException")) {
            throw this.createSOAPFaultException("servant throws SOAPFaultException");
        }
        if (handlerCommand.contains("servant throw WebServiceException")) {
            RuntimeException re = new RuntimeException("servant throws RuntimeException");
            throw new WebServiceException("RemoteException with nested RuntimeException", (Throwable)re);
        }
        return ret;
    }

    private SOAPFaultException createSOAPFaultException(String faultString) {
        try {
            SOAPFault fault = SOAPFactory.newInstance().createFault();
            fault.setFaultString(faultString);
            fault.setFaultCode(new QName("http://cxf.apache.org/faultcode", "Server"));
            return new SOAPFaultException(fault);
        }
        catch (SOAPException sOAPException) {
            return null;
        }
    }

    @Resource
    public void setWebServiceContext(WebServiceContext ctx) {
        this.context = ctx;
    }

    private List<String> getHandlersInfo(MessageContext ctx) {
        ArrayList ret = CastUtils.cast((List)((List)ctx.get((Object)"handler.info")));
        if (ret == null) {
            ret = new ArrayList();
        }
        return ret;
    }
}

