/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.handlers;

import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.systest.handlers.TestHandlerBase;
import org.apache.cxf.wsdl.WSDLManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSOAPHandler<T extends SOAPMessageContext>
extends TestHandlerBase
implements SOAPHandler<T> {
    @Resource
    Bus bus;
    @Resource(name="org.apache.cxf.wsdl.WSDLManager")
    WSDLManager manager;

    public TestSOAPHandler() {
        this(true);
    }

    public TestSOAPHandler(boolean serverSide) {
        super(serverSide);
    }

    @PostConstruct
    public void initPost() {
        if (this.bus == null) {
            throw new RuntimeException("No BUS");
        }
        if (this.manager == null) {
            throw new RuntimeException("No WSDL Manager");
        }
    }

    public final Set<QName> getHeaders() {
        return null;
    }

    @Override
    public String getHandlerId() {
        return "soapHandler" + this.getId();
    }

    public boolean handleMessage(SOAPMessageContext ctx) {
        boolean continueProcessing;
        block10: {
            continueProcessing = true;
            if (!this.isValidWsdlDescription(ctx.get((Object)"javax.xml.ws.wsdl.description"))) {
                throw new RuntimeException("can't find WsdlDescription throws RuntimeException");
            }
            try {
                this.methodCalled("handleMessage");
                this.printHandlerInfo("handleMessage", this.isOutbound((MessageContext)ctx));
                Object b = ctx.get((Object)"javax.xml.ws.handler.message.outbound");
                boolean outbound = (Boolean)b;
                SOAPMessage msg = ctx.getMessage();
                if (!this.isServerSideHandler()) break block10;
                if (outbound) {
                    continueProcessing = this.getReturnValue(outbound, ctx);
                } else {
                    continueProcessing = this.getReturnValue(outbound, ctx);
                    if (!continueProcessing) {
                        outbound = true;
                    }
                }
                if (outbound) {
                    try {
                        SOAPBody body = msg.getSOAPBody();
                        Node resp = body.getFirstChild();
                        if (resp.getNodeName().contains("pingResponse")) {
                            Node child = resp.getFirstChild();
                            Document doc = resp.getOwnerDocument();
                            Element info = doc.createElementNS(child.getNamespaceURI(), child.getLocalName());
                            info.setPrefix("ns4");
                            info.appendChild(doc.createTextNode(this.getHandlerId()));
                            resp.appendChild(info);
                            msg.saveChanges();
                        }
                        break block10;
                    }
                    catch (DOMException e) {
                        e.printStackTrace();
                    }
                    break block10;
                }
                this.getHandlerInfoList((MessageContext)ctx).add(this.getHandlerId());
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
        return continueProcessing;
    }

    public boolean handleFault(SOAPMessageContext ctx) {
        this.methodCalled("handleFault");
        this.printHandlerInfo("handleFault", this.isOutbound((MessageContext)ctx));
        if (this.isServerSideHandler()) {
            if (!"soapHandler4".equals(this.getHandlerId())) {
                return true;
            }
            try {
                SOAPMessage msg = ctx.getMessage();
                if ("soapHandler4HandleFaultThrowsRunException".equals(msg.getSOAPBody().getFault().getFaultString())) {
                    throw new RuntimeException("soapHandler4 HandleFault throws RuntimeException");
                }
                if ("soapHandler4HandleFaultThrowsSOAPFaultException".equals(msg.getSOAPBody().getFault().getFaultString())) {
                    throw this.createSOAPFaultException("soapHandler4 HandleFault throws SOAPFaultException");
                }
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
        return true;
    }

    public final void init(Map map) {
        this.methodCalled("init");
    }

    public final void destroy() {
        this.methodCalled("destroy");
    }

    public final void close(MessageContext messageContext) {
        this.methodCalled("close");
    }

    private boolean getReturnValue(boolean outbound, SOAPMessageContext ctx) {
        boolean ret = true;
        try {
            SOAPMessage msg = ctx.getMessage();
            SOAPBody body = msg.getSOAPBody();
            if (body.getFirstChild().getFirstChild() == null) {
                return true;
            }
            Node commandNode = body.getFirstChild().getFirstChild().getFirstChild();
            String arg = commandNode.getNodeValue();
            String namespace = body.getFirstChild().getFirstChild().getNamespaceURI();
            StringTokenizer strtok = new StringTokenizer(arg, " ");
            String hid = "";
            String direction = "";
            String command = "";
            if (strtok.countTokens() >= 3) {
                hid = strtok.nextToken();
                direction = strtok.nextToken();
                command = strtok.nextToken();
            }
            if (!this.getHandlerId().equals(hid)) {
                return true;
            }
            if ("stop".equals(command)) {
                if (!outbound && "inbound".equals(direction)) {
                    Document doc = body.getOwnerDocument();
                    Element wrapper = doc.createElementNS(namespace, "pingResponse");
                    wrapper.setPrefix("ns4");
                    body.removeChild(body.getFirstChild());
                    body.appendChild((Node)wrapper);
                    for (String info : this.getHandlerInfoList((MessageContext)ctx)) {
                        if (info.contains(this.getHandlerId())) continue;
                        Element newEl = doc.createElementNS(namespace, "HandlersInfo");
                        newEl.setPrefix("ns4");
                        newEl.appendChild(doc.createTextNode(info));
                        wrapper.appendChild(newEl);
                    }
                    ret = false;
                } else if (outbound && "outbound".equals(direction)) {
                    ret = false;
                }
            } else if ("throw".equals(command)) {
                String exceptionType = null;
                String exceptionText = "HandleMessage throws exception";
                if (strtok.hasMoreTokens()) {
                    exceptionType = strtok.nextToken();
                }
                if (strtok.hasMoreTokens()) {
                    exceptionText = strtok.nextToken();
                }
                if (exceptionType != null && !outbound && "inbound".equals(direction)) {
                    if ("RuntimeException".equals(exceptionType)) {
                        throw new RuntimeException(exceptionText);
                    }
                    if ("ProtocolException".equals(exceptionType)) {
                        throw new ProtocolException(exceptionText);
                    }
                    if ("SOAPFaultException".equals(exceptionType)) {
                        throw this.createSOAPFaultException(exceptionText);
                    }
                    if ("SOAPFaultExceptionWDetail".equals(exceptionType)) {
                        throw this.createSOAPFaultExceptionWithDetail(exceptionText);
                    }
                } else if (exceptionType != null && outbound && "outbound".equals(direction)) {
                    if ("RuntimeException".equals(exceptionType)) {
                        throw new RuntimeException(exceptionText);
                    }
                    if ("ProtocolException".equals(exceptionType)) {
                        throw new ProtocolException(exceptionText);
                    }
                    if ("SOAPFaultException".equals(exceptionType)) {
                        throw this.createSOAPFaultException(exceptionText);
                    }
                    if ("SOAPFaultExceptionWDetail".equals(exceptionType)) {
                        throw this.createSOAPFaultExceptionWithDetail(exceptionText);
                    }
                }
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private SOAPFaultException createSOAPFaultException(String faultString) throws SOAPException {
        SOAPFault fault = SOAPFactory.newInstance().createFault();
        fault.setFaultString(faultString);
        fault.setFaultCode(new QName("http://cxf.apache.org/faultcode", "Server"));
        return new SOAPFaultException(fault);
    }

    private SOAPFaultException createSOAPFaultExceptionWithDetail(String faultString) throws SOAPException {
        SOAPFault fault = SOAPFactory.newInstance().createFault();
        QName faultName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
        fault.setFaultCode(faultName);
        fault.setFaultActor("http://gizmos.com/orders");
        fault.setFaultString(faultString);
        Detail detail = fault.addDetail();
        QName entryName = new QName("http://gizmos.com/orders/", "order", "PO");
        DetailEntry entry = detail.addDetailEntry(entryName);
        entry.addTextNode("Quantity element does not have a value");
        QName entryName2 = new QName("http://gizmos.com/orders/", "order", "PO");
        DetailEntry entry2 = detail.addDetailEntry(entryName2);
        entry2.addTextNode("Incomplete address: no zip code");
        return new SOAPFaultException(fault);
    }

    public String toString() {
        return this.getHandlerId();
    }

    private boolean isValidWsdlDescription(Object wsdlDescription) {
        return wsdlDescription != null && (wsdlDescription instanceof URI || wsdlDescription instanceof URL);
    }
}

