/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import junit.framework.Assert;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.junit.Test;

public class PublishedEndpointUrlTest
extends Assert {
    @Test
    public void testPublishedEndpointUrl() throws Exception {
        GreeterImpl implementor = new GreeterImpl();
        String publishedEndpointUrl = "http://cxf.apache.org/publishedEndpointUrl";
        JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
        svrFactory.setServiceClass(Greeter.class);
        svrFactory.setAddress("http://localhost:9000/publishedEndpointUrl");
        svrFactory.setPublishedEndpointUrl(publishedEndpointUrl);
        svrFactory.setServiceBean((Object)implementor);
        Server server = svrFactory.create();
        WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        URL url = new URL(svrFactory.getAddress() + "?wsdl=1");
        HttpURLConnection connect = (HttpURLConnection)url.openConnection();
        PublishedEndpointUrlTest.assertEquals((int)500, (int)connect.getResponseCode());
        Definition wsdl = wsdlReader.readWSDL(svrFactory.getAddress() + "?wsdl");
        PublishedEndpointUrlTest.assertNotNull((Object)wsdl);
        Collection services = CastUtils.cast(wsdl.getAllServices().values());
        String failMesg = "WSDL provided incorrect soap:address location";
        for (Service service : services) {
            Collection ports = CastUtils.cast(service.getPorts().values());
            for (Port port : ports) {
                List extensions = port.getExtensibilityElements();
                for (Object extension : extensions) {
                    String actualUrl = null;
                    if (extension instanceof SOAP12Address) {
                        actualUrl = ((SOAP12Address)extension).getLocationURI();
                    } else if (extension instanceof SOAPAddress) {
                        actualUrl = ((SOAPAddress)extension).getLocationURI();
                    }
                    PublishedEndpointUrlTest.assertEquals((String)"WSDL provided incorrect soap:address location", (String)publishedEndpointUrl, (String)actualUrl);
                }
            }
        }
        server.stop();
    }
}

