/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http_jetty;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.systest.http_jetty.DummyInterface;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class EngineLifecycleTest
extends Assert {
    private String close;
    private GenericApplicationContext applicationContext;

    private void readBeans(Resource beanResource) {
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.applicationContext);
        reader.loadBeanDefinitions(beanResource);
    }

    @Before
    public void setSystemProperties() {
        this.close = System.getProperty("org.apache.cxf.transports.http_jetty.DontClosePort");
        System.setProperty("org.apache.cxf.transports.http_jetty.DontClosePort", "false");
    }

    @After
    public void resetSystemProperties() {
        if (this.close != null) {
            System.setProperty("org.apache.cxf.transports.http_jetty.DontClosePort", this.close);
        }
    }

    public void setUpBus(boolean includeService) throws Exception {
        this.applicationContext = new GenericApplicationContext();
        this.readBeans((Resource)new ClassPathResource("/org/apache/cxf/systest/http_jetty/cxf.xml"));
        this.readBeans((Resource)new ClassPathResource("META-INF/cxf/cxf.xml"));
        this.readBeans((Resource)new ClassPathResource("META-INF/cxf/cxf-extension-soap.xml"));
        this.readBeans((Resource)new ClassPathResource("META-INF/cxf/cxf-extension-http.xml"));
        this.readBeans((Resource)new ClassPathResource("META-INF/cxf/cxf-extension-http-jetty.xml"));
        this.readBeans((Resource)new ClassPathResource("jetty-engine.xml", ((Object)((Object)this)).getClass()));
        if (includeService) {
            this.readBeans((Resource)new ClassPathResource("server-lifecycle-beans.xml", ((Object)((Object)this)).getClass()));
        }
        PropertyPlaceholderConfigurer cfg = new PropertyPlaceholderConfigurer();
        Properties properties = new Properties();
        properties.setProperty("staticResourceURL", this.getStaticResourceURL());
        cfg.setProperties(properties);
        cfg.postProcessBeanFactory(this.applicationContext.getBeanFactory());
        this.applicationContext.refresh();
    }

    private void invokeService() {
        DummyInterface client = (DummyInterface)this.applicationContext.getBean("dummy-client");
        EngineLifecycleTest.assertEquals((String)"We should get out put from this client", (Object)"hello world", (Object)client.echo("hello world"));
    }

    private void invokeService8801() {
        DummyInterface client = (DummyInterface)this.applicationContext.getBean("dummy-client-8801");
        EngineLifecycleTest.assertEquals((String)"We should get out put from this client", (Object)"hello world", (Object)client.echo("hello world"));
    }

    private HttpURLConnection getHttpConnection(String target) throws Exception {
        URL url = new URL(target);
        URLConnection connection = url.openConnection();
        EngineLifecycleTest.assertTrue((boolean)(connection instanceof HttpURLConnection));
        return (HttpURLConnection)connection;
    }

    private void getTestHtml() throws Exception {
        HttpURLConnection httpConnection = this.getHttpConnection("http://localhost:8808/test.html");
        httpConnection.connect();
        InputStream in = httpConnection.getInputStream();
        EngineLifecycleTest.assertNotNull((Object)in);
        CachedOutputStream response = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)response);
        in.close();
        response.close();
        FileInputStream htmlFile = new FileInputStream("target/test-classes/org/apache/cxf/systest/http_jetty/test.html");
        CachedOutputStream html = new CachedOutputStream();
        IOUtils.copy((InputStream)htmlFile, (OutputStream)html);
        htmlFile.close();
        html.close();
        EngineLifecycleTest.assertEquals((String)"Can't get the right test html", (Object)html.toString(), (Object)response.toString());
    }

    public String getStaticResourceURL() throws Exception {
        File staticFile = new File(((Object)((Object)this)).getClass().getResource("test.html").toURI());
        staticFile = staticFile.getParentFile();
        staticFile = staticFile.getAbsoluteFile();
        URL furl = staticFile.toURI().toURL();
        return furl.toString();
    }

    public void shutdownService() throws Exception {
        Bus bus = (Bus)this.applicationContext.getBean("cxf");
        bus.shutdown(true);
        this.applicationContext.destroy();
        this.applicationContext.close();
    }

    @Test
    public void testUpDownWithServlets() throws Exception {
        this.setUpBus(true);
        Bus bus = (Bus)this.applicationContext.getBean("cxf");
        ServerRegistry sr = (ServerRegistry)bus.getExtension(ServerRegistry.class);
        ServerImpl si = (ServerImpl)sr.getServers().get(0);
        JettyHTTPDestination jhd = (JettyHTTPDestination)si.getDestination();
        JettyHTTPServerEngine e = (JettyHTTPServerEngine)jhd.getEngine();
        Server jettyServer = e.getServer();
        Handler[] contexts = jettyServer.getChildHandlersByClass(WebAppContext.class);
        WebAppContext servletContext = null;
        for (Handler h : contexts) {
            WebAppContext wac = (WebAppContext)h;
            if (!wac.getContextPath().equals("/jsunit")) continue;
            servletContext = wac;
            break;
        }
        servletContext.addServlet("org.mortbay.jetty.servlet.DefaultServlet", "/bloop");
        this.getTestHtml();
        this.invokeService();
        this.shutdownService();
        this.verifyNoServer(8808);
        this.verifyNoServer(8801);
    }

    private void verifyNoServer(int port) {
        try {
            Socket socket = new Socket(InetAddress.getLocalHost(), port);
            socket.close();
        }
        catch (UnknownHostException e) {
            EngineLifecycleTest.fail((String)"Unknown host for local address");
        }
        catch (IOException e) {
            return;
        }
        EngineLifecycleTest.fail((String)("Server on port " + port + " accepted a connection."));
    }

    @Test
    public void testServerUpDownUp() throws Exception {
        this.setUpBus(true);
        this.getTestHtml();
        this.invokeService();
        this.invokeService8801();
        this.shutdownService();
        this.verifyNoServer(8808);
        this.verifyNoServer(8801);
        this.setUpBus(true);
        this.invokeService();
        this.invokeService8801();
        this.getTestHtml();
        this.shutdownService();
        this.verifyNoServer(8808);
        this.verifyNoServer(8801);
    }
}

