/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http_jetty;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.systest.http_jetty.Server;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.SOAPService;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ThreadPoolTest
extends AbstractClientServerTestBase {
    private static final QName SERVICE_NAME = new QName("http://apache.org/hello_world_soap_http", "SOAPServiceAddressing");
    private Greeter greeter;

    @BeforeClass
    public static void startServers() throws Exception {
        ThreadPoolTest.assertTrue((String)"server did not launch correctly", (boolean)ThreadPoolTest.launchServer(Server.class, (boolean)false));
    }

    @Before
    public void setUp() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        this.greeter = (Greeter)new SOAPService(wsdl, SERVICE_NAME).getPort(Greeter.class);
        BindingProvider bp = (BindingProvider)this.greeter;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:9077/SoapContext/SoapPort");
    }

    @Test
    public void testFallbackThreadPoolConfig() throws Exception {
        int i;
        Runnable r = new Runnable(){

            public void run() {
                ThreadPoolTest.this.greeter.greetMeLater(5000L);
            }
        };
        Thread[] invokers = new Thread[5];
        long start = System.currentTimeMillis();
        for (i = 0; i < invokers.length; ++i) {
            invokers[i] = new Thread(r);
            invokers[i].setDaemon(true);
            invokers[i].start();
        }
        for (i = 0; i < invokers.length; ++i) {
            invokers[i].join(15000L);
        }
        long end = System.currentTimeMillis();
        ThreadPoolTest.assertTrue((String)("unexpected duration: " + (end - start)), (end - start > 10000L ? 1 : 0) != 0);
    }
}

