/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http_jetty.continuations;

import java.net.URL;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.http_jetty.continuations.ControlWorker;
import org.apache.cxf.systest.http_jetty.continuations.HelloContinuation;
import org.apache.cxf.systest.http_jetty.continuations.HelloContinuationService;
import org.apache.cxf.systest.http_jetty.continuations.HelloImplWithWrapppedContinuation;
import org.apache.cxf.systest.http_jetty.continuations.HelloWorker;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClientServerWrappedContinuationTest
extends AbstractClientServerTestBase {
    private static final String CLIENT_CONFIG_FILE = "org/apache/cxf/systest/http_jetty/continuations/cxf.xml";
    private static final String SERVER_CONFIG_FILE = "org/apache/cxf/systest/http_jetty/continuations/jaxws-server.xml";

    @BeforeClass
    public static void startServers() throws Exception {
        ClientServerWrappedContinuationTest.assertTrue((String)"server did not launch correctly", (boolean)ClientServerWrappedContinuationTest.launchServer(Server.class));
    }

    @Test
    public void testHttpWrappedContinuatuions() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        Bus bus = bf.createBus(CLIENT_CONFIG_FILE);
        BusFactory.setDefaultBus((Bus)bus);
        QName serviceName = new QName("http://cxf.apache.org/systest/jaxws", "HelloContinuationService");
        URL wsdlURL = new URL("http://localhost:9092/hellocontinuation?wsdl");
        HelloContinuationService service = new HelloContinuationService(wsdlURL, serviceName);
        ClientServerWrappedContinuationTest.assertNotNull((Object)((Object)service));
        HelloContinuation helloPort = service.getHelloContinuationPort();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(6));
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch controlDoneSignal = new CountDownLatch(5);
        CountDownLatch helloDoneSignal = new CountDownLatch(5);
        executor.execute(new ControlWorker(helloPort, "Fred", startSignal, controlDoneSignal));
        executor.execute(new HelloWorker(helloPort, "Fred", "", startSignal, helloDoneSignal));
        executor.execute(new ControlWorker(helloPort, "Barry", startSignal, controlDoneSignal));
        executor.execute(new HelloWorker(helloPort, "Barry", "Jameson", startSignal, helloDoneSignal));
        executor.execute(new ControlWorker(helloPort, "Harry", startSignal, controlDoneSignal));
        executor.execute(new HelloWorker(helloPort, "Harry", "", startSignal, helloDoneSignal));
        executor.execute(new ControlWorker(helloPort, "Rob", startSignal, controlDoneSignal));
        executor.execute(new HelloWorker(helloPort, "Rob", "Davidson", startSignal, helloDoneSignal));
        executor.execute(new ControlWorker(helloPort, "James", startSignal, controlDoneSignal));
        executor.execute(new HelloWorker(helloPort, "James", "ServiceMix", startSignal, helloDoneSignal));
        startSignal.countDown();
        controlDoneSignal.await(10L, TimeUnit.SECONDS);
        helloDoneSignal.await(10L, TimeUnit.SECONDS);
        executor.shutdownNow();
        ClientServerWrappedContinuationTest.assertEquals((String)"Not all invocations have been resumed", (Object)0, (Object)controlDoneSignal.getCount());
        ClientServerWrappedContinuationTest.assertEquals((String)"Not all invocations have completed", (Object)0, (Object)helloDoneSignal.getCount());
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus(ClientServerWrappedContinuationTest.SERVER_CONFIG_FILE);
            BusFactory.setDefaultBus((Bus)bus);
            HelloImplWithWrapppedContinuation implementor = new HelloImplWithWrapppedContinuation();
            String address = "http://localhost:9092/hellocontinuation";
            Endpoint.publish((String)address, (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

