/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http_jetty.continuations;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.systest.http_jetty.continuations.HelloContinuation;

@WebService(name="HelloContinuation", serviceName="HelloContinuationService", portName="HelloContinuationPort", targetNamespace="http://cxf.apache.org/systest/jaxws", endpointInterface="org.apache.cxf.systest.http_jetty.continuations.HelloContinuation")
public class HelloImplWithWrapppedContinuation
implements HelloContinuation {
    private Map<String, Continuation> suspended = new HashMap<String, Continuation>();
    @Resource
    private WebServiceContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sayHi(String firstName, String secondName) {
        Continuation continuation = this.getContinuation(firstName);
        if (continuation == null) {
            throw new RuntimeException("Failed to get continuation");
        }
        Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (!continuation.isNew()) {
                StringBuilder sb = new StringBuilder();
                sb.append(firstName);
                if (secondName != null && secondName.length() > 0) {
                    String surname = continuation.getObject().toString();
                    sb.append(' ').append(surname);
                }
                System.out.println("Saying hi to " + sb.toString());
                return "Hi " + sb.toString();
            }
            String userObject = secondName != null && secondName.length() > 0 ? secondName : null;
            continuation.setObject((Object)userObject);
            this.suspendInvocation(firstName, continuation);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestSuspended(String name) {
        Map<String, Continuation> map = this.suspended;
        synchronized (map) {
            while (!this.suspended.containsKey(name)) {
                try {
                    this.suspended.wait(10000L);
                }
                catch (InterruptedException ex) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeRequest(String name) {
        Continuation suspendedCont = null;
        Continuation continuation = this.suspended;
        synchronized (continuation) {
            suspendedCont = this.suspended.get(name);
        }
        if (suspendedCont != null) {
            continuation = suspendedCont;
            synchronized (continuation) {
                suspendedCont.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendInvocation(String name, Continuation cont) {
        try {
            cont.suspend(20000L);
        }
        finally {
            Map<String, Continuation> map = this.suspended;
            synchronized (map) {
                this.suspended.put(name, cont);
                this.suspended.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Continuation getContinuation(String name) {
        Map<String, Continuation> map = this.suspended;
        synchronized (map) {
            Continuation suspendedCont = this.suspended.remove(name);
            if (suspendedCont != null) {
                return suspendedCont;
            }
        }
        ContinuationProvider provider = (ContinuationProvider)this.context.getMessageContext().get((Object)ContinuationProvider.class.getName());
        return provider.getContinuation();
    }
}

