/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http_jetty.continuations;

import java.util.concurrent.CountDownLatch;
import org.apache.cxf.systest.http_jetty.continuations.HelloContinuation;
import org.junit.Assert;

public class HelloWorker
implements Runnable {
    private HelloContinuation helloPort;
    private String firstName;
    private String secondName;
    private CountDownLatch startSignal;
    private CountDownLatch doneSignal;

    public HelloWorker(HelloContinuation helloPort, String firstName, String secondName, CountDownLatch startSignal, CountDownLatch doneSignal) {
        this.helloPort = helloPort;
        this.firstName = firstName;
        this.secondName = secondName;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
    }

    public void run() {
        StringBuilder expected = new StringBuilder();
        expected.append(this.firstName);
        if (this.secondName != null && this.secondName.length() > 0) {
            expected.append(' ').append(this.secondName);
        }
        try {
            this.startSignal.await();
            Assert.assertEquals((String)"Wrong hello", (Object)("Hi " + expected.toString()), (Object)this.helloPort.sayHi(this.firstName, this.secondName));
            this.doneSignal.countDown();
        }
        catch (InterruptedException ex) {
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            Assert.fail((String)("Hello thread failed for : " + expected.toString()));
        }
    }
}

