/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.greeter_control.Control;
import org.apache.cxf.greeter_control.ControlImpl;
import org.apache.cxf.greeter_control.ControlService;
import org.apache.cxf.greeter_control.FaultThrowingInterceptor;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.GreeterService;
import org.apache.cxf.greeter_control.PingMeFault;
import org.apache.cxf.greeter_control.types.FaultLocation;
import org.apache.cxf.greeter_control.types.ObjectFactory;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseComparator;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.systest.interceptor.GreeterImpl;
import org.apache.cxf.test.TestUtilities;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class InterceptorFaultTest
extends AbstractBusClientServerTestBase {
    private static final Logger LOG = LogUtils.getLogger(InterceptorFaultTest.class);
    private static final QName SOAP_FAULT_CODE = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    private static final String FAULT_CODE = "COULD_NOT_SEND";
    private static final String FAULT_MESSAGE = "Could not send Message.";
    private static final String CONTROL_PORT_ADDRESS = "http://localhost:9001/SoapContext/ControlPort";
    private static int decoupledEndpointPort = 10000;
    private static String decoupledEndpoint;
    private Bus controlBus;
    private Control control;
    private Bus greeterBus;
    private Greeter greeter;
    private List<Phase> inPhases;
    private PhaseComparator comparator;
    private Phase preLogicalPhase;

    @BeforeClass
    public static void startServers() throws Exception {
        TestUtilities.setKeepAliveSystemProperty((boolean)false);
        InterceptorFaultTest.assertTrue((String)"server did not launch correctly", (boolean)InterceptorFaultTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() {
        TestUtilities.recoverKeepAliveSystemProperty();
    }

    @After
    public void tearDown() {
        if (null != this.greeter) {
            InterceptorFaultTest.assertTrue((String)"Failed to stop greeter.", (boolean)this.control.stopGreeter(null));
            this.greeterBus.shutdown(true);
            this.greeterBus = null;
        }
        if (null != this.control) {
            InterceptorFaultTest.assertTrue((String)"Failed to stop greeter", (boolean)this.control.stopGreeter(null));
            this.controlBus.shutdown(true);
        }
    }

    @Test
    public void testWithoutAddressing() throws Exception {
        this.setupGreeter("org/apache/cxf/systest/interceptor/no-addr.xml", false);
        Iterator<Phase> it = this.inPhases.iterator();
        Phase p = null;
        FaultLocation location = new ObjectFactory().createFaultLocation();
        while (it.hasNext()) {
            p = it.next();
            location.setPhase(p.getName());
            if ("pre-logical".equals(p.getName())) break;
            this.testFail(location);
        }
    }

    @Test
    public void testWithAddressingAnonymousReplies() throws Exception {
        this.setupGreeter("org/apache/cxf/systest/interceptor/addr.xml", false);
        this.greeter.greetMeOneWay("one");
        InterceptorFaultTest.assertEquals((Object)"TWO", (Object)this.greeter.greetMe("two"));
        try {
            this.greeter.pingMe();
            InterceptorFaultTest.fail((String)"Expected PingMeFault not thrown.");
        }
        catch (PingMeFault f) {
            InterceptorFaultTest.assertEquals((Object)20, (Object)f.getFaultInfo().getMajor());
            InterceptorFaultTest.assertEquals((Object)10, (Object)f.getFaultInfo().getMinor());
        }
        Iterator<Phase> it = this.inPhases.iterator();
        Phase p = null;
        FaultLocation location = new ObjectFactory().createFaultLocation();
        location.setAfter(MAPAggregator.class.getName());
        while (it.hasNext()) {
            p = it.next();
            location.setPhase(p.getName());
            if ("pre-logical".equals(p.getName())) break;
            this.testFail(location, true);
        }
        do {
            location.setPhase(p.getName());
            if ("invoke".equals(p.getName())) break;
            this.testFail(location, true);
        } while (null != (p = it.hasNext() ? it.next() : null));
    }

    private void testFail(FaultLocation location) throws PingMeFault {
        this.testFail(location, false);
    }

    private void testFail(FaultLocation location, boolean usingAddressing) throws PingMeFault {
        SoapFault sf;
        Throwable cause;
        this.control.setFaultLocation(location);
        String expectedMsg = this.getExpectedInterceptorFaultMessage(location.getPhase());
        boolean expectOnewayFault = !usingAddressing || this.comparator.compare(this.preLogicalPhase, this.getPhase(location.getPhase())) > 0;
        try {
            this.greeter.greetMeOneWay("oneway");
            if (expectOnewayFault) {
                InterceptorFaultTest.fail((String)("Oneway operation unexpectedly succeded for phase " + location.getPhase()));
            }
        }
        catch (WebServiceException ex) {
            if (!expectOnewayFault) {
                InterceptorFaultTest.fail((String)"Oneway operation unexpectedly failed.");
            }
            cause = ex.getCause();
            Fault f = (Fault)cause;
            InterceptorFaultTest.assertEquals((Object)FAULT_CODE, (Object)f.getCode());
            InterceptorFaultTest.assertEquals((Object)FAULT_MESSAGE, (Object)f.getMessage());
        }
        try {
            this.greeter.greetMe("cxf");
            InterceptorFaultTest.fail((String)"Twoway operation unexpectedly succeded.");
        }
        catch (WebServiceException ex) {
            cause = ex.getCause();
            sf = (SoapFault)cause;
            InterceptorFaultTest.assertEquals((Object)expectedMsg, (Object)sf.getReason());
            InterceptorFaultTest.assertEquals((Object)SOAP_FAULT_CODE, (Object)sf.getFaultCode());
        }
        try {
            this.greeter.pingMe();
            InterceptorFaultTest.fail((String)"Expected PingMeFault not thrown.");
        }
        catch (WebServiceException ex) {
            cause = ex.getCause();
            sf = (SoapFault)cause;
            InterceptorFaultTest.assertEquals((Object)expectedMsg, (Object)sf.getReason());
            InterceptorFaultTest.assertEquals((Object)SOAP_FAULT_CODE, (Object)sf.getFaultCode());
        }
    }

    private void setupGreeter(String cfgResource, boolean useDecoupledEndpoint) {
        SpringBusFactory bf = new SpringBusFactory();
        this.controlBus = bf.createBus();
        BusFactory.setDefaultBus((Bus)this.controlBus);
        ControlService cs = new ControlService();
        this.control = cs.getControlPort();
        InterceptorFaultTest.assertTrue((String)"Failed to start greeter", (boolean)this.control.startGreeter(cfgResource));
        this.greeterBus = bf.createBus(cfgResource);
        BusFactory.setDefaultBus((Bus)this.greeterBus);
        LOG.fine("Initialised greeter bus with configuration: " + cfgResource);
        if (null == this.comparator) {
            this.comparator = new PhaseComparator();
        }
        if (null == this.inPhases) {
            this.inPhases = new ArrayList<Phase>();
            this.inPhases.addAll(((PhaseManager)this.greeterBus.getExtension(PhaseManager.class)).getInPhases());
            Collections.sort(this.inPhases, this.comparator);
        }
        if (null == this.preLogicalPhase) {
            this.preLogicalPhase = this.getPhase("pre-logical");
        }
        GreeterService gs = new GreeterService();
        this.greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        if (!useDecoupledEndpoint) {
            return;
        }
        decoupledEndpoint = "http://localhost:" + --decoupledEndpointPort + "/decoupled_endpoint";
        Client c = ClientProxy.getClient((Object)this.greeter);
        HTTPConduit hc = (HTTPConduit)c.getConduit();
        HTTPClientPolicy cp = hc.getClient();
        cp.setDecoupledEndpoint(decoupledEndpoint);
        LOG.fine("Using decoupled endpoint: " + cp.getDecoupledEndpoint());
    }

    private String getExpectedInterceptorFaultMessage(String phase) {
        return FaultThrowingInterceptor.MESSAGE_FORMAT.format(new Object[]{phase}).toUpperCase();
    }

    private Phase getPhase(String name) {
        for (Phase p : this.inPhases) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory factory = new SpringBusFactory();
            Bus bus = factory.createBus();
            BusFactory.setDefaultBus((Bus)bus);
            this.setBus(bus);
            ControlImpl implementor = new ControlImpl();
            GreeterImpl greeterImplementor = new GreeterImpl();
            greeterImplementor.setThrowAlways(true);
            implementor.setImplementor((Object)greeterImplementor);
            Endpoint.publish((String)InterceptorFaultTest.CONTROL_PORT_ADDRESS, (Object)implementor);
            LOG.fine("Published control endpoint.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

