/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxb;

import java.io.InputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.systest.jaxb.model.ExtendedWidget;
import org.apache.cxf.systest.jaxb.model.Widget;
import org.apache.cxf.systest.jaxb.service.TestService;
import org.apache.cxf.test.TestUtilities;
import org.junit.Test;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TestServiceTest
extends AbstractDependencyInjectionSpringContextTests {
    private TestService testClient;
    private TestUtilities testUtilities;

    public TestServiceTest() {
        this.setAutowireMode(1);
        this.testUtilities = new TestUtilities(((Object)((Object)this)).getClass());
    }

    @Test
    public void testExtraSubClassWithJaxb() throws Throwable {
        ExtendedWidget expected = new ExtendedWidget(42L, "blah", "blah", true, true);
        Widget widgetFromService = this.testClient.getWidgetById(42L);
        TestServiceTest.assertEquals((Object)expected, (Object)widgetFromService);
    }

    @Test
    public void testExtraSubClassWithJaxbFromEndpoint() throws Throwable {
        ExtendedWidget expected = new ExtendedWidget(42L, "blah", "blah", true, true);
        ((BindingProvider)this.testClient).getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:7081/service/TestEndpoint");
        Widget widgetFromService = this.testClient.getWidgetById(42L);
        TestServiceTest.assertEquals((Object)expected, (Object)widgetFromService);
    }

    @Test
    public void testSchema() throws Exception {
        URL url = new URL("http://localhost:7081/service/TestService?wsdl");
        String s = IOUtils.toString((InputStream)url.openStream());
        TestServiceTest.assertTrue((String)s, (boolean)s.contains("application/octet-stream"));
    }

    @Test
    public void testAutoFaultBeanProperties() throws Exception {
        this.testUtilities.setBus((Bus)this.applicationContext.getBean("cxf"));
        this.testUtilities.addDefaultNamespaces();
        this.testUtilities.addNamespace("ts", "http://cxf.org.apache/service");
        Server s = this.testUtilities.getServerForService(new QName("http://cxf.org.apache/service", "TestServiceService"));
        Document wsdl = this.testUtilities.getWSDLDocument(s);
        this.testUtilities.assertInvalid("//xsd:complexType[@name='TestServiceException']/xsd:sequence/xsd:element[@name='serialVersionUID']", (Node)wsdl);
        this.testUtilities.assertInvalid("//xsd:complexType[@name='TestServiceException']/xsd:sequence/xsd:element[@name='privateInt']", (Node)wsdl);
        this.testUtilities.assertValid("//xsd:complexType[@name='TestServiceException']/xsd:sequence/xsd:element[@name='publicString']", (Node)wsdl);
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:extrajaxbclass.xml"};
    }

    public TestService getTestClient() {
        return this.testClient;
    }

    public void setTestClient(TestService testClient) {
        this.testClient = testClient;
    }
}

