/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundDetails;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.BookSubresource;
import org.apache.cxf.systest.jaxrs.BookSubresourceImpl;
import org.apache.cxf.systest.jaxrs.CD;
import org.apache.cxf.systest.jaxrs.CDs;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/bookstore")
public class BookStore {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private Map<Long, CD> cds = new HashMap<Long, CD>();
    private long bookId = 123L;
    private long cdId = 123L;
    private String currentBookId;
    @PathParam(value="CDId")
    private String currentCdId;

    public BookStore() {
        this.init();
    }

    @GET
    @Path(value="webappexception")
    public Book throwException() {
        Response response = Response.serverError().entity((Object)"This is a WebApplicationException").build();
        throw new WebApplicationException(response);
    }

    @GET
    @Path(value="books/check/{id}")
    @ProduceMime(value={"text/plain"})
    public boolean checkBook(@PathParam(value="id") Long id) {
        return this.books.containsKey(id);
    }

    @GET
    @Path(value="timetable")
    public Calendar getTimetable() {
        return new GregorianCalendar();
    }

    @GET
    @Path(value="wrongparametertype")
    public void wrongParameterType(@QueryParam(value="p") Map p) {
        throw new IllegalStateException("This op is not expected to be invoked");
    }

    @GET
    @Path(value="exceptionduringconstruction")
    public void wrongParameterType(@QueryParam(value="p") BadBook p) {
        throw new IllegalStateException("This op is not expected to be invoked");
    }

    @POST
    @Path(value="/unsupportedcontenttype")
    @ConsumeMime(value={"application/xml"})
    public String unsupportedContentType() {
        throw new IllegalStateException("This op is not expected to be invoked");
    }

    @GET
    @Path(value="/bookurl/{URL}/")
    public Book getBookByURL(@PathParam(value="URL") String urlValue) throws Exception {
        String url2 = new URL(urlValue).toString();
        int index = url2.lastIndexOf(47);
        return this.doGetBook(url2.substring(index + 1));
    }

    @GET
    @Path(value="/segment/{pathsegment}/")
    public Book getBookBySegment(@PathParam(value="pathsegment") PathSegment segment) throws Exception {
        if (!"matrix2".equals(segment.getPath())) {
            throw new RuntimeException();
        }
        MultivaluedMap map = segment.getMatrixParameters();
        String s1 = ((String)map.getFirst((Object)"first")).toString();
        String s2 = ((String)map.getFirst((Object)"second")).toString();
        return this.doGetBook(s1 + s2);
    }

    @GET
    @Path(value="/segment/list/{pathsegment:.+}/")
    public Book getBookBySegment(@PathParam(value="pathsegment") List<PathSegment> list) throws Exception {
        return this.doGetBook(list.get(0).getPath() + list.get(1).getPath() + list.get(2).getPath());
    }

    @GET
    @Path(value="/segment/matrix")
    public Book getBookByMatrixParams(@MatrixParam(value="first") String s1, @MatrixParam(value="second") String s2) throws Exception {
        return this.doGetBook(s1 + s2);
    }

    @GET
    @Path(value="/bookheaders/")
    public Book getBookByHeader(@HeaderParam(value="BOOK") List<String> ids) throws Exception {
        return this.doGetBook(ids.get(0) + ids.get(1) + ids.get(2));
    }

    @GET
    @Path(value="/bookquery")
    public Book getBookByURLQuery(@QueryParam(value="urlid") String urlValue) throws Exception {
        String url2 = new URL(urlValue).toString();
        int index = url2.lastIndexOf(47);
        return this.doGetBook(url2.substring(index + 1));
    }

    @GET
    @Path(value="/books/{bookId}/")
    public Book getBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="books/custom/{bookId:\\d\\d\\d}")
    public Book getBookCustom(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/books/query")
    public Book getBookQuery(@QueryParam(value="bookId") long id) throws BookNotFoundFault {
        return this.doGetBook(Long.toString(id));
    }

    @GET
    @Path(value="/books/defaultquery")
    public Book getDefaultBookQuery(@DefaultValue(value="123") @QueryParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/books/missingquery")
    public Book getBookMissingQuery(@QueryParam(value="bookId") long id) throws BookNotFoundFault {
        if (id != 0L) {
            throw new RuntimeException();
        }
        return this.doGetBook("123");
    }

    @GET
    @Path(value="/books/element")
    public JAXBElement<Book> getBookElement() throws Exception {
        return new JAXBElement(new QName("", "Book"), Book.class, (Object)this.doGetBook("123"));
    }

    @GET
    @Path(value="/books/adapter")
    @XmlJavaTypeAdapter(value=BookInfoAdapter.class)
    public BookInfo getBookAdapter() throws Exception {
        return new BookInfo(this.doGetBook("123"));
    }

    @PathParam(value="bookId")
    public void setBookId(String id) {
        this.currentBookId = id;
    }

    @GET
    @Path(value="/books/{bookId}/")
    @ProduceMime(value={"application/json"})
    public Book getBookAsJSON() throws BookNotFoundFault {
        return this.doGetBook(this.currentBookId);
    }

    private Book doGetBook(String id) throws BookNotFoundFault {
        Book book = this.books.get(Long.parseLong(id));
        if (book != null) {
            return book;
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(Long.parseLong(id));
        throw new BookNotFoundFault(details);
    }

    @Path(value="/booksubresource/{bookId}/")
    public Book getBookSubResource(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        Book book = this.books.get(Long.parseLong(id));
        if (book != null) {
            return book;
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(Long.parseLong(id));
        throw new BookNotFoundFault(details);
    }

    @Path(value="/booksubresourceobject/{bookId}/")
    public Object getBookSubResourceObject(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.getBookSubResource(id);
    }

    @GET
    @Path(value="/booknames/{bookId}/")
    @ProduceMime(value={"text/*"})
    public String getBookName(@PathParam(value="bookId") int id) throws BookNotFoundFault {
        Book book = this.books.get(new Long(id));
        if (book != null) {
            return book.getName();
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(id);
        throw new BookNotFoundFault(details);
    }

    @POST
    @Path(value="/books")
    @ProduceMime(value={"text/xml"})
    @ConsumeMime(value={"application/xml"})
    public Response addBook(Book book) {
        book.setId(++this.bookId);
        this.books.put(book.getId(), book);
        return Response.ok((Object)book).build();
    }

    @POST
    @Path(value="/binarybooks")
    @ProduceMime(value={"text/xml"})
    @ConsumeMime(value={"application/octet-stream"})
    public Response addBinaryBook(long[] book) {
        return Response.ok((Object)book).build();
    }

    @PUT
    @Path(value="/books/")
    public Response updateBook(Book book) {
        Response r;
        Book b = this.books.get(book.getId());
        if (b != null) {
            this.books.put(book.getId(), book);
            r = Response.ok().build();
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @PUT
    @Path(value="/bookswithdom/")
    public DOMSource updateBook(DOMSource ds) {
        XMLUtils.printDOM((Node)ds.getNode());
        return ds;
    }

    @PUT
    @Path(value="/bookswithjson/")
    @ConsumeMime(value={"application/json"})
    public Response updateBookJSON(Book book) {
        Response r;
        Book b = this.books.get(book.getId());
        if (b != null) {
            this.books.put(book.getId(), book);
            r = Response.ok().build();
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @DELETE
    @Path(value="/books/{bookId}/")
    public Response deleteBook(@PathParam(value="bookId") String id) {
        Book b = this.books.get(Long.parseLong(id));
        Response r = b != null ? Response.ok().build() : Response.notModified().build();
        return r;
    }

    @DELETE
    @Path(value="/books/id")
    public Response deleteWithQuery(@QueryParam(value="value") @DefaultValue(value="-1") int id) {
        if (id != 123) {
            throw new WebApplicationException();
        }
        Book b = this.books.get(new Long(id));
        Response r = b != null ? Response.ok().build() : Response.notModified().build();
        return r;
    }

    @POST
    @Path(value="/booksplain")
    @ConsumeMime(value={"text/plain"})
    @ProduceMime(value={"text/plain"})
    public Long echoBookId(long theBookId) {
        return new Long(theBookId);
    }

    @GET
    @Path(value="/cd/{CDId}/")
    public CD getCD() {
        CD cd = this.cds.get(Long.parseLong(this.currentCdId));
        return cd;
    }

    @GET
    @Path(value="/cdwithmultitypes/{CDId}/")
    @ProduceMime(value={"application/xml", "application/json"})
    public CD getCDWithMultiContentTypes(@PathParam(value="CDId") String id) {
        CD cd = this.cds.get(Long.parseLong(id));
        return cd;
    }

    @GET
    @Path(value="/cds/")
    public CDs getCDs() {
        CDs c = new CDs();
        c.setCD(this.cds.values());
        return c;
    }

    @Path(value="/interface")
    public BookSubresource getBookFromSubresource() {
        return new BookSubresourceImpl();
    }

    final void init() {
        Book book = new Book();
        book.setId(this.bookId);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
        CD cd = new CD();
        cd.setId(this.cdId);
        cd.setName("BOHEMIAN RHAPSODY");
        this.cds.put(cd.getId(), cd);
        CD cd1 = new CD();
        cd1.setId(++this.cdId);
        cd1.setName("BICYCLE RACE");
        this.cds.put(cd1.getId(), cd1);
    }

    private static class BadBook {
        public BadBook(String s) {
            throw new RuntimeException("The bad book");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BookInfoAdapter
    extends XmlAdapter<Book, BookInfo> {
        public Book marshal(BookInfo v) throws Exception {
            return new Book(v.getName(), v.getId());
        }

        public BookInfo unmarshal(Book v) throws Exception {
            return null;
        }
    }

    private static class BookInfo {
        private String name;
        private long id;

        public BookInfo(Book b) {
            this.name = b.getName();
            this.id = b.getId();
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }
    }
}

