/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.Book2;
import org.apache.cxf.systest.jaxrs.Books;

@Path(value="/")
@ProduceMime(value={"application/json"})
public class BookStoreSpring {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private Long mainId = 123L;
    @Context
    private UriInfo ui;

    public BookStoreSpring() {
        this.init();
        System.out.println("----books: " + this.books.size());
    }

    @GET
    @Path(value="/books/list/{id}")
    public Books getBookAsJsonList(@PathParam(value="id") Long id) {
        return new Books(this.books.get(id));
    }

    @GET
    @Path(value="/books/{id}")
    @ProduceMime(value={"application/jettison", "application/json"})
    public Book getBookById(@PathParam(value="id") Long id) {
        return this.books.get(id);
    }

    @GET
    @Path(value="/bookinfo")
    public Book getBookByUriInfo() throws Exception {
        MultivaluedMap params = this.ui.getQueryParameters();
        String id = (String)params.getFirst((Object)"param1") + (String)params.getFirst((Object)"param2");
        return this.books.get(Long.valueOf(id));
    }

    @GET
    @Path(value="/booksquery")
    public Book getBookByQuery(@QueryParam(value="id") String id) {
        String[] values = id.split("\\+");
        StringBuilder b = new StringBuilder();
        b.append(values[0]).append(values[1]);
        return this.books.get(Long.valueOf(b.toString()));
    }

    @GET
    @Path(value="id={id}")
    public Book getBookByEncodedId(@PathParam(value="id") String id) {
        String[] values = id.split("\\+");
        StringBuilder b = new StringBuilder();
        b.append(values[0]).append(values[1]);
        return this.books.get(Long.valueOf(b.toString()));
    }

    @GET
    public Book getDefaultBook() {
        return this.books.get(this.mainId);
    }

    @POST
    @Path(value="books/convert")
    @ProduceMime(value={"application/xml"})
    @ConsumeMime(value={"application/xml", "application/json", "application/jettison"})
    public Book convertBook(Book2 book) {
        Book b = new Book();
        b.setId(book.getId());
        b.setName(book.getName());
        return b;
    }

    final void init() {
        Book book = new Book();
        book.setId(this.mainId);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
    }
}

