/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.systest.jaxrs.BookServerProxySpring;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSClientServerProxySpringBookTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerProxySpringBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerProxySpringBookTest.launchServer(BookServerProxySpring.class));
    }

    @Test
    public void testGetThatBook123() throws Exception {
        String endpointAddress = "http://localhost:9080/test/bookstorestorage/thosebooks/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/xml");
        InputStream in = connect.getInputStream();
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123.txt");
        JAXRSClientServerProxySpringBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetThatBookOverloaded() throws Exception {
        String endpointAddress = "http://localhost:9080/test/bookstorestorage/thosebooks/123/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/xml");
        InputStream in = connect.getInputStream();
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123.txt");
        JAXRSClientServerProxySpringBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetThatBookOverloaded2() throws Exception {
        String endpointAddress = "http://localhost:9080/test/bookstorestorage/thosebooks";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/xml");
        InputStream in = connect.getInputStream();
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123.txt");
        JAXRSClientServerProxySpringBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:9080/test/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/json");
        InputStream in = connect.getInputStream();
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123json.txt");
        JAXRSClientServerProxySpringBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }
}

